/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.actions.patterns.dataAccess;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.codeInsight.template.impl.MacroCallNode;
import com.intellij.codeInsight.template.macro.MacroFactory;
import com.intellij.jpa.facet.JpaFacet;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.spring.model.actions.generate.SpringBeanGenerateProvider;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.ElementPresentationManager;
import com.intellij.util.xml.actions.generate.DomTemplateRunner;
import com.intellij.util.xml.impl.DomTemplateRunnerImpl;
import java.util.LinkedHashSet;
import java.util.Map;

public class JpaEntityManagerBeanGenerateProvider
extends SpringBeanGenerateProvider {
    public JpaEntityManagerBeanGenerateProvider() {
        super("JPA Entity Manager Factory Bean", null);
    }

    protected void runTemplate(Editor editor, PsiFile file, SpringBean springBean, Map<String, String> predefinedVars) {
        super.runTemplate(editor, file, (DomElement)springBean, predefinedVars);
        ((DomTemplateRunnerImpl)DomTemplateRunner.getInstance((Project)file.getProject())).runTemplate((DomElement)springBean, editor, this.getTemplate(springBean), predefinedVars);
    }

    protected Template getTemplate(SpringBean springBean) {
        return JpaEntityManagerBeanGenerateProvider.getTemplate(springBean.getManager().getProject());
    }

    public static Template getTemplate(Project project) {
        TemplateManager manager = TemplateManager.getInstance((Project)project);
        Template template = manager.createTemplate("", "");
        template.setToReformat(true);
        MacroCallNode expression = new MacroCallNode(MacroFactory.createMacro((String)"complete"));
        Expression persistenceUnitExpression = JpaEntityManagerBeanGenerateProvider.getPersistenceUnitExpression();
        template.addTextSegment("<");
        template.addVariableSegment("NS_PREFIX");
        template.addTextSegment("bean id=\"");
        template.addVariable("BEAN_NAME", (Expression)expression, (Expression)expression, true);
        template.addTextSegment("\" class=\"org.springframework.orm.jpa.LocalEntityManagerFactoryBean\">\n <");
        template.addVariableSegment("NS_PREFIX");
        template.addTextSegment("property name=\"persistenceUnitName\" value=\"");
        template.addVariable("PERSISTENCE_UNIT", persistenceUnitExpression, persistenceUnitExpression, true);
        template.addTextSegment("\"/>\n</");
        template.addVariableSegment("NS_PREFIX");
        template.addTextSegment("bean>");
        return template;
    }

    private static Expression getPersistenceUnitExpression() {
        return new Expression(){

            public Result calculateResult(ExpressionContext context) {
                return new TextResult("");
            }

            public Result calculateQuickResult(ExpressionContext context) {
                return this.calculateResult(context);
            }

            public LookupElement[] calculateLookupItems(ExpressionContext context) {
                Project project = context.getProject();
                PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(context.getEditor().getDocument());
                if (psiFile == null) {
                    return LookupElement.EMPTY_ARRAY;
                }
                Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiFile);
                if (module == null) {
                    return LookupElement.EMPTY_ARRAY;
                }
                JpaFacet jpaFacet = JpaFacet.getInstance((Module)module);
                if (jpaFacet == null) {
                    return LookupElement.EMPTY_ARRAY;
                }
                LinkedHashSet<LookupElementBuilder> items = new LinkedHashSet<LookupElementBuilder>();
                for (PersistencePackage persistenceUnit : jpaFacet.getPersistenceUnits()) {
                    String stringValue = (String)persistenceUnit.getName().getValue();
                    if (!StringUtil.isNotEmpty((String)stringValue)) continue;
                    items.add(LookupElementBuilder.create((String)stringValue).withIcon(ElementPresentationManager.getIcon((Object)persistenceUnit)));
                }
                return items.toArray(new LookupElement[items.size()]);
            }
        };
    }
}

