/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.internal;

import com.android.ide.common.internal.ExecutorSingleton;
import com.android.ide.common.internal.LoggedErrorException;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class WaitableExecutor<T> {
    private final ExecutorService mExecutorService;
    private final CompletionService<T> mCompletionService;
    private final Set<Future<T>> mFutureSet = Sets.newHashSet();

    private WaitableExecutor(int nThreads) {
        if (nThreads < 1) {
            nThreads = Runtime.getRuntime().availableProcessors();
        }
        this.mExecutorService = Executors.newFixedThreadPool(nThreads);
        this.mCompletionService = new ExecutorCompletionService<T>(this.mExecutorService);
    }

    private WaitableExecutor() {
        this.mExecutorService = null;
        this.mCompletionService = new ExecutorCompletionService<T>(ExecutorSingleton.getExecutor());
    }

    public static <T> WaitableExecutor<T> useGlobalSharedThreadPool() {
        return new WaitableExecutor<T>();
    }

    public static <T> WaitableExecutor<T> useNewFixedSizeThreadPool(int nThreads) {
        return new WaitableExecutor<T>(nThreads);
    }

    public void execute(Callable<T> callable) {
        this.mFutureSet.add(this.mCompletionService.submit(callable));
    }

    public List<T> waitForTasksWithQuickFail(boolean cancelRemaining) throws InterruptedException, LoggedErrorException {
        ArrayList results = Lists.newArrayListWithCapacity((int)this.mFutureSet.size());
        try {
            while (!this.mFutureSet.isEmpty()) {
                Future<T> future = this.mCompletionService.take();
                assert (this.mFutureSet.contains(future));
                this.mFutureSet.remove(future);
                results.add(future.get());
            }
        }
        catch (ExecutionException e) {
            Throwable cause;
            if (cancelRemaining) {
                this.cancelAllTasks();
            }
            if ((cause = e.getCause()) instanceof LoggedErrorException) {
                throw (LoggedErrorException)cause;
            }
            throw new RuntimeException(cause);
        }
        finally {
            if (this.mExecutorService != null) {
                this.mExecutorService.shutdownNow();
            }
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TaskResult<T>> waitForAllTasks() throws InterruptedException {
        ArrayList results;
        block9: {
            results = Lists.newArrayListWithCapacity((int)this.mFutureSet.size());
            block5: while (true) {
                while (!this.mFutureSet.isEmpty()) {
                    Future<T> future = this.mCompletionService.take();
                    assert (this.mFutureSet.contains(future));
                    this.mFutureSet.remove(future);
                    try {
                        results.add(TaskResult.withValue(future.get()));
                        continue block5;
                    }
                    catch (ExecutionException e) {
                        Throwable cause = e.getCause();
                        if (cause instanceof InterruptedException) continue;
                        results.add(new TaskResult(cause));
                    }
                }
                break block9;
                {
                    continue block5;
                    break;
                }
                break;
            }
            finally {
                if (this.mExecutorService != null) {
                    this.mExecutorService.shutdownNow();
                }
            }
        }
        return results;
    }

    public void cancelAllTasks() {
        for (Future<T> future : this.mFutureSet) {
            future.cancel(true);
        }
    }

    public static final class TaskResult<T> {
        public T value;
        public Throwable exception;

        static <T> TaskResult<T> withValue(T value) {
            TaskResult<T> result = new TaskResult<T>(null);
            result.value = value;
            return result;
        }

        TaskResult(Throwable cause) {
            this.exception = cause;
        }
    }
}

