/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.execution.session;

import com.intellij.javascript.trace.execution.code.StaticCodeElement;
import com.intellij.javascript.trace.execution.common.ContextMetadata;
import com.intellij.javascript.trace.execution.common.OriginalTraceVirtualFile;
import com.intellij.javascript.trace.execution.fileDependency.FileDependencyRequest;
import com.intellij.javascript.trace.execution.fileDependency.FileDependencyVirtualFile;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.HashSet;
import java.util.Collection;
import java.util.Map;

public class TraceSessionCache {
    private Map<String, Map<String, OriginalTraceVirtualFile>> myVirtualFileMap = new HashMap();
    private Map<String, VirtualFile> myRemoteFileMap = new HashMap();
    private Map<String, String> myLocalFileMap = new HashMap();
    private Map<String, String> myFileIdMap = new HashMap();
    private Map<String, StaticCodeElement> myInstrumentMap = new HashMap();
    private Map<String, ContextMetadata> myContextMetadataMap = new HashMap();
    private HashSet<String> myFileIdsWithLoadedInstrumentMap = new HashSet();
    private HashSet<String> myCancelledRequests = new HashSet();
    private Map<FileDependencyRequest, FileDependencyVirtualFile> myFileDependencyFileMap = new HashMap();

    public synchronized String getRemoteUrlByLocalUrl(String localUrl) {
        return this.myLocalFileMap.get(localUrl);
    }

    public synchronized VirtualFile getLocalVirtualFileByRemoteUrl(String remoteUrl) {
        return this.myRemoteFileMap.get(remoteUrl);
    }

    public synchronized void putRemoteUrlLocalVirtualFile(VirtualFile file, String remoteUrl) {
        this.myLocalFileMap.put(file.getUrl(), remoteUrl);
        this.myRemoteFileMap.put(remoteUrl, file);
    }

    public synchronized OriginalTraceVirtualFile getTraceVirtualFileByIdAndStreamId(String fileId, String streamId) {
        Map<String, OriginalTraceVirtualFile> fileIdMap = this.myVirtualFileMap.get(streamId);
        if (fileIdMap == null) {
            return null;
        }
        return fileIdMap.get(fileId);
    }

    public synchronized void putTraceVirtualFileIdAndStreamId(String fileId, String streamId, OriginalTraceVirtualFile file) {
        HashMap fileIdMap = this.myVirtualFileMap.get(streamId);
        if (fileIdMap == null) {
            fileIdMap = new HashMap();
            this.myVirtualFileMap.put(streamId, (Map<String, OriginalTraceVirtualFile>)fileIdMap);
        }
        fileIdMap.put((String)fileId, (OriginalTraceVirtualFile)file);
    }

    public synchronized void putFileDependencyVirtualFile(FileDependencyRequest request, FileDependencyVirtualFile file) {
        this.myFileDependencyFileMap.put(request, file);
    }

    public synchronized OriginalTraceVirtualFile[] getTraceVirtualFilesStreamId(String streamId) {
        Map<String, OriginalTraceVirtualFile> fileIdMap = this.myVirtualFileMap.get(streamId);
        if (fileIdMap == null) {
            return new OriginalTraceVirtualFile[0];
        }
        return fileIdMap.values().toArray(new OriginalTraceVirtualFile[fileIdMap.size()]);
    }

    public synchronized FileDependencyVirtualFile getFileDependencyVirtualFile(FileDependencyRequest request) {
        return this.myFileDependencyFileMap.get(request);
    }

    public synchronized void putRemoteUrlFileId(String fileId, String remoteUrl) {
        this.myFileIdMap.put(fileId, remoteUrl);
    }

    public synchronized String getRemoteUrlByFileId(String fileId) {
        return this.myFileIdMap.get(fileId);
    }

    public synchronized StaticCodeElement getCodeElementById(String elementId) {
        return this.myInstrumentMap.get(elementId);
    }

    public synchronized void putCodeElementId(String elementId, StaticCodeElement element) {
        this.myInstrumentMap.put(elementId, element);
    }

    public synchronized String[] getFileIdsWithLoadedInstrumentationMap() {
        return ArrayUtil.toStringArray(this.myFileIdsWithLoadedInstrumentMap);
    }

    public synchronized void addFileIdsWithLoadedInstrumentationMap(Collection<String> fileIds) {
        this.myFileIdsWithLoadedInstrumentMap.addAll(fileIds);
    }

    public synchronized void putCancelledRequestId(String requestId) {
        this.myCancelledRequests.add((Object)requestId);
    }

    public synchronized boolean isRequestCancelled(String requestId) {
        return this.myCancelledRequests.contains((Object)requestId);
    }

    public synchronized void putContextMetadata(ContextMetadata contextMetadata) {
        this.myContextMetadataMap.put(contextMetadata.getId(), contextMetadata);
    }

    public synchronized ContextMetadata getContextMetadataById(String id) {
        return this.myContextMetadataMap.get(id);
    }

    public synchronized void clear() {
        this.myVirtualFileMap = new HashMap();
        this.myLocalFileMap = new HashMap();
        this.myRemoteFileMap = new HashMap();
        this.myFileIdMap = new HashMap();
        this.myInstrumentMap = new HashMap();
        this.myFileIdsWithLoadedInstrumentMap = new HashSet();
        this.myCancelledRequests = new HashSet();
    }
}

