/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.execution.events;

import com.google.common.collect.Lists;
import com.intellij.ide.browsers.BrowserFamily;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.javascript.trace.TraceBundle;
import com.intellij.javascript.trace.execution.Utils;
import com.intellij.javascript.trace.execution.common.EventMetadataExtended;
import com.intellij.javascript.trace.execution.events.EventGroupNode;
import com.intellij.javascript.trace.execution.events.EventNode;
import com.intellij.javascript.trace.execution.events.EventRootNode;
import com.intellij.javascript.trace.execution.events.EventStreamInterruptedNode;
import com.intellij.javascript.trace.execution.events.EventStreamLabelNode;
import com.intellij.javascript.trace.execution.events.EventTreeNode;
import com.intellij.javascript.trace.execution.events.NodeWithRemovableChildren;
import com.intellij.javascript.trace.settings.TraceProjectSettings;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.util.Consumer;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.containers.HashSet;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EventStreamNode
extends EventTreeNode
implements NodeWithRemovableChildren {
    private static final int EVENT_LIMIT = 1000;
    private int eventCount = 0;
    private List<EventTreeNode> myChildren = new ArrayList<EventTreeNode>();
    private Map<String, EventNode> myEvents = new LinkedHashMap<String, EventNode>();
    private boolean myExpanded;
    private String myStreamId;
    private HashSet<String> myRemovedEvents = new HashSet();
    private List<Consumer<EventTreeNode>> myCappedHandlers = new ArrayList<Consumer<EventTreeNode>>();
    private boolean myIsExpired;
    private String myText;
    private BrowserFamily myBrowserFamily;

    public EventStreamNode(EventRootNode parent, String streamId) {
        super(parent);
        this.myStreamId = streamId;
    }

    @Override
    public SimpleNode[] getChildren() {
        return this.myChildren.toArray(new SimpleNode[this.myChildren.size()]);
    }

    private void removeLastChildNode() {
        this.myChildren.remove(0);
    }

    private void add(EventTreeNode node) {
        this.myChildren.add(0, node);
    }

    private void capChildrenIfNecessary() {
        while (this.eventCount > 1000) {
            int firstChildIndex = this.myChildren.size() - 1;
            EventTreeNode firstChild = this.myChildren.get(firstChildIndex);
            if (firstChild instanceof EventGroupNode) {
                EventGroupNode group = (EventGroupNode)firstChild;
                this.notifyCapped(group.removeFirstChild());
                if (group.hasChildren()) continue;
                this.notifyCapped(this.myChildren.remove(firstChildIndex));
                continue;
            }
            EventTreeNode removed = this.myChildren.remove(firstChildIndex);
            this.notifyCapped(removed);
            if (!(removed instanceof EventNode)) continue;
            this.eventNodeRemoved((EventNode)removed);
        }
    }

    private void removeEventFromMap(EventNode removed) {
        this.myEvents.remove(String.valueOf(removed.getEventId()));
    }

    private void notifyCapped(EventTreeNode cappedNode) {
        for (Consumer<EventTreeNode> handler : this.myCappedHandlers) {
            handler.consume((Object)cappedNode);
        }
    }

    public void addCappedHandler(Consumer<EventTreeNode> onBeforeCapped) {
        this.myCappedHandlers.add(onBeforeCapped);
    }

    public void eventNodeRemoved(EventNode removed) {
        this.removeEventFromMap(removed);
        this.rememberRemovedEvent(removed.getEventId());
        --this.eventCount;
    }

    private void rememberRemovedEvent(long id) {
        this.myRemovedEvents.add((Object)String.valueOf(id));
    }

    public void setContextData(String url, String agent, String referrer) {
        this.setIcon(Utils.getAgentIcon(agent));
        if (Utils.isNodeJsAgent(agent)) {
            this.myText = url.length() > 45 ? StringUtil.first((String)url, (int)20, (boolean)true) + StringUtil.last((CharSequence)url, (int)25, (boolean)false) : url;
            this.setText(this.myText, false);
            this.setTooltip(String.format(TraceBundle.message("console.trace.events.nodeContextTooltipTemplate", new Object[0]), StringUtil.last((CharSequence)url, (int)100, (boolean)true), referrer == null || referrer.isEmpty() || url.equals(referrer) ? "" : String.format(TraceBundle.message("console.trace.events.nodeContextTooltipReferrerTemplate", new Object[0]), StringUtil.first((String)referrer, (int)100, (boolean)true))));
        } else {
            this.myBrowserFamily = Utils.getBrowserFamily(agent);
            Url documentUrl = Urls.parse((String)url, (boolean)false);
            if (documentUrl != null) {
                this.myText = documentUrl.getAuthority();
                this.setText(this.myText, false);
            }
            this.setTooltip(String.format(TraceBundle.message("console.trace.events.eventContextTooltipTemplate", new Object[0]), StringUtil.first((String)url, (int)100, (boolean)true), referrer == null || referrer.isEmpty() || url.equals(referrer) ? "" : String.format(TraceBundle.message("console.trace.events.eventContextTooltipReferrerTemplate", new Object[0]), StringUtil.first((String)referrer, (int)100, (boolean)true)), agent));
        }
    }

    private void setText(String text, boolean expired) {
        PresentationData presentation = this.getTemplatePresentation();
        presentation.clearText();
        presentation.addText(text, SimpleTextAttributes.REGULAR_ATTRIBUTES);
        if (expired) {
            presentation.addText("  " + TraceBundle.message("console.trace.events.expiredStream", new Object[0]), SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
    }

    private void setTooltip(String text) {
        this.getPresentation().setTooltip(text);
    }

    @Override
    protected void doUpdate() {
        super.doUpdate();
        this.setText(this.myText, this.myIsExpired);
    }

    public boolean addOrUpdateEvent(EventMetadataExtended eventData, @NotNull TraceProjectSettings.EventFilterState activeFilter) {
        EventTreeNode lastChildNode;
        if (activeFilter == null) {
            EventStreamNode.$$$reportNull$$$0(0);
        }
        if (this.hasEventBeenRemoved(eventData.getEventId())) {
            return false;
        }
        EventNode existingNode = this.getEventFromMap(eventData.getEventId());
        if (existingNode != null) {
            existingNode.updateEventData(eventData);
            return false;
        }
        EventNode addedNode = new EventNode(this, eventData);
        if (activeFilter.matchesEventName(addedNode.getName())) {
            return false;
        }
        if (activeFilter.matchesAllFileNames(eventData.getFiles())) {
            return false;
        }
        EventTreeNode eventTreeNode = lastChildNode = this.myChildren.isEmpty() ? null : this.myChildren.get(0);
        if (lastChildNode != null && lastChildNode.getName().equals(addedNode.getName()) && (lastChildNode instanceof EventGroupNode || lastChildNode instanceof EventNode)) {
            EventGroupNode existingGroup;
            EventGroupNode eventGroupNode = existingGroup = lastChildNode instanceof EventGroupNode ? (EventGroupNode)lastChildNode : null;
            if (existingGroup != null) {
                existingGroup.add(addedNode);
            } else {
                EventGroupNode newGroup = new EventGroupNode(this, (EventNode)lastChildNode);
                this.removeLastChildNode();
                newGroup.add((EventNode)lastChildNode);
                newGroup.add(addedNode);
                this.add(newGroup);
            }
        } else {
            this.add(addedNode);
        }
        this.putEventToMap(addedNode);
        ++this.eventCount;
        this.capChildrenIfNecessary();
        return true;
    }

    private boolean hasEventBeenRemoved(long id) {
        return this.myRemovedEvents.contains((Object)String.valueOf(id));
    }

    private EventNode getEventFromMap(long eventId) {
        return this.myEvents.get(String.valueOf(eventId));
    }

    private void putEventToMap(EventNode node) {
        this.myEvents.put(String.valueOf(node.getEventId()), node);
    }

    @Override
    public void removeChild(EventTreeNode nodeToRemove) {
        this.myChildren.remove((Object)nodeToRemove);
        if (nodeToRemove instanceof EventNode) {
            this.eventNodeRemoved((EventNode)nodeToRemove);
        } else if (nodeToRemove instanceof EventGroupNode) {
            EventGroupNode group = (EventGroupNode)nodeToRemove;
            while (group.hasChildren()) {
                group.removeFirstChild();
            }
        }
        if (this.myChildren.isEmpty()) {
            this.myExpanded = false;
        }
    }

    public String getStreamId() {
        return this.myStreamId;
    }

    public void expanded() {
        this.myExpanded = true;
    }

    public boolean shouldBeExpanded() {
        return !this.myExpanded;
    }

    public void interrupted() {
        this.add(new EventStreamInterruptedNode(this));
    }

    public void labelled() {
        this.add(new EventStreamLabelNode(this));
    }

    public void expired() {
        this.myIsExpired = true;
    }

    public void activated() {
        this.myIsExpired = false;
    }

    public boolean isExpired() {
        return this.myIsExpired;
    }

    public BrowserFamily getBrowserFamily() {
        return this.myBrowserFamily;
    }

    @NotNull
    public EventNode[] getAllEventNodesOrderedByOccurenceTimeDesc() {
        ArrayList<EventNode> values = new ArrayList<EventNode>(this.myEvents.values());
        EventNode[] eventNodeArray = Lists.reverse(values).toArray(new EventNode[values.size()]);
        if (eventNodeArray == null) {
            EventStreamNode.$$$reportNull$$$0(1);
        }
        return eventNodeArray;
    }

    @Nullable
    public EventNode getEventNodeByEventId(long eventId) {
        return this.myEvents.get(String.valueOf(eventId));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activeFilter";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/trace/execution/events/EventStreamNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/trace/execution/events/EventStreamNode";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllEventNodesOrderedByOccurenceTimeDesc";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "addOrUpdateEvent";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

