/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.execution.context;

import com.intellij.javascript.trace.TraceBundle;
import com.intellij.javascript.trace.execution.common.RuntimeFunctionArgument;
import com.intellij.javascript.trace.execution.common.RuntimeFunctionScope;
import com.intellij.javascript.trace.execution.context.ArgumentsValue;
import com.intellij.javascript.trace.execution.context.AutoExpandableValue;
import com.intellij.javascript.trace.execution.context.CommentedValuePresentation;
import com.intellij.javascript.trace.execution.context.ExceptionValue;
import com.intellij.javascript.trace.execution.context.ReturnValue;
import com.intellij.javascript.trace.execution.context.StackFrameContext;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import org.jetbrains.annotations.NotNull;

public class FunctionSummaryValue
extends XNamedValue
implements AutoExpandableValue {
    private final RuntimeFunctionScope myStackFrame;
    private final int myArgumentsCount;
    private final boolean myNoReturn;
    private final boolean myUnhandledException;
    private StackFrameContext myContext;

    public FunctionSummaryValue(StackFrameContext context) {
        super(context.getStackFrame().isProgram() != false ? TraceBundle.message("console.trace.context.program", new Object[0]) : TraceBundle.message("console.trace.context.function", new Object[0]));
        this.myStackFrame = context.getStackFrame();
        this.myContext = context;
        this.myArgumentsCount = this.myStackFrame.getArguments().length;
        this.myNoReturn = !this.myStackFrame.hasReturnValue();
        this.myUnhandledException = this.myStackFrame.hasException();
    }

    public void computePresentation(@NotNull XValueNode node, @NotNull XValuePlace place) {
        if (node == null) {
            FunctionSummaryValue.$$$reportNull$$$0(0);
        }
        if (place == null) {
            FunctionSummaryValue.$$$reportNull$$$0(1);
        }
        node.setPresentation(this.myContext.getStackFrameIcon(), (XValuePresentation)new CommentedValuePresentation(node, this.myContext.getStackFrameName(), String.format(TraceBundle.message("console.trace.context.functionCommentTemplate", new Object[0]), this.myArgumentsCount > 0 ? Integer.valueOf(this.myArgumentsCount) : "no", this.myArgumentsCount == 1 ? "" : "s", this.myNoReturn ? TraceBundle.message("console.trace.context.functionCommentNoReturn", new Object[0]) : "", this.myUnhandledException ? TraceBundle.message("console.trace.context.functionCommentUnhandledError", new Object[0]) : ""), false), this.myStackFrame.isDumpCaptured() && (this.myStackFrame.hasReturnValue() || this.myStackFrame.isProgram() == false && this.myStackFrame.getArguments().length > 0) || this.myStackFrame.hasException());
    }

    public void computeChildren(@NotNull XCompositeNode node) {
        if (node == null) {
            FunctionSummaryValue.$$$reportNull$$$0(2);
        }
        XValueChildrenList children = new XValueChildrenList();
        if (this.myStackFrame.isDumpCaptured()) {
            RuntimeFunctionArgument[] arguments = this.myStackFrame.getArguments();
            if (!this.myStackFrame.isProgram().booleanValue() && arguments.length > 0) {
                children.add((XNamedValue)new ArgumentsValue(arguments));
            }
            if (this.myStackFrame.hasReturnValue()) {
                children.add((XNamedValue)new ReturnValue(this.myStackFrame.getReturnValue()));
            }
        }
        if (this.myStackFrame.hasException()) {
            children.add((XNamedValue)new ExceptionValue(this.myStackFrame.getExceptionValue()));
        }
        node.addChildren(children, true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        objectArray2[1] = "com/intellij/javascript/trace/execution/context/FunctionSummaryValue";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "computePresentation";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "computeChildren";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

