/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.execution.common;

import com.intellij.execution.ExecutionManager;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.javascript.trace.debugger.ExpressionEvaluator;
import com.intellij.javascript.trace.execution.common.OriginalTraceVirtualFile;
import com.intellij.javascript.trace.execution.common.TraceContext;
import com.intellij.javascript.trace.execution.common.TraceSession;
import com.intellij.javascript.trace.execution.common.TraceVirtualFile;
import com.intellij.javascript.trace.settings.TraceSettings;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Consumer;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IndexedPsiFile {
    private final int myFunctionNumber;
    private final TraceContext myTraceContext;
    private String myPath;
    private TraceSession myTraceSession;
    private PsiFile myPsiFile;
    private ExpressionEvaluator myEvaluator;
    private static final Key<Integer> TRACED_FUNCTION_ID = Key.create((String)"spy-js.traced.function.id");
    private static final Key<IndexedPsiFile> INDEXED_PSI_FILE_KEY = Key.create((String)"spy-js.indexed.psi.file");
    public static final Integer PROGRAM_ID = 1;

    private IndexedPsiFile(@NotNull TraceContext traceContext, @NotNull PsiFile psiFile, @NotNull String path) {
        if (traceContext == null) {
            IndexedPsiFile.$$$reportNull$$$0(0);
        }
        if (psiFile == null) {
            IndexedPsiFile.$$$reportNull$$$0(1);
        }
        if (path == null) {
            IndexedPsiFile.$$$reportNull$$$0(2);
        }
        this.myTraceContext = traceContext;
        this.myPath = path;
        this.myTraceSession = traceContext.getTraceSession();
        this.myPsiFile = psiFile;
        this.subscribeToSessionEvents();
        this.myFunctionNumber = IndexedPsiFile.indexPsiFile(psiFile);
        this.myPsiFile.putUserData(INDEXED_PSI_FILE_KEY, (Object)this);
    }

    private void subscribeToSessionEvents() {
        this.myTraceSession.onTraceFileChanged((Consumer<VirtualFile>)((Consumer)changedFile -> {
            if (this.myPsiFile.getVirtualFile().equals(changedFile)) {
                this.dispose();
            }
        }));
        this.myTraceSession.onSessionStopped(() -> this.dispose());
    }

    @Nullable
    public static IndexedPsiFile getIndexedPsiFile(@NotNull Project project, @NotNull PsiFile file, boolean forRealtimeEvaluation) {
        if (project == null) {
            IndexedPsiFile.$$$reportNull$$$0(3);
        }
        if (file == null) {
            IndexedPsiFile.$$$reportNull$$$0(4);
        }
        VirtualFile virtualFile = file.getVirtualFile();
        boolean isTraceFile = virtualFile instanceof OriginalTraceVirtualFile;
        IndexedPsiFile indexedPsiFile = (IndexedPsiFile)file.getUserData(INDEXED_PSI_FILE_KEY);
        if (indexedPsiFile != null) {
            return indexedPsiFile;
        }
        List descriptors = ExecutionManager.getInstance((Project)project).getContentManager().getAllDescriptors();
        if (descriptors.isEmpty()) {
            return null;
        }
        TraceContext context = null;
        String url = null;
        for (RunContentDescriptor descriptor : descriptors) {
            TraceSettings config;
            TraceSession session;
            TraceContext traceContext;
            ProcessHandler processHandler = descriptor.getProcessHandler();
            if (processHandler == null || (traceContext = (TraceContext)processHandler.getUserData(TraceContext.KEY)) == null || !(session = traceContext.getTraceSession()).isRunning()) continue;
            if (isTraceFile && session.getLoadedTracedSourceFiles(((TraceVirtualFile)virtualFile).getStreamId()).length > 0) {
                return new IndexedPsiFile(traceContext, file, virtualFile.getPath());
            }
            if (session.isLoaded() || (config = session.getSettings()) == null || forRealtimeEvaluation && !config.isRealtimeEvaluationEnabled() || (url = session.getRemoteTracedFile(file.getVirtualFile())) == null) continue;
            context = traceContext;
            break;
        }
        if (context == null) {
            return null;
        }
        return new IndexedPsiFile(context, file, url);
    }

    private void dispose() {
        this.myPsiFile.putUserData(INDEXED_PSI_FILE_KEY, null);
    }

    @NotNull
    public ExpressionEvaluator getEvaluator() {
        if (this.myEvaluator == null) {
            this.myEvaluator = new ExpressionEvaluator(this.myTraceSession, this, this.myTraceSession.getRemoteTracedFile(this.myPsiFile.getVirtualFile()));
        }
        ExpressionEvaluator expressionEvaluator = this.myEvaluator;
        if (expressionEvaluator == null) {
            IndexedPsiFile.$$$reportNull$$$0(5);
        }
        return expressionEvaluator;
    }

    private static int indexPsiFile(@NotNull PsiFile file) {
        if (file == null) {
            IndexedPsiFile.$$$reportNull$$$0(6);
        }
        final Integer[] functionId = new Integer[]{PROGRAM_ID};
        PsiTreeUtil.processElements((PsiElement)file, (PsiElementProcessor)new PsiElementProcessor(){

            public boolean execute(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (element instanceof JSFunction) {
                    Integer id = functionId[0] = Integer.valueOf(functionId[0] + 1);
                    element.putUserData(TRACED_FUNCTION_ID, (Object)id);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/javascript/trace/execution/common/IndexedPsiFile$1", "execute"));
            }
        });
        return functionId[0];
    }

    @Nullable
    public Integer getFunctionId(@Nullable PsiElement position) {
        Integer currentFunctionId = PROGRAM_ID;
        if (position == null) {
            return currentFunctionId;
        }
        JSFunction type = (JSFunction)PsiTreeUtil.getParentOfType((PsiElement)position, JSFunction.class);
        if (type != null) {
            currentFunctionId = (Integer)type.getUserData(TRACED_FUNCTION_ID);
        }
        return currentFunctionId;
    }

    public int getFunctionNumber() {
        return this.myFunctionNumber;
    }

    @NotNull
    public PsiFile getPsiFile() {
        PsiFile psiFile = this.myPsiFile;
        if (psiFile == null) {
            IndexedPsiFile.$$$reportNull$$$0(7);
        }
        return psiFile;
    }

    @NotNull
    public TraceContext getContext() {
        TraceContext traceContext = this.myTraceContext;
        if (traceContext == null) {
            IndexedPsiFile.$$$reportNull$$$0(8);
        }
        return traceContext;
    }

    public String getPath() {
        return this.myPath;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "traceContext";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/trace/execution/common/IndexedPsiFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/trace/execution/common/IndexedPsiFile";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getEvaluator";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiFile";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getIndexedPsiFile";
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "indexPsiFile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

