/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.execution.common;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.javascript.trace.TraceBundle;
import com.intellij.javascript.trace.execution.Utils;
import com.intellij.javascript.trace.execution.code.CodeElement;
import com.intellij.lang.javascript.ui.NodeModuleNamesUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.SimpleTextAttributes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FunctionNamePresentation {
    private final String myFunc;
    private final String myFileShortName;
    private final String myModule;
    private static final String ANONYMOUS_FUNC_PREFIX = "[a]";
    private static final String ANONYMOUS_SELF_INVOKED_FUNC_PREFIX = "[i]";
    private static final String ANONYMOUS_ARGUMENT_FUNC_PREFIX = "[c]";
    private static final String ANONYMOUS_RETURNED_FUNC_PREFIX = "[r]";
    private String myAnonymousId;
    private boolean myIsAnonymousSelfInvoked;
    private String myOwnerName;
    private boolean myIsAnonymousArgument;
    private boolean myIsAnonymousReturnValue;
    private StringBuilder myBuilder;
    private boolean myHasException;
    private boolean myIsProgram;

    public FunctionNamePresentation(@NotNull CodeElement codeElement, boolean isProgram, boolean hasException) {
        String prefix;
        if (codeElement == null) {
            FunctionNamePresentation.$$$reportNull$$$0(0);
        }
        this.myIsProgram = isProgram;
        this.myHasException = hasException;
        this.myFunc = codeElement.getFunc();
        String file = codeElement.getFile();
        this.myFileShortName = Utils.getShortFileName(file, 15);
        this.myModule = NodeModuleNamesUtil.getModule((String)file);
        String[] nameParts = this.myFunc.split(":");
        if (nameParts.length > 0 && ((prefix = nameParts[0]).equals(ANONYMOUS_FUNC_PREFIX) || prefix.equals(ANONYMOUS_SELF_INVOKED_FUNC_PREFIX) || prefix.equals(ANONYMOUS_ARGUMENT_FUNC_PREFIX) || prefix.equals(ANONYMOUS_RETURNED_FUNC_PREFIX)) && nameParts.length > 1) {
            this.myAnonymousId = nameParts[1];
            if (prefix.equals(ANONYMOUS_SELF_INVOKED_FUNC_PREFIX)) {
                this.myIsAnonymousSelfInvoked = true;
            }
            if (nameParts.length > 2) {
                this.myOwnerName = nameParts[2];
                if (prefix.equals(ANONYMOUS_ARGUMENT_FUNC_PREFIX) && nameParts.length > 2) {
                    this.myIsAnonymousArgument = true;
                }
                if (prefix.equals(ANONYMOUS_RETURNED_FUNC_PREFIX) && nameParts.length > 2) {
                    this.myIsAnonymousReturnValue = true;
                }
            }
        }
    }

    private String appendToText(String str) {
        this.myBuilder.append(str);
        return str;
    }

    @NotNull
    public String buildFullName(@NotNull PresentationData presentation, boolean includeFileName, @Nullable Double executionTime, boolean takesSignificantTimeToExecute) {
        if (presentation == null) {
            FunctionNamePresentation.$$$reportNull$$$0(1);
        }
        this.myBuilder = new StringBuilder();
        if (includeFileName && !StringUtil.isEmpty((String)this.myModule)) {
            presentation.addText(this.appendToText(this.myModule), SimpleTextAttributes.GRAY_ATTRIBUTES);
            presentation.addText(this.appendToText(" "), SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
        if (includeFileName) {
            presentation.addText(this.appendToText(this.myFileShortName), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            presentation.addText(this.appendToText("  "), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
        }
        presentation.addText(this.appendToText(this.getFunctionName()), this.myHasException ? SimpleTextAttributes.ERROR_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES);
        presentation.addText(this.appendToText("  "), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
        if (this.myIsAnonymousArgument || this.myIsAnonymousReturnValue || this.myIsAnonymousSelfInvoked) {
            if (this.myIsAnonymousArgument) {
                presentation.addText(this.appendToText(String.format(TraceBundle.message("console.trace.stack.anonArgFuncNameTemplate", new Object[0]), this.myOwnerName)), SimpleTextAttributes.GRAY_ATTRIBUTES);
            } else if (this.myIsAnonymousReturnValue) {
                presentation.addText(this.appendToText(String.format(TraceBundle.message("console.trace.stack.anonRetFuncNameTemplate", new Object[0]), this.myOwnerName)), SimpleTextAttributes.GRAY_ATTRIBUTES);
            } else {
                presentation.addText(this.appendToText(TraceBundle.message("console.trace.stack.anonIIFEFuncNameTemplate", new Object[0])), SimpleTextAttributes.GRAY_ATTRIBUTES);
            }
            presentation.addText(this.appendToText("  "), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
        }
        if (executionTime != null) {
            presentation.addText(this.appendToText(Utils.formatExecutionTime(executionTime) + TraceBundle.message("console.trace.timeSuffix", new Object[0])), takesSignificantTimeToExecute ? new SimpleTextAttributes(1, SimpleTextAttributes.SYNTHETIC_ATTRIBUTES.getFgColor()) : SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
        }
        String string = this.myBuilder.toString();
        if (string == null) {
            FunctionNamePresentation.$$$reportNull$$$0(2);
        }
        return string;
    }

    public String getFunctionName() {
        if (this.myAnonymousId != null) {
            return String.format(TraceBundle.message("console.trace.stack.anonFuncNameTemplate", new Object[0]), this.myAnonymousId);
        }
        if (this.myIsProgram) {
            return TraceBundle.message("console.trace.stack.programScopeName", new Object[0]);
        }
        return this.myFunc;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/trace/execution/common/FunctionNamePresentation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/trace/execution/common/FunctionNamePresentation";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFullName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "buildFullName";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

