/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.execution.actions;

import com.intellij.icons.AllIcons;
import com.intellij.javascript.trace.TraceBundle;
import com.intellij.javascript.trace.settings.TraceConfigurable;
import com.intellij.javascript.trace.settings.TraceProjectSettings;
import com.intellij.javascript.trace.settings.TraceSettingsManager;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class SetEventFilterAction
extends AnAction
implements CustomComponentAction {
    private final Project myProject;
    private TraceSettingsManager myTraceSettingsManager;

    public SetEventFilterAction(@NotNull Project project, @NotNull TraceSettingsManager traceSettingsManager) {
        if (project == null) {
            SetEventFilterAction.$$$reportNull$$$0(0);
        }
        if (traceSettingsManager == null) {
            SetEventFilterAction.$$$reportNull$$$0(1);
        }
        super(TraceBundle.message("console.trace.toolbar.filterEvents", new Object[0]), null, AllIcons.General.Filter);
        this.myProject = project;
        this.myTraceSettingsManager = traceSettingsManager;
    }

    public void actionPerformed(AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        JComponent button = (JComponent)presentation.getClientProperty("button");
        assert (button != null);
        DefaultActionGroup group = SetEventFilterAction.createPopupActionGroup(this.myProject, this.myTraceSettingsManager);
        ActionPopupMenu popupMenu = ActionManager.getInstance().createActionPopupMenu("unknown", (ActionGroup)group);
        popupMenu.getComponent().show(button, button.getWidth(), 0);
    }

    public JComponent createCustomComponent(Presentation presentation) {
        ActionButton button = new ActionButton(this, presentation, "unknown", ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE){

            public int getPopState() {
                int state = super.getPopState();
                if (!TraceProjectSettings.EventFilterState.NULL_FILTER.equals(SetEventFilterAction.this.myTraceSettingsManager.getActiveFilter()) && state != -1) {
                    return -1;
                }
                return state;
            }
        };
        presentation.putClientProperty("button", (Object)button);
        return button;
    }

    public static DefaultActionGroup createPopupActionGroup(final Project project, final TraceSettingsManager traceSettingsManager) {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new EventFilterApplier(TraceBundle.message("console.trace.toolbar.filterEvents.allName", new Object[0]), TraceBundle.message("console.trace.toolbar.filterEvents.allDescription", new Object[0]), TraceProjectSettings.EventFilterState.NULL_FILTER, traceSettingsManager));
        group.add((AnAction)new EventFilterApplier(TraceBundle.message("console.trace.toolbar.filterEvents.nothingName", new Object[0]), TraceBundle.message("console.trace.toolbar.filterEvents.nothingDescription", new Object[0]), TraceProjectSettings.EventFilterState.ALL_FILTER, traceSettingsManager));
        for (TraceProjectSettings.EventFilterState filter : traceSettingsManager.getFilters()) {
            group.add((AnAction)new EventFilterApplier(filter.getName(), null, filter, traceSettingsManager));
        }
        group.addSeparator();
        group.add(new AnAction(TraceBundle.message("console.trace.toolbar.filterEvents.edit", new Object[0]), TraceBundle.message("console.trace.toolbar.filterEvents.edit", new Object[0]), AllIcons.General.Settings){

            public void actionPerformed(AnActionEvent e) {
                ShowSettingsUtil util = ShowSettingsUtil.getInstance();
                util.editConfigurable(project, (Configurable)new TraceConfigurable(project, traceSettingsManager));
            }
        });
        return group;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "traceSettingsManager";
                break;
            }
        }
        objectArray[1] = "com/intellij/javascript/trace/execution/actions/SetEventFilterAction";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class EventFilterApplier
    extends ToggleAction {
        private TraceProjectSettings.EventFilterState myFilter;
        private TraceSettingsManager myTraceSettingsManager;

        EventFilterApplier(String text, String description, @NotNull TraceProjectSettings.EventFilterState filter, TraceSettingsManager traceSettingsManager) {
            if (filter == null) {
                EventFilterApplier.$$$reportNull$$$0(0);
            }
            super(null, description, null);
            this.myFilter = filter;
            this.myTraceSettingsManager = traceSettingsManager;
            this.getTemplatePresentation().setText(StringUtil.first((String)text, (int)45, (boolean)true), false);
        }

        public void update(AnActionEvent e) {
            super.update(e);
            if (!TraceProjectSettings.EventFilterState.isAllOrNothingFilter(this.myFilter)) {
                e.getPresentation().setVisible(this.myFilter.isActive());
                e.getPresentation().setEnabled(!this.myFilter.isEmpty());
            }
        }

        public boolean isSelected(AnActionEvent e) {
            String activeFilterName = this.myTraceSettingsManager.getActiveFilterName();
            return this.myFilter == TraceProjectSettings.EventFilterState.NULL_FILTER && StringUtil.isEmpty((String)activeFilterName) || Comparing.equal((String)this.myFilter.getName(), (String)activeFilterName);
        }

        public void setSelected(AnActionEvent e, boolean state) {
            if (state) {
                this.myTraceSettingsManager.setAndApplyFilter(this.myFilter.getName());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/javascript/trace/execution/actions/SetEventFilterAction$EventFilterApplier", "<init>"));
        }
    }
}

