/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.execution;

import com.intellij.icons.AllIcons;
import com.intellij.ide.browsers.BrowserFamily;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.PathUtil;
import icons.SpyJSIcons;
import java.io.File;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Utils {
    static final boolean SOURCE_MAPS_IN_NODE_JS = false;
    private static final DecimalFormat TIME_FORMAT = new DecimalFormat("#.####");

    public static String getShortFileName(String url) {
        return Utils.getShortFileName(url, 50);
    }

    private static String getShortFileNameWithExtension(String url, int max) {
        if (StringUtil.isEmpty((String)url)) {
            return url;
        }
        int sepIndex = Math.max(url.lastIndexOf("/"), url.lastIndexOf("\\"));
        String shortName = url.substring(sepIndex + 1);
        int end = (url = shortName.isEmpty() ? url : shortName).lastIndexOf("?");
        if (end > 0) {
            shortName = url.substring(0, end);
            String string = url = shortName.isEmpty() ? url : shortName;
        }
        if (max > 0) {
            return StringUtil.first((String)url, (int)max, (boolean)true);
        }
        return url;
    }

    public static String getShortFileNameWithExtension(String url) {
        return Utils.getShortFileNameWithExtension(url, 35);
    }

    public static String getFileNameWithExtension(String url) {
        return Utils.getShortFileNameWithExtension(url, Integer.MAX_VALUE);
    }

    public static String getShortFileName(String file, int max) {
        String shortName;
        String url = Utils.getShortFileNameWithExtension(file, 0);
        int end = url.lastIndexOf(".min.js");
        if (end > 0) {
            shortName = url.substring(0, end);
            String string = url = shortName.isEmpty() ? url : shortName;
        }
        if ((end = url.lastIndexOf(".js")) > 0) {
            shortName = url.substring(0, end);
            url = shortName.isEmpty() ? url : shortName;
        }
        String result = max > 0 ? StringUtil.first((String)url, (int)max, (boolean)true) : url;
        return "index".equals(result) ? Utils.getShortFileName(PathUtil.getParentPath((String)file), 15) : result;
    }

    public static String getServerScriptPath(String scriptFileName, boolean useDist) {
        if (useDist) {
            String jarPath = PathUtil.getJarPathForClass(Utils.class);
            File jarFile = new File(jarPath);
            if (!jarPath.endsWith(".jar")) {
                return new File(jarPath, "server/" + scriptFileName).getPath();
            }
            if (!jarFile.isFile()) {
                throw new RuntimeException("jar file cannot be null");
            }
            File pluginBaseDir = jarFile.getParentFile().getParentFile();
            return new File(pluginBaseDir, "server/" + scriptFileName).getPath();
        }
        String jarPath = PathUtil.getJarPathForClass(Utils.class);
        File jarFile = new File(jarPath);
        File rootDir = jarFile.getParentFile().getParentFile().getParentFile().getParentFile();
        return new File(rootDir, "plugins/spy-js/server/" + scriptFileName).getPath();
    }

    public static String formatExecutionTime(double time) {
        try {
            return TIME_FORMAT.format(time);
        }
        catch (Exception ignored) {
            return "-";
        }
    }

    @Nullable
    public static BrowserFamily getBrowserFamily(@NotNull String agent) {
        if (agent == null) {
            Utils.$$$reportNull$$$0(0);
        }
        if (agent.startsWith("Chrome")) {
            return BrowserFamily.CHROME;
        }
        if (agent.startsWith("Safari") || agent.startsWith("Mobile Safari")) {
            return BrowserFamily.SAFARI;
        }
        if (agent.startsWith("Opera")) {
            return BrowserFamily.OPERA;
        }
        if (agent.startsWith("Firefox")) {
            return BrowserFamily.FIREFOX;
        }
        if (agent.startsWith("IE")) {
            return BrowserFamily.EXPLORER;
        }
        return null;
    }

    @NotNull
    private static Icon getBrowserIcon(@Nullable BrowserFamily browserFamily, @NotNull String agent) {
        if (agent == null) {
            Utils.$$$reportNull$$$0(1);
        }
        if (browserFamily != null) {
            Icon icon = browserFamily.getIcon();
            if (icon == null) {
                Utils.$$$reportNull$$$0(2);
            }
            return icon;
        }
        if (agent.startsWith("Yandex")) {
            Icon icon = AllIcons.Xml.Browsers.Yandex16;
            if (icon == null) {
                Utils.$$$reportNull$$$0(3);
            }
            return icon;
        }
        Icon icon = SpyJSIcons.CommonBrowser;
        if (icon == null) {
            Utils.$$$reportNull$$$0(4);
        }
        return icon;
    }

    @NotNull
    public static Icon getAgentIcon(@NotNull String agent) {
        if (agent == null) {
            Utils.$$$reportNull$$$0(5);
        }
        if (Utils.isNodeJsAgent(agent)) {
            Icon icon = SpyJSIcons.Nodejs_16;
            if (icon == null) {
                Utils.$$$reportNull$$$0(6);
            }
            return icon;
        }
        Icon icon = Utils.getBrowserIcon(Utils.getBrowserFamily(agent), agent);
        if (icon == null) {
            Utils.$$$reportNull$$$0(7);
        }
        return icon;
    }

    public static boolean isNodeJsAgent(@NotNull String agent) {
        if (agent == null) {
            Utils.$$$reportNull$$$0(8);
        }
        return agent.equals("node.js");
    }

    static {
        TIME_FORMAT.setRoundingMode(RoundingMode.HALF_UP);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "agent";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/trace/execution/Utils";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/trace/execution/Utils";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getBrowserIcon";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAgentIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getBrowserFamily";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getBrowserIcon";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getAgentIcon";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isNodeJsAgent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

