/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.execution;

import com.intellij.execution.configuration.EnvironmentVariablesComponent;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.trace.execution.TraceLimits;
import com.intellij.javascript.trace.execution.TraceNodeRunConfigurationSettings;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashMap;
import java.util.Map;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TraceNodeSettingsSerializationUtil {
    private static final String CONFIG = "config";
    private static final String PROXY_PORT = "proxy-port";
    private static final String NODE = "node";
    private static final String NODE_PARAMS = "node-params";
    private static final String APP_PARAMS = "app-params";
    private static final String APP = "app";
    private static final String WORKING_DIR = "working-dir";
    private static final String PASS_PARENT_ENV = "pass-parent-env";

    private TraceNodeSettingsSerializationUtil() {
    }

    public static TraceNodeRunConfigurationSettings readFromXml(@NotNull Element element) {
        if (element == null) {
            TraceNodeSettingsSerializationUtil.$$$reportNull$$$0(0);
        }
        NodeJsInterpreterRef interpreterRef = TraceNodeSettingsSerializationUtil.toNodeInterpreterRef(TraceNodeSettingsSerializationUtil.getAttrValue(element, NODE));
        String configPath = FileUtil.toSystemDependentName((String)StringUtil.notNullize((String)TraceNodeSettingsSerializationUtil.getAttrValue(element, CONFIG)));
        String proxyPortAttrValue = TraceNodeSettingsSerializationUtil.getAttrValue(element, PROXY_PORT);
        int proxyPort = proxyPortAttrValue == null ? 3547 : Integer.parseInt(proxyPortAttrValue);
        HashMap env = ContainerUtil.newHashMap();
        EnvironmentVariablesComponent.readExternal((Element)element, (Map)env);
        String nodeParams = FileUtil.toSystemDependentName((String)StringUtil.notNullize((String)TraceNodeSettingsSerializationUtil.getAttrValue(element, NODE_PARAMS)));
        String appParams = FileUtil.toSystemDependentName((String)StringUtil.notNullize((String)TraceNodeSettingsSerializationUtil.getAttrValue(element, APP_PARAMS)));
        String appPath = FileUtil.toSystemDependentName((String)StringUtil.notNullize((String)TraceNodeSettingsSerializationUtil.getAttrValue(element, APP)));
        String workingDirPath = FileUtil.toSystemDependentName((String)StringUtil.notNullize((String)TraceNodeSettingsSerializationUtil.getAttrValue(element, WORKING_DIR)));
        boolean passParentEnv = Boolean.parseBoolean(StringUtil.notNullize((String)TraceNodeSettingsSerializationUtil.getAttrValue(element, PASS_PARENT_ENV), (String)"false"));
        return new TraceNodeRunConfigurationSettings(proxyPort, configPath, TraceLimits.readExternal(element), interpreterRef, nodeParams, workingDirPath, appPath, appParams, env, passParentEnv);
    }

    @NotNull
    private static NodeJsInterpreterRef toNodeInterpreterRef(@Nullable String value) {
        NodeJsInterpreterRef nodeJsInterpreterRef = StringUtil.isEmpty((String)value) ? NodeJsInterpreterRef.createProjectRef() : NodeJsInterpreterRef.create((String)value);
        if (nodeJsInterpreterRef == null) {
            TraceNodeSettingsSerializationUtil.$$$reportNull$$$0(1);
        }
        return nodeJsInterpreterRef;
    }

    @Nullable
    private static String getAttrValue(Element element, String attrKey) {
        Attribute attribute = element.getAttribute(attrKey);
        return attribute != null ? attribute.getValue() : null;
    }

    public static void writeToXml(@NotNull Element element, @NotNull TraceNodeRunConfigurationSettings settings) {
        if (element == null) {
            TraceNodeSettingsSerializationUtil.$$$reportNull$$$0(2);
        }
        if (settings == null) {
            TraceNodeSettingsSerializationUtil.$$$reportNull$$$0(3);
        }
        element.setAttribute(CONFIG, FileUtil.toSystemIndependentName((String)settings.getConfigPath()));
        element.setAttribute(NODE, settings.getNodeInterpreterRef().getReferenceName());
        element.setAttribute(NODE_PARAMS, FileUtil.toSystemIndependentName((String)settings.getNodeParams()));
        element.setAttribute(APP, FileUtil.toSystemIndependentName((String)settings.getAppPath()));
        element.setAttribute(APP_PARAMS, FileUtil.toSystemIndependentName((String)settings.getAppParams()));
        element.setAttribute(WORKING_DIR, FileUtil.toSystemIndependentName((String)settings.getWorkingDir()));
        element.setAttribute(PROXY_PORT, String.valueOf(settings.getProxyPort()));
        EnvironmentVariablesComponent.writeExternal((Element)element, settings.getEnv());
        element.setAttribute(PASS_PARENT_ENV, String.valueOf(settings.isPassParentEnv()));
        if (settings.getTraceLimits() != null) {
            settings.getTraceLimits().writeExternal(element);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/trace/execution/TraceNodeSettingsSerializationUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/trace/execution/TraceNodeSettingsSerializationUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "toNodeInterpreterRef";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "readFromXml";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "writeToXml";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

