/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.execution;

import com.intellij.execution.actions.StopProcessAction;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.filters.TextConsoleBuilderImpl;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.DeferingPrinter;
import com.intellij.execution.testframework.HyperLink;
import com.intellij.execution.testframework.Printable;
import com.intellij.execution.testframework.Printer;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ExecutionConsoleEx;
import com.intellij.execution.ui.ObservableConsoleView;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.icons.AllIcons;
import com.intellij.ide.HelpIdProvider;
import com.intellij.javascript.trace.TraceBundle;
import com.intellij.javascript.trace.execution.TraceConsoleProperties;
import com.intellij.javascript.trace.execution.TracePanel;
import com.intellij.javascript.trace.execution.TraceServerLogComponent;
import com.intellij.javascript.trace.execution.actions.CloseAllDiagramFilesAction;
import com.intellij.javascript.trace.execution.actions.CloseAllTraceFilesAction;
import com.intellij.javascript.trace.execution.common.TraceLoadedHandler;
import com.intellij.javascript.trace.execution.common.TraceSession;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.ui.ComponentWithActions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.content.Content;
import icons.SpyJSIcons;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TraceConsoleView
implements ConsoleView,
ObservableConsoleView,
HelpIdProvider,
ExecutionConsoleEx {
    private Printer myPrinter;
    private ConsoleView myConsole;
    private TraceConsoleProperties myProperties;
    private final TraceSession myTraceSession;
    private final ExecutionEnvironment myEnvironment;
    private TracePanel myTracePanel;
    private TraceServerLogComponent myTraceServerLogComponent;
    private Content myConsoleContent;

    public TraceConsoleView(TraceConsoleProperties properties, TraceSession traceSession, ExecutionEnvironment environment) {
        this.myProperties = properties;
        this.myTraceSession = traceSession;
        this.myEnvironment = environment;
        this.myTracePanel = new TracePanel(this.myProperties.getConfiguration(), this.myEnvironment, this.myTraceSession, this.myProperties, this);
        this.myConsole = new TextConsoleBuilderImpl(properties.getProject()).getConsole();
        this.myPrinter = new DeferingPrinter();
        Disposer.register((Disposable)this, (Disposable)this.myConsole);
        this.myTraceSession.onSessionStopped(() -> {
            if (this.myProperties.needToCloseTraceFilesOnSessionStop()) {
                CloseAllTraceFilesAction.execute(this.myProperties.getProject());
            }
            if (this.myProperties.needToCloseDiagramFilesOnSessionStop()) {
                CloseAllDiagramFilesAction.execute(this.myProperties.getProject());
            }
        });
        this.myTraceSession.onTraceLoaded(new TraceLoadedHandler(){

            @Override
            public void traceLoaded(@NotNull String traceId) {
                if (traceId == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!StringUtil.isEmpty((String)traceId)) {
                    TraceConsoleView.this.myConsoleContent.setDisplayName(String.format(TraceBundle.message("console.trace.header.loaded", new Object[0]), traceId));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "traceId", "com/intellij/javascript/trace/execution/TraceConsoleView$1", "traceLoaded"));
            }
        });
    }

    public void initUI() {
        this.myTracePanel.initUI();
        Disposer.register((Disposable)this, (Disposable)this.myTracePanel);
    }

    public void print(@NotNull String s, @NotNull ConsoleViewContentType contentType) {
        if (s == null) {
            TraceConsoleView.$$$reportNull$$$0(0);
        }
        if (contentType == null) {
            TraceConsoleView.$$$reportNull$$$0(1);
        }
        this.myPrinter.print(s, contentType);
    }

    public void clear() {
        this.myConsole.clear();
        if (this.myTraceServerLogComponent != null) {
            this.myTraceServerLogComponent.clear();
        }
    }

    public void scrollTo(int offset) {
        this.myConsole.scrollTo(offset);
    }

    public void attachToProcess(ProcessHandler processHandler) {
        this.myConsole.attachToProcess(processHandler);
    }

    public boolean isOutputPaused() {
        return false;
    }

    public void setOutputPaused(boolean value) {
        throw new UnsupportedOperationException();
    }

    public boolean hasDeferredOutput() {
        return this.myConsole.hasDeferredOutput();
    }

    public void performWhenNoDeferredOutput(@NotNull Runnable runnable) {
        if (runnable == null) {
            TraceConsoleView.$$$reportNull$$$0(2);
        }
        this.myConsole.performWhenNoDeferredOutput(runnable);
    }

    public void addMessageFilter(@NotNull Filter filter) {
        if (filter == null) {
            TraceConsoleView.$$$reportNull$$$0(3);
        }
        this.myConsole.addMessageFilter(filter);
    }

    public void printHyperlink(@NotNull String hyperlinkText, HyperlinkInfo info) {
        if (hyperlinkText == null) {
            TraceConsoleView.$$$reportNull$$$0(4);
        }
        this.printNew((Printable)new HyperLink(hyperlinkText, info));
    }

    private void printNew(Printable printable) {
        if (this.myPrinter != null) {
            this.myPrinter.onNewAvailable(printable);
        }
    }

    public int getContentSize() {
        return this.myConsole.getContentSize();
    }

    public boolean canPause() {
        return false;
    }

    @NotNull
    public AnAction[] createConsoleActions() {
        if (AnAction.EMPTY_ARRAY == null) {
            TraceConsoleView.$$$reportNull$$$0(5);
        }
        return AnAction.EMPTY_ARRAY;
    }

    public void allowHeavyFilters() {
    }

    public JComponent getComponent() {
        return this.myTracePanel;
    }

    public JComponent getPreferredFocusableComponent() {
        return this.myTracePanel;
    }

    @Nullable
    public String getHelpId() {
        return "reference.tool.window.spyjs";
    }

    public void setHelpId(@NotNull String helpId) {
        if (helpId == null) {
            TraceConsoleView.$$$reportNull$$$0(6);
        }
        this.myConsole.setHelpId(helpId);
    }

    public void addChangeListener(@NotNull ObservableConsoleView.ChangeListener listener, @NotNull Disposable parent) {
        if (listener == null) {
            TraceConsoleView.$$$reportNull$$$0(7);
        }
        if (parent == null) {
            TraceConsoleView.$$$reportNull$$$0(8);
        }
        ((ObservableConsoleView)this.myConsole).addChangeListener(listener, parent);
    }

    public void buildUi(RunnerLayoutUi layoutUi) {
        this.registerTraceTab(layoutUi);
        this.registerProxyTab(layoutUi);
    }

    private void registerTraceTab(RunnerLayoutUi layoutUi) {
        layoutUi.getOptions().setMinimizeActionEnabled(false);
        this.myConsoleContent = layoutUi.createContent("ConsoleContent", this.getComponent(), TraceBundle.message("console.trace.header", new Object[0]), SpyJSIcons.Spy_js_run, this.getPreferredFocusableComponent());
        layoutUi.addContent(this.myConsoleContent, 1, PlaceInGrid.bottom, false);
        this.myConsoleContent.setCloseable(false);
    }

    private void registerProxyTab(RunnerLayoutUi layoutUi) {
        this.myTraceServerLogComponent = new TraceServerLogComponent(this.myEnvironment.getProject(), (Disposable)this, (AnAction)new StopProcessAction(TraceBundle.message("console.server.label.stop", new Object[0]), TraceBundle.message("console.server.description.stop", new Object[0]), this.myTraceSession.getProcessHandler()));
        layoutUi.getOptions().setMinimizeActionEnabled(false);
        final Content consoleContent = layoutUi.createContent(TraceBundle.message("console.server.consoleContentId", new Object[0]), (ComponentWithActions)this.myTraceServerLogComponent, this.myTraceSession.isNodeJsSession() ? TraceBundle.message("console.server.node.header", new Object[0]) : TraceBundle.message("console.server.header", new Object[0]), AllIcons.Debugger.Console, this.getPreferredFocusableComponent());
        layoutUi.addContent(consoleContent, 2, PlaceInGrid.bottom, false);
        consoleContent.setCloseable(false);
        this.myTraceSession.getProcessHandler().addProcessListener((ProcessListener)new ProcessAdapter(){

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (outputType == null) {
                    2.$$$reportNull$$$0(1);
                }
                String text = event.getText();
                TraceConsoleView.this.myTraceServerLogComponent.print(text, ConsoleViewContentType.getConsoleViewType((Key)outputType));
                if (outputType.equals((Object)ProcessOutputTypes.STDERR)) {
                    ApplicationManager.getApplication().invokeLater(() -> consoleContent.fireAlert(), ModalityState.any());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "outputType";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/javascript/trace/execution/TraceConsoleView$2";
                objectArray[2] = "onTextAvailable";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    @Nullable
    public String getExecutionConsoleId() {
        return null;
    }

    public void dispose() {
    }

    public TracePanel getTracePanel() {
        return this.myTracePanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hyperlinkText";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/trace/execution/TraceConsoleView";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helpId";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/trace/execution/TraceConsoleView";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createConsoleActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "print";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "performWhenNoDeferredOutput";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addMessageFilter";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "printHyperlink";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setHelpId";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addChangeListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

