/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.debugger.values;

import com.intellij.javascript.trace.debugger.values.TraceValueManager;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.values.StringValue;
import org.jetbrains.debugger.values.ValueType;

public class TraceString
implements StringValue {
    private TraceValueManager myValueManager;
    private String myExpression;
    private final boolean myIsTruncated;
    private final int myLength;
    private String myValue;

    public TraceString(@NotNull TraceValueManager valueManager, @NotNull String expression, int length, String value) {
        if (valueManager == null) {
            TraceString.$$$reportNull$$$0(0);
        }
        if (expression == null) {
            TraceString.$$$reportNull$$$0(1);
        }
        this.myValueManager = valueManager;
        this.myExpression = expression;
        this.myIsTruncated = length > StringUtil.notNullize((String)value).length();
        this.myLength = length;
        this.myValue = value;
        this.myValueManager = valueManager;
        this.myExpression = expression;
    }

    public boolean isTruncated() {
        return this.myIsTruncated;
    }

    public int getLength() {
        return this.myLength;
    }

    public Promise<String> getFullString() {
        return this.myValueManager.getFullString(this.myExpression).done(s -> {
            this.myValue = s;
        });
    }

    @NotNull
    public ValueType getType() {
        ValueType valueType = ValueType.STRING;
        if (valueType == null) {
            TraceString.$$$reportNull$$$0(2);
        }
        return valueType;
    }

    public String getValueString() {
        return this.myValue;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueManager";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/trace/debugger/values/TraceString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/trace/debugger/values/TraceString";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

