/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.output.parser.javac;

import com.android.ide.common.blame.Message;
import com.android.ide.common.blame.SourceFilePosition;
import com.android.ide.common.blame.SourcePosition;
import com.android.ide.common.blame.parser.ParsingFailedException;
import com.android.ide.common.blame.parser.PatternAwareOutputParser;
import com.android.ide.common.blame.parser.util.OutputLineReader;
import com.android.utils.ILogger;
import com.google.common.collect.Lists;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavacOutputParser
implements PatternAwareOutputParser {
    private static final char COLON = ':';
    private static final String WARNING_PREFIX = "warning:";

    public boolean parse(@NotNull String line, @NotNull OutputLineReader reader, @NotNull List<Message> messages, @NotNull ILogger logger) throws ParsingFailedException {
        int colonIndex1;
        if (line == null) {
            JavacOutputParser.$$$reportNull$$$0(0);
        }
        if (reader == null) {
            JavacOutputParser.$$$reportNull$$$0(1);
        }
        if (messages == null) {
            JavacOutputParser.$$$reportNull$$$0(2);
        }
        if (logger == null) {
            JavacOutputParser.$$$reportNull$$$0(3);
        }
        if ((colonIndex1 = line.indexOf(58)) == 1) {
            colonIndex1 = line.indexOf(58, colonIndex1 + 1);
        }
        if (colonIndex1 >= 0) {
            String part1 = line.substring(0, colonIndex1).trim();
            if (part1.equalsIgnoreCase("error") || part1.equalsIgnoreCase("Caused by")) {
                String text = line.substring(colonIndex1 + 1).trim();
                JavacOutputParser.addMessage(new Message(Message.Kind.ERROR, text, SourceFilePosition.UNKNOWN, new SourceFilePosition[0]), messages);
                return true;
            }
            if (part1.equalsIgnoreCase("warning")) {
                String text = line.substring(colonIndex1 + 1).trim();
                JavacOutputParser.addMessage(new Message(Message.Kind.WARNING, text, SourceFilePosition.UNKNOWN, new SourceFilePosition[0]), messages);
                return true;
            }
            if (part1.equalsIgnoreCase("javac")) {
                JavacOutputParser.addMessage(new Message(Message.Kind.ERROR, line, SourceFilePosition.UNKNOWN, new SourceFilePosition[0]), messages);
                return true;
            }
            int colonIndex2 = line.indexOf(58, colonIndex1 + 1);
            if (colonIndex2 >= 0) {
                File file = new File(part1);
                if (!file.isFile()) {
                    return false;
                }
                try {
                    int column;
                    int lineNumber = Integer.parseInt(line.substring(colonIndex1 + 1, colonIndex2).trim());
                    String text = line.substring(colonIndex2 + 1).trim();
                    Message.Kind kind = Message.Kind.ERROR;
                    if (text.startsWith(WARNING_PREFIX)) {
                        text = text.substring(WARNING_PREFIX.length()).trim();
                        kind = Message.Kind.WARNING;
                    }
                    if (!file.getPath().endsWith(".java")) {
                        return false;
                    }
                    List<Object> messageList = Lists.newArrayList();
                    messageList.add(text);
                    String prevLine = null;
                    while (true) {
                        String nextLine;
                        if ((nextLine = reader.readLine()) == null) {
                            return false;
                        }
                        if (nextLine.trim().equals("^")) {
                            column = nextLine.indexOf(94);
                            String messageEnd = reader.readLine();
                            while (JavacOutputParser.isMessageEnd(messageEnd)) {
                                messageList.add(messageEnd.trim());
                                messageEnd = reader.readLine();
                            }
                            if (messageEnd == null) break;
                            reader.pushBack();
                            break;
                        }
                        if (prevLine != null) {
                            messageList.add(prevLine);
                        }
                        prevLine = nextLine;
                    }
                    if (column >= 0) {
                        messageList = JavacOutputParser.convertMessages(messageList);
                        String msgText = StringUtil.join((Collection)messageList, (String)SystemProperties.getLineSeparator());
                        Message msg = new Message(kind, msgText, new SourceFilePosition(file, new SourcePosition(lineNumber - 1, column, -1)), new SourceFilePosition[0]);
                        JavacOutputParser.addMessage(msg, messages);
                        return true;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        if (line.endsWith("java.lang.OutOfMemoryError")) {
            JavacOutputParser.addMessage(new Message(Message.Kind.ERROR, "Out of memory.", SourceFilePosition.UNKNOWN, new SourceFilePosition[0]), messages);
            return true;
        }
        return false;
    }

    private static void addMessage(@NotNull Message message, @NotNull List<Message> messages) {
        if (message == null) {
            JavacOutputParser.$$$reportNull$$$0(4);
        }
        if (messages == null) {
            JavacOutputParser.$$$reportNull$$$0(5);
        }
        boolean duplicatesPrevious = false;
        int messageCount = messages.size();
        if (messageCount > 0) {
            Message lastMessage = messages.get(messageCount - 1);
            duplicatesPrevious = lastMessage.equals(message);
        }
        if (!duplicatesPrevious) {
            messages.add(message);
        }
    }

    @Contract(value="null -> false")
    private static boolean isMessageEnd(@Nullable String line) {
        return line != null && line.length() > 0 && Character.isWhitespace(line.charAt(0));
    }

    @NotNull
    private static List<String> convertMessages(@NotNull List<String> messages) {
        String part1;
        if (messages == null) {
            JavacOutputParser.$$$reportNull$$$0(6);
        }
        if (messages.size() <= 1) {
            List<String> list = messages;
            if (list == null) {
                JavacOutputParser.$$$reportNull$$$0(7);
            }
            return list;
        }
        String line0 = messages.get(0);
        String line1 = messages.get(1);
        int colonIndex = line1.indexOf(58);
        if (colonIndex > 0 && "symbol".equals(part1 = line1.substring(0, colonIndex).trim())) {
            String symbol = line1.substring(colonIndex + 1).trim();
            messages.remove(1);
            if (messages.size() >= 2) {
                messages.remove(1);
            }
            messages.set(0, line0 + " " + symbol);
        }
        List<String> list = messages;
        if (list == null) {
            JavacOutputParser.$$$reportNull$$$0(8);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 2: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messages";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logger";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/output/parser/javac/JavacOutputParser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/output/parser/javac/JavacOutputParser";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "convertMessages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "parse";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addMessage";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "convertMessages";
                break;
            }
            case 7: 
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

