/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.beanValidation.toolWindow.tree.nodes;

import com.intellij.beanValidation.resources.BVBundle;
import com.intellij.beanValidation.toolWindow.tree.nodes.AbstractBVTypeNode;
import com.intellij.beanValidation.toolWindow.tree.nodes.BVModuleNode;
import com.intellij.beanValidation.toolWindow.tree.nodes.BVNodeTypes;
import com.intellij.beanValidation.toolWindow.tree.nodes.PsiMemberSimpleNode;
import com.intellij.beanValidation.toolWindow.tree.nodes.ValidatorTypeNode;
import com.intellij.beanValidation.utils.BVUtils;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiClass;
import com.intellij.ui.treeStructure.SimpleNode;
import icons.BVCoreIcons;
import java.util.Collection;

public class ValidatorsNode
extends AbstractBVTypeNode {
    public ValidatorsNode(Module module, BVModuleNode moduleNode) {
        super(moduleNode, module, BVNodeTypes.VALIDATORS, BVBundle.message("actions.show.validators", new Object[0]));
    }

    @Override
    protected void update(PresentationData presentation) {
        super.update(presentation);
        presentation.setIcon(BVCoreIcons.ConstraintValidator);
    }

    @Override
    public SimpleNode[] getChildren() {
        Collection<PsiClass> validators = BVUtils.getConstraintValidators(this.getModule());
        Collection<PsiMemberSimpleNode> nodes = ValidatorsNode.createSortedList();
        for (PsiClass psiClass : validators) {
            nodes.add(new ValidatorTypeNode(this.getModule(), psiClass, this));
        }
        return nodes.toArray(new SimpleNode[nodes.size()]);
    }
}

