/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.beanValidation.highlighting;

import com.intellij.beanValidation.highlighting.checkers.BvChecker;
import com.intellij.beanValidation.highlighting.checkers.CheckAnnotationIsConstraint;
import com.intellij.beanValidation.highlighting.checkers.CheckClassIsConstraintAnnotation;
import com.intellij.beanValidation.highlighting.checkers.CheckMissingParameters;
import com.intellij.beanValidation.model.xml.BvMappingsDomElement;
import com.intellij.beanValidation.resources.BVBundle;
import com.intellij.beanValidation.resources.BVInspectionBundle;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.highlighting.BasicDomElementsInspection;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import com.intellij.util.xml.highlighting.DomHighlightingHelper;
import java.util.HashMap;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class BvConstraintMappingsInspection
extends BasicDomElementsInspection<BvMappingsDomElement> {
    private static final HashMap<String, BvChecker[]> CHECKERS = new HashMap();

    private static void register(String key, BvChecker ... checkers) {
        CHECKERS.put(key, checkers);
    }

    public BvConstraintMappingsInspection() {
        super(BvMappingsDomElement.class, new Class[0]);
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = BVInspectionBundle.message("model.inspection.group.name", new Object[0]);
        if (string == null) {
            BvConstraintMappingsInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = BVBundle.message("constraints.config.inspection", new Object[0]);
        if (string == null) {
            BvConstraintMappingsInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        if (string == null) {
            BvConstraintMappingsInspection.$$$reportNull$$$0(2);
        }
        return string;
    }

    protected void checkDomElement(DomElement element, DomElementAnnotationHolder holder, DomHighlightingHelper helper) {
        GenericDomValue value;
        String checkerId;
        BvChecker[] checkers;
        super.checkDomElement(element, holder, helper);
        if (element instanceof GenericDomValue && (checkers = CHECKERS.get(checkerId = BvConstraintMappingsInspection.getCheckerId(value = (GenericDomValue)element))) != null) {
            for (BvChecker checker : checkers) {
                checker.check(value, holder, helper);
            }
        }
    }

    private static String getCheckerId(@NotNull GenericDomValue value) {
        DomElement parent;
        if (value == null) {
            BvConstraintMappingsInspection.$$$reportNull$$$0(3);
        }
        return (parent = value.getParent()) == null ? value.getXmlElementName() : parent.getXmlElementName() + "/" + value.getXmlElementName();
    }

    static {
        BvConstraintMappingsInspection.register("constraint/annotation", new CheckClassIsConstraintAnnotation(), new CheckMissingParameters());
        BvConstraintMappingsInspection.register("element/name", new CheckAnnotationIsConstraint());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/beanValidation/highlighting/BvConstraintMappingsInspection";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/beanValidation/highlighting/BvConstraintMappingsInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getCheckerId";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

