/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import java.rmi.RemoteException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.server.MavenServerIndexerException;
import org.jetbrains.idea.maven.server.MavenServerProcessCanceledException;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenProcessCanceledException;

public abstract class RemoteObjectWrapper<T> {
    @Nullable
    private final RemoteObjectWrapper<?> myParent;
    @Nullable
    private T myWrappee;

    protected RemoteObjectWrapper(@Nullable RemoteObjectWrapper<?> parent) {
        this.myParent = parent;
    }

    @Nullable
    protected synchronized T getWrappee() {
        return this.myWrappee == null ? null : (T)this.myWrappee;
    }

    @NotNull
    protected synchronized T getOrCreateWrappee() throws RemoteException {
        if (this.myWrappee == null) {
            this.myWrappee = this.create();
            this.onWrappeeCreated();
        }
        this.onWrappeeAccessed();
        T t = this.myWrappee;
        if (t == null) {
            RemoteObjectWrapper.$$$reportNull$$$0(0);
        }
        return t;
    }

    @NotNull
    protected abstract T create() throws RemoteException;

    protected void onWrappeeCreated() throws RemoteException {
    }

    protected void onWrappeeAccessed() {
        if (this.myParent != null) {
            this.myParent.onWrappeeAccessed();
        }
    }

    protected synchronized void handleRemoteError(RemoteException e) {
        MavenLog.LOG.debug("Connection failed. Will be reconnected on the next request.", (Throwable)e);
        this.onError();
    }

    protected synchronized void onError() {
        this.cleanup();
        if (this.myParent != null) {
            this.myParent.onError();
        }
    }

    protected synchronized void cleanup() {
        this.myWrappee = null;
    }

    protected <T> T perform(Retriable<T> r) {
        RemoteException last = null;
        for (int i = 0; i < 2; ++i) {
            try {
                return r.execute();
            }
            catch (RemoteException e) {
                last = e;
                this.handleRemoteError(last);
                continue;
            }
        }
        throw new RuntimeException("Cannot reconnect.", last);
    }

    protected <T> T perform(RetriableCancelable<T> r) throws MavenProcessCanceledException {
        RemoteException last = null;
        for (int i = 0; i < 2; ++i) {
            try {
                return r.execute();
            }
            catch (RemoteException e) {
                last = e;
                this.handleRemoteError(last);
                continue;
            }
            catch (MavenServerProcessCanceledException e) {
                throw new MavenProcessCanceledException();
            }
        }
        throw new RuntimeException("Cannot reconnect.", last);
    }

    protected <T> T perform(IndexRetriable<T> r) throws MavenServerIndexerException {
        RemoteException last = null;
        for (int i = 0; i < 2; ++i) {
            try {
                return r.execute();
            }
            catch (RemoteException e) {
                last = e;
                this.handleRemoteError(last);
                continue;
            }
        }
        throw new RuntimeException("Cannot reconnect.", last);
    }

    protected <T> T perform(IndexRetriableCancelable<T> r) throws MavenServerIndexerException, MavenProcessCanceledException {
        RemoteException last = null;
        for (int i = 0; i < 2; ++i) {
            try {
                return r.execute();
            }
            catch (RemoteException e) {
                last = e;
                this.handleRemoteError(last);
                continue;
            }
            catch (MavenServerProcessCanceledException e) {
                throw new MavenProcessCanceledException();
            }
        }
        throw new RuntimeException("Cannot reconnect.", last);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/server/RemoteObjectWrapper", "getOrCreateWrappee"));
    }

    protected static interface RetriableCancelable<T> {
        public T execute() throws RemoteException, MavenServerProcessCanceledException;
    }

    protected static interface IndexRetriableCancelable<T> {
        public T execute() throws RemoteException, MavenServerIndexerException, MavenServerProcessCanceledException;
    }

    protected static interface IndexRetriable<T> {
        public T execute() throws RemoteException, MavenServerIndexerException;
    }

    protected static interface Retriable<T> {
        public T execute() throws RemoteException;
    }
}

