/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Transient;
import gnu.trove.THashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.execution.MavenExecutionOptions;
import org.jetbrains.idea.maven.server.MavenServerManager;
import org.jetbrains.idea.maven.utils.MavenJDOMUtil;
import org.jetbrains.idea.maven.utils.MavenUtil;

public class MavenGeneralSettings
implements Cloneable {
    private boolean workOffline = false;
    private String mavenHome = ApplicationManager.getApplication().isUnitTestMode() ? "Bundled (Maven 2)" : "Bundled (Maven 3)";
    private String mavenSettingsFile = "";
    private String overriddenLocalRepository = "";
    private boolean printErrorStackTraces = false;
    private boolean usePluginRegistry = false;
    private boolean nonRecursive = false;
    private boolean alwaysUpdateSnapshots = false;
    private String threads;
    private MavenExecutionOptions.LoggingLevel outputLevel = MavenExecutionOptions.LoggingLevel.INFO;
    private MavenExecutionOptions.ChecksumPolicy checksumPolicy = MavenExecutionOptions.ChecksumPolicy.NOT_SET;
    private MavenExecutionOptions.FailureMode failureBehavior = MavenExecutionOptions.FailureMode.NOT_SET;
    private MavenExecutionOptions.PluginUpdatePolicy pluginUpdatePolicy = MavenExecutionOptions.PluginUpdatePolicy.DEFAULT;
    private File myEffectiveLocalRepositoryCache;
    private Set<String> myDefaultPluginsCache;
    private int myBulkUpdateLevel = 0;
    private List<Listener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();

    public void beginUpdate() {
        ++this.myBulkUpdateLevel;
    }

    public void endUpdate() {
        if (--this.myBulkUpdateLevel == 0) {
            this.changed();
        }
    }

    public void changed() {
        if (this.myBulkUpdateLevel > 0) {
            return;
        }
        this.myEffectiveLocalRepositoryCache = null;
        this.myDefaultPluginsCache = null;
        this.fireChanged();
    }

    @Property
    @NotNull
    public MavenExecutionOptions.PluginUpdatePolicy getPluginUpdatePolicy() {
        MavenExecutionOptions.PluginUpdatePolicy pluginUpdatePolicy = this.pluginUpdatePolicy;
        if (pluginUpdatePolicy == null) {
            MavenGeneralSettings.$$$reportNull$$$0(0);
        }
        return pluginUpdatePolicy;
    }

    public void setPluginUpdatePolicy(MavenExecutionOptions.PluginUpdatePolicy value) {
        if (value == null) {
            return;
        }
        this.pluginUpdatePolicy = value;
        this.changed();
    }

    @Property
    @NotNull
    public MavenExecutionOptions.ChecksumPolicy getChecksumPolicy() {
        MavenExecutionOptions.ChecksumPolicy checksumPolicy = this.checksumPolicy;
        if (checksumPolicy == null) {
            MavenGeneralSettings.$$$reportNull$$$0(1);
        }
        return checksumPolicy;
    }

    public void setChecksumPolicy(MavenExecutionOptions.ChecksumPolicy value) {
        if (value == null) {
            return;
        }
        this.checksumPolicy = value;
        this.changed();
    }

    @Property
    @NotNull
    public MavenExecutionOptions.FailureMode getFailureBehavior() {
        MavenExecutionOptions.FailureMode failureMode = this.failureBehavior;
        if (failureMode == null) {
            MavenGeneralSettings.$$$reportNull$$$0(2);
        }
        return failureMode;
    }

    public void setFailureBehavior(MavenExecutionOptions.FailureMode value) {
        if (value == null) {
            return;
        }
        this.failureBehavior = value;
        this.changed();
    }

    @Transient
    @Deprecated
    @NotNull
    public MavenExecutionOptions.LoggingLevel getLoggingLevel() {
        MavenExecutionOptions.LoggingLevel loggingLevel = this.getOutputLevel();
        if (loggingLevel == null) {
            MavenGeneralSettings.$$$reportNull$$$0(3);
        }
        return loggingLevel;
    }

    @Property
    @NotNull
    public MavenExecutionOptions.LoggingLevel getOutputLevel() {
        MavenExecutionOptions.LoggingLevel loggingLevel = this.outputLevel;
        if (loggingLevel == null) {
            MavenGeneralSettings.$$$reportNull$$$0(4);
        }
        return loggingLevel;
    }

    public void setOutputLevel(MavenExecutionOptions.LoggingLevel value) {
        if (value == null) {
            return;
        }
        if (!Comparing.equal((Object)((Object)this.outputLevel), (Object)((Object)value))) {
            MavenServerManager.getInstance().setLoggingLevel(value);
            this.outputLevel = value;
            this.changed();
        }
    }

    public boolean isWorkOffline() {
        return this.workOffline;
    }

    public void setWorkOffline(boolean workOffline) {
        this.workOffline = workOffline;
        this.changed();
    }

    @NotNull
    public String getMavenHome() {
        String string = this.mavenHome;
        if (string == null) {
            MavenGeneralSettings.$$$reportNull$$$0(5);
        }
        return string;
    }

    public void setMavenHome(@NotNull String mavenHome) {
        if (mavenHome == null) {
            MavenGeneralSettings.$$$reportNull$$$0(6);
        }
        if (!Comparing.equal((String)this.mavenHome, (String)mavenHome)) {
            this.mavenHome = mavenHome;
            MavenServerManager.getInstance().setMavenHome(mavenHome);
            this.myDefaultPluginsCache = null;
            this.changed();
        }
    }

    @Nullable
    public File getEffectiveMavenHome() {
        return MavenUtil.resolveMavenHomeDirectory(this.getMavenHome());
    }

    @NotNull
    public String getUserSettingsFile() {
        String string = this.mavenSettingsFile;
        if (string == null) {
            MavenGeneralSettings.$$$reportNull$$$0(7);
        }
        return string;
    }

    public void setUserSettingsFile(@Nullable String mavenSettingsFile) {
        if (mavenSettingsFile == null) {
            return;
        }
        if (!Comparing.equal((String)this.mavenSettingsFile, (String)mavenSettingsFile)) {
            this.mavenSettingsFile = mavenSettingsFile;
            this.changed();
        }
    }

    @Nullable
    public File getEffectiveUserSettingsIoFile() {
        return MavenUtil.resolveUserSettingsFile(this.getUserSettingsFile());
    }

    @Nullable
    public File getEffectiveGlobalSettingsIoFile() {
        return MavenUtil.resolveGlobalSettingsFile(this.getMavenHome());
    }

    @Nullable
    public VirtualFile getEffectiveUserSettingsFile() {
        File file = this.getEffectiveUserSettingsIoFile();
        return file == null ? null : LocalFileSystem.getInstance().findFileByIoFile(file);
    }

    public List<VirtualFile> getEffectiveSettingsFiles() {
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>(2);
        VirtualFile file = this.getEffectiveUserSettingsFile();
        if (file != null) {
            result.add(file);
        }
        if ((file = this.getEffectiveGlobalSettingsFile()) != null) {
            result.add(file);
        }
        return result;
    }

    @Nullable
    public VirtualFile getEffectiveGlobalSettingsFile() {
        File file = this.getEffectiveGlobalSettingsIoFile();
        return file == null ? null : LocalFileSystem.getInstance().findFileByIoFile(file);
    }

    @NotNull
    public String getLocalRepository() {
        String string = this.overriddenLocalRepository;
        if (string == null) {
            MavenGeneralSettings.$$$reportNull$$$0(8);
        }
        return string;
    }

    public void setLocalRepository(@Nullable String overridenLocalRepository) {
        if (overridenLocalRepository == null) {
            return;
        }
        if (!Comparing.equal((String)this.overriddenLocalRepository, (String)overridenLocalRepository)) {
            this.overriddenLocalRepository = overridenLocalRepository;
            MavenServerManager.getInstance().shutdown(true);
            this.changed();
        }
    }

    public File getEffectiveLocalRepository() {
        File result = this.myEffectiveLocalRepositoryCache;
        if (result != null) {
            return result;
        }
        this.myEffectiveLocalRepositoryCache = result = MavenUtil.resolveLocalRepository(this.overriddenLocalRepository, this.mavenHome, this.mavenSettingsFile);
        return result;
    }

    @Nullable
    public VirtualFile getEffectiveSuperPom() {
        return MavenUtil.resolveSuperPomFile(this.getEffectiveMavenHome());
    }

    public boolean isDefaultPlugin(String groupId, String artifactId) {
        return this.getDefaultPlugins().contains(groupId + ":" + artifactId);
    }

    private Set<String> getDefaultPlugins() {
        THashSet result = this.myDefaultPluginsCache;
        if (result != null) {
            return result;
        }
        result = new THashSet();
        VirtualFile effectiveSuperPom = this.getEffectiveSuperPom();
        if (effectiveSuperPom != null) {
            Element superProject = MavenJDOMUtil.read(effectiveSuperPom, null);
            for (Element each : MavenJDOMUtil.findChildrenByPath(superProject, "build.pluginManagement.plugins", "plugin")) {
                String groupId = MavenJDOMUtil.findChildValueByPath(each, "groupId", "org.apache.maven.plugins");
                String artifactId = MavenJDOMUtil.findChildValueByPath(each, "artifactId", null);
                result.add(groupId + ":" + artifactId);
            }
        }
        this.myDefaultPluginsCache = result;
        return result;
    }

    public boolean isPrintErrorStackTraces() {
        return this.printErrorStackTraces;
    }

    public void setPrintErrorStackTraces(boolean value) {
        this.printErrorStackTraces = value;
        this.changed();
    }

    public boolean isUsePluginRegistry() {
        return this.usePluginRegistry;
    }

    public void setUsePluginRegistry(boolean usePluginRegistry) {
        this.usePluginRegistry = usePluginRegistry;
        this.changed();
    }

    public boolean isAlwaysUpdateSnapshots() {
        return this.alwaysUpdateSnapshots;
    }

    public void setAlwaysUpdateSnapshots(boolean alwaysUpdateSnapshots) {
        this.alwaysUpdateSnapshots = alwaysUpdateSnapshots;
        this.changed();
    }

    public boolean isNonRecursive() {
        return this.nonRecursive;
    }

    public void setNonRecursive(boolean nonRecursive) {
        this.nonRecursive = nonRecursive;
        this.changed();
    }

    @Nullable
    public String getThreads() {
        return this.threads;
    }

    public void setThreads(@Nullable String threads) {
        this.threads = StringUtil.nullize((String)threads);
        this.changed();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MavenGeneralSettings that = (MavenGeneralSettings)o;
        if (this.nonRecursive != that.nonRecursive) {
            return false;
        }
        if (this.outputLevel != that.outputLevel) {
            return false;
        }
        if (this.pluginUpdatePolicy != that.pluginUpdatePolicy) {
            return false;
        }
        if (this.alwaysUpdateSnapshots != that.alwaysUpdateSnapshots) {
            return false;
        }
        if (this.printErrorStackTraces != that.printErrorStackTraces) {
            return false;
        }
        if (this.usePluginRegistry != that.usePluginRegistry) {
            return false;
        }
        if (this.workOffline != that.workOffline) {
            return false;
        }
        if (!this.checksumPolicy.equals((Object)that.checksumPolicy)) {
            return false;
        }
        if (!this.failureBehavior.equals((Object)that.failureBehavior)) {
            return false;
        }
        if (!this.overriddenLocalRepository.equals(that.overriddenLocalRepository)) {
            return false;
        }
        if (!this.mavenHome.equals(that.mavenHome)) {
            return false;
        }
        if (!this.mavenSettingsFile.equals(that.mavenSettingsFile)) {
            return false;
        }
        return Comparing.equal((String)this.threads, (String)that.threads);
    }

    public int hashCode() {
        int result = this.workOffline ? 1 : 0;
        result = 31 * result + this.mavenHome.hashCode();
        result = 31 * result + this.mavenSettingsFile.hashCode();
        result = 31 * result + this.overriddenLocalRepository.hashCode();
        result = 31 * result + (this.printErrorStackTraces ? 1 : 0);
        result = 31 * result + (this.usePluginRegistry ? 1 : 0);
        result = 31 * result + (this.nonRecursive ? 1 : 0);
        result = 31 * result + this.outputLevel.hashCode();
        result = 31 * result + this.checksumPolicy.hashCode();
        result = 31 * result + this.failureBehavior.hashCode();
        result = 31 * result + this.pluginUpdatePolicy.hashCode();
        return result;
    }

    public MavenGeneralSettings clone() {
        try {
            MavenGeneralSettings result = (MavenGeneralSettings)super.clone();
            result.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
            result.myBulkUpdateLevel = 0;
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new Error(e);
        }
    }

    public void addListener(Listener l) {
        this.myListeners.add(l);
    }

    public void removeListener(Listener l) {
        this.myListeners.remove(l);
    }

    private void fireChanged() {
        for (Listener each : this.myListeners) {
            each.changed();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/project/MavenGeneralSettings";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mavenHome";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginUpdatePolicy";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getChecksumPolicy";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFailureBehavior";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoggingLevel";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputLevel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getMavenHome";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/project/MavenGeneralSettings";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserSettingsFile";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalRepository";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setMavenHome";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface Listener {
        public void changed();
    }
}

