/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.navigator.actions;

import com.intellij.execution.configurations.ParametersList;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.execution.MavenExecuteGoalDialog;
import org.jetbrains.idea.maven.execution.MavenRunConfigurationType;
import org.jetbrains.idea.maven.execution.MavenRunner;
import org.jetbrains.idea.maven.execution.MavenRunnerParameters;
import org.jetbrains.idea.maven.execution.MavenRunnerSettings;
import org.jetbrains.idea.maven.execution.RunnerBundle;
import org.jetbrains.idea.maven.navigator.actions.ExecuteMavenGoalHistoryService;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenUtil;

public class MavenExecuteGoalAction
extends DumbAwareAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            MavenExecuteGoalAction.$$$reportNull$$$0(0);
        }
        final Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        ExecuteMavenGoalHistoryService historyService = ExecuteMavenGoalHistoryService.getInstance(project);
        MavenExecuteGoalDialog dialog = new MavenExecuteGoalDialog(project, historyService.getHistory());
        String lastWorkingDirectory = historyService.getWorkDirectory();
        if (lastWorkingDirectory.length() == 0) {
            lastWorkingDirectory = MavenExecuteGoalAction.obtainAppropriateWorkingDirectory(project);
        }
        dialog.setWorkDirectory(lastWorkingDirectory);
        if (StringUtil.isEmptyOrSpaces((String)historyService.getCanceledCommand())) {
            if (historyService.getHistory().size() > 0) {
                dialog.setGoals(historyService.getHistory().get(0));
            }
        } else {
            dialog.setGoals(historyService.getCanceledCommand());
        }
        if (!dialog.showAndGet()) {
            historyService.setCanceledCommand(dialog.getGoals());
            return;
        }
        historyService.setCanceledCommand(null);
        String goals = dialog.getGoals();
        goals = goals.trim();
        if (goals.startsWith("mvn ")) {
            goals = goals.substring("mvn ".length()).trim();
        }
        String workDirectory = dialog.getWorkDirectory();
        historyService.addCommand(goals, workDirectory);
        MavenProjectsManager projectsManager = MavenProjectsManager.getInstance(project);
        File mavenHome = MavenUtil.resolveMavenHomeDirectory(projectsManager.getGeneralSettings().getMavenHome());
        if (mavenHome == null) {
            Notification notification = new Notification("Maven", "Failed to execute goal", RunnerBundle.message("external.maven.home.no.default.with.fix", new Object[0]), NotificationType.ERROR, (NotificationListener)new NotificationListener.Adapter(){

                protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
                    if (notification == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (e == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    ShowSettingsUtil.getInstance().showSettingsDialog(project, "Maven");
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "notification";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "e";
                            break;
                        }
                    }
                    objectArray[1] = "org/jetbrains/idea/maven/navigator/actions/MavenExecuteGoalAction$1";
                    objectArray[2] = "hyperlinkActivated";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            Notifications.Bus.notify((Notification)notification, (Project)project);
            return;
        }
        MavenRunnerParameters parameters = new MavenRunnerParameters(true, workDirectory, Arrays.asList(ParametersList.parse((String)goals)), Collections.emptyList());
        MavenGeneralSettings generalSettings = new MavenGeneralSettings();
        generalSettings.setMavenHome(mavenHome.getPath());
        MavenRunnerSettings runnerSettings = MavenRunner.getInstance(project).getSettings().clone();
        runnerSettings.setMavenProperties(new LinkedHashMap<String, String>());
        runnerSettings.setSkipTests(false);
        MavenRunConfigurationType.runConfiguration(project, parameters, generalSettings, runnerSettings, null);
    }

    private static String obtainAppropriateWorkingDirectory(@NotNull Project project) {
        List<MavenProject> rootProjects;
        if (project == null) {
            MavenExecuteGoalAction.$$$reportNull$$$0(1);
        }
        if ((rootProjects = MavenProjectsManager.getInstance(project).getRootProjects()).isEmpty()) {
            return "";
        }
        return rootProjects.get(0).getDirectory();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/maven/navigator/actions/MavenExecuteGoalAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "obtainAppropriateWorkingDirectory";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

