/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.StdModuleTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.util.PairConsumer;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.importing.MavenExtraArtifactType;
import org.jetbrains.idea.maven.importing.MavenRootModelAdapter;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectChanges;
import org.jetbrains.idea.maven.project.MavenProjectsProcessorTask;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.project.ResolveContext;
import org.jetbrains.idea.maven.project.SupportedRequestType;
import org.jetbrains.idea.maven.server.MavenEmbedderWrapper;
import org.jetbrains.idea.maven.server.NativeMavenProjectHolder;
import org.jetbrains.idea.maven.utils.MavenJDOMUtil;
import org.jetbrains.idea.maven.utils.MavenProcessCanceledException;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public abstract class MavenImporter {
    public static final ExtensionPointName<MavenImporter> EXTENSION_POINT_NAME = ExtensionPointName.create((String)"org.jetbrains.idea.maven.importer");
    protected final String myPluginGroupID;
    protected final String myPluginArtifactID;

    public MavenImporter(String pluginGroupID, String pluginArtifactID) {
        this.myPluginGroupID = pluginGroupID;
        this.myPluginArtifactID = pluginArtifactID;
    }

    public static List<MavenImporter> getSuitableImporters(MavenProject p) {
        ArrayList<MavenImporter> result = null;
        Set moduleTypes = null;
        for (MavenImporter importer2 : (MavenImporter[])EXTENSION_POINT_NAME.getExtensions()) {
            if (!importer2.isApplicable(p)) continue;
            if (result == null) {
                result = new ArrayList<MavenImporter>();
                moduleTypes = new THashSet();
            }
            result.add(importer2);
            moduleTypes.add(importer2.getModuleType());
        }
        if (result == null) {
            return Collections.emptyList();
        }
        if (moduleTypes.size() <= 1) {
            return result;
        }
        ModuleType moduleType = ((MavenImporter)result.get(0)).getModuleType();
        ArrayList<String> supportedPackagings = new ArrayList<String>();
        for (MavenImporter importer2 : result) {
            supportedPackagings.clear();
            importer2.getSupportedPackagings(supportedPackagings);
            if (!supportedPackagings.contains(p.getPackaging())) continue;
            moduleType = importer2.getModuleType();
            break;
        }
        ModuleType finalModuleType = moduleType;
        return ContainerUtil.filter(result, importer -> importer.getModuleType() == finalModuleType);
    }

    public boolean isApplicable(MavenProject mavenProject) {
        return mavenProject.findPlugin(this.myPluginGroupID, this.myPluginArtifactID) != null;
    }

    @NotNull
    public ModuleType getModuleType() {
        ModuleType moduleType = StdModuleTypes.JAVA;
        if (moduleType == null) {
            MavenImporter.$$$reportNull$$$0(0);
        }
        return moduleType;
    }

    public void getSupportedPackagings(Collection<String> result) {
    }

    public void getSupportedDependencyTypes(Collection<String> result, SupportedRequestType type) {
    }

    public void getSupportedDependencyScopes(Collection<String> result) {
    }

    @Nullable
    public Pair<String, String> getExtraArtifactClassifierAndExtension(MavenArtifact artifact, MavenExtraArtifactType type) {
        return null;
    }

    @Deprecated
    public void resolve(Project project, MavenProject mavenProject, NativeMavenProjectHolder nativeMavenProject, MavenEmbedderWrapper embedder) throws MavenProcessCanceledException {
    }

    public void resolve(Project project, MavenProject mavenProject, NativeMavenProjectHolder nativeMavenProject, MavenEmbedderWrapper embedder, ResolveContext context) throws MavenProcessCanceledException {
        this.resolve(project, mavenProject, nativeMavenProject, embedder);
    }

    public abstract void preProcess(Module var1, MavenProject var2, MavenProjectChanges var3, IdeModifiableModelsProvider var4);

    public abstract void process(IdeModifiableModelsProvider var1, Module var2, MavenRootModelAdapter var3, MavenProjectsTree var4, MavenProject var5, MavenProjectChanges var6, Map<MavenProject, String> var7, List<MavenProjectsProcessorTask> var8);

    public void postProcess(Module module, MavenProject mavenProject, MavenProjectChanges changes, IdeModifiableModelsProvider modifiableModelsProvider) {
    }

    public boolean processChangedModulesOnly() {
        return true;
    }

    public void collectSourceRoots(MavenProject mavenProject, PairConsumer<String, JpsModuleSourceRootType<?>> result) {
        ArrayList<String> sources = new ArrayList<String>();
        this.collectSourceFolders(mavenProject, sources);
        for (String path : sources) {
            result.consume((Object)path, (Object)JavaSourceRootType.SOURCE);
        }
        ArrayList<String> testSources = new ArrayList<String>();
        this.collectTestFolders(mavenProject, testSources);
        for (String path : testSources) {
            result.consume((Object)path, (Object)JavaSourceRootType.TEST_SOURCE);
        }
    }

    public void collectSourceFolders(MavenProject mavenProject, List<String> result) {
    }

    public void collectTestFolders(MavenProject mavenProject, List<String> result) {
    }

    public void collectExcludedFolders(MavenProject mavenProject, List<String> result) {
    }

    @Nullable
    protected Element getConfig(MavenProject p) {
        return p.getPluginConfiguration(this.myPluginGroupID, this.myPluginArtifactID);
    }

    @Nullable
    protected Element getConfig(MavenProject p, String path) {
        return MavenJDOMUtil.findChildByPath(this.getConfig(p), path);
    }

    @Nullable
    protected String findConfigValue(MavenProject p, String path) {
        return MavenJDOMUtil.findChildValueByPath(this.getConfig(p), path);
    }

    @Nullable
    protected String findConfigValue(MavenProject p, String path, String defaultValue) {
        return MavenJDOMUtil.findChildValueByPath(this.getConfig(p), path, defaultValue);
    }

    @Nullable
    protected Element getGoalConfig(MavenProject p, String goal) {
        return p.getPluginGoalConfiguration(this.myPluginGroupID, this.myPluginArtifactID, goal);
    }

    @Nullable
    protected String findGoalConfigValue(MavenProject p, String goal, String path) {
        return MavenJDOMUtil.findChildValueByPath(this.getGoalConfig(p, goal), path);
    }

    public void customizeUserProperties(Project project, MavenProject mavenProject, Properties properties) {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/importing/MavenImporter", "getModuleType"));
    }
}

