/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.references;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.project.MavenProjectsManager;

public abstract class MavenPsiReference
implements PsiReference {
    @NotNull
    protected final Project myProject;
    @NotNull
    protected final MavenProjectsManager myProjectsManager;
    @NotNull
    protected final PsiFile myPsiFile;
    @NotNull
    protected final VirtualFile myVirtualFile;
    @NotNull
    protected final PsiElement myElement;
    @NotNull
    protected final String myText;
    @NotNull
    protected final TextRange myRange;

    public MavenPsiReference(@NotNull PsiElement element, @NotNull String text, @NotNull TextRange range) {
        if (element == null) {
            MavenPsiReference.$$$reportNull$$$0(0);
        }
        if (text == null) {
            MavenPsiReference.$$$reportNull$$$0(1);
        }
        if (range == null) {
            MavenPsiReference.$$$reportNull$$$0(2);
        }
        this.myProject = element.getProject();
        this.myProjectsManager = MavenProjectsManager.getInstance(this.myProject);
        this.myPsiFile = element.getContainingFile().getOriginalFile();
        this.myVirtualFile = this.myPsiFile.getVirtualFile();
        this.myElement = element;
        this.myText = text;
        this.myRange = range;
    }

    public PsiElement getElement() {
        return this.myElement;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.myText;
        if (string == null) {
            MavenPsiReference.$$$reportNull$$$0(3);
        }
        return string;
    }

    public TextRange getRangeInElement() {
        return this.myRange;
    }

    public boolean isReferenceTo(PsiElement element) {
        return this.getElement().getManager().areElementsEquivalent(element, this.resolve());
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        return null;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            MavenPsiReference.$$$reportNull$$$0(4);
        }
        return null;
    }

    public boolean isSoft() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/dom/references/MavenPsiReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/dom/references/MavenPsiReference";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

