/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.pixelprobe;

import com.android.tools.pixelprobe.ColorMode;
import com.android.tools.pixelprobe.Guide;
import com.android.tools.pixelprobe.Layer;
import com.android.tools.pixelprobe.color.Colors;
import com.android.tools.pixelprobe.util.Lists;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Image {
    private final String format;
    private final int width;
    private final int height;
    private final int depth;
    private final ColorMode colorMode;
    private final ColorSpace colorSpace;
    private final String colorProfileDescription;
    private final float horizontalResolution;
    private final float verticalResolution;
    private final BufferedImage mergedImage;
    private final BufferedImage thumbnail;
    private final List<Guide> guides;
    private final List<Layer> layers;

    Image(Builder builder) {
        this.format = builder.format;
        this.width = builder.width;
        this.height = builder.height;
        this.depth = builder.depth;
        this.colorMode = builder.colorMode;
        this.colorSpace = builder.colorSpace;
        this.colorProfileDescription = Colors.getIccProfileDescription(this.colorSpace);
        this.horizontalResolution = builder.horizontalResolution;
        this.verticalResolution = builder.verticalResolution;
        this.mergedImage = builder.mergedImage;
        this.thumbnail = builder.thumbnail;
        this.guides = Lists.immutableCopy(builder.guides);
        this.layers = Lists.immutableCopy(builder.layers);
    }

    public String getFormat() {
        return this.format;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public float getHorizontalResolution() {
        return this.horizontalResolution;
    }

    public float getVerticalResolution() {
        return this.verticalResolution;
    }

    public int getColorDepth() {
        return this.depth;
    }

    public ColorMode getColorMode() {
        return this.colorMode;
    }

    public ColorSpace getColorSpace() {
        return this.colorSpace;
    }

    public String getColorProfileDescription() {
        return this.colorProfileDescription;
    }

    public BufferedImage getMergedImage() {
        return this.mergedImage;
    }

    public BufferedImage getThumbnailImage() {
        return this.thumbnail;
    }

    public List<Guide> getGuides() {
        return Collections.unmodifiableList(this.guides);
    }

    public List<Layer> getLayers() {
        return Collections.unmodifiableList(this.layers);
    }

    public String toString() {
        return "Image{format=" + this.format + ", width=" + this.width + ", height=" + this.height + ", hRes=" + this.horizontalResolution + ", vRes=" + this.verticalResolution + ", depth=" + this.depth + ", colorMode=" + (Object)((Object)this.colorMode) + ", profile=" + this.colorProfileDescription + ", guides=" + this.guides.size() + ", layers=" + this.layers.size() + ", hasThumbnail=" + (this.thumbnail != null) + '}';
    }

    public static final class Builder {
        String format = "Unknown";
        int width;
        int height;
        int depth;
        ColorMode colorMode = ColorMode.UNKNOWN;
        ColorSpace colorSpace = ColorSpace.getInstance(1000);
        float horizontalResolution = 72.0f;
        float verticalResolution = 72.0f;
        BufferedImage mergedImage;
        BufferedImage thumbnail;
        final List<Guide> guides = new ArrayList<Guide>();
        final List<Layer> layers = new ArrayList<Layer>();

        public int width() {
            return this.width;
        }

        public int height() {
            return this.height;
        }

        public float verticalResolution() {
            return this.verticalResolution;
        }

        public float horizontalResolution() {
            return this.horizontalResolution;
        }

        public int depth() {
            return this.depth;
        }

        public ColorSpace colorSpace() {
            return this.colorSpace;
        }

        public ColorMode colorMode() {
            return this.colorMode;
        }

        public Builder mergedImage(BufferedImage mergedImage) {
            this.mergedImage = mergedImage;
            return this;
        }

        public Builder dimensions(int width, int height) {
            this.width = width;
            this.height = height;
            return this;
        }

        public Builder resolution(float horizontal, float vertical) {
            this.horizontalResolution = horizontal;
            this.verticalResolution = vertical;
            return this;
        }

        public Builder depth(int depth) {
            this.depth = depth;
            return this;
        }

        public Builder colorMode(ColorMode mode) {
            this.colorMode = mode;
            return this;
        }

        public Builder thumbnail(BufferedImage thumbnail) {
            this.thumbnail = thumbnail;
            return this;
        }

        public Builder addGuide(Guide guide) {
            this.guides.add(guide);
            return this;
        }

        public Builder addLayer(Layer layer) {
            this.layers.add(layer);
            return this;
        }

        public Builder colorSpace(ColorSpace colorSpace) {
            if (colorSpace != null) {
                this.colorSpace = colorSpace;
            }
            return this;
        }

        public Builder format(String format) {
            this.format = format;
            return this;
        }

        public Image build() {
            return new Image(this);
        }
    }
}

