/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.jvm;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.Closeable;
import java.io.File;
import java.lang.management.CompilationMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.cli.common.CLICompiler;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.CLITool;
import org.jetbrains.kotlin.cli.common.ExitCode;
import org.jetbrains.kotlin.cli.common.arguments.CommonCompilerArguments;
import org.jetbrains.kotlin.cli.common.arguments.K2JVMCompilerArguments;
import org.jetbrains.kotlin.cli.common.messages.CompilerMessageSeverity;
import org.jetbrains.kotlin.cli.common.messages.FilteringMessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.common.messages.MessageUtil;
import org.jetbrains.kotlin.cli.common.messages.OutputMessageUtil;
import org.jetbrains.kotlin.cli.common.modules.ModuleScriptData;
import org.jetbrains.kotlin.cli.jvm.K2JVMCompiler;
import org.jetbrains.kotlin.cli.jvm.K2JVMCompilerKt$sam$Predicate$15c2bf0f;
import org.jetbrains.kotlin.cli.jvm.compiler.CompileEnvironmentUtil;
import org.jetbrains.kotlin.cli.jvm.compiler.EnvironmentConfigFiles;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinToJVMBytecodeCompiler;
import org.jetbrains.kotlin.cli.jvm.config.JvmClasspathRoot;
import org.jetbrains.kotlin.cli.jvm.config.JvmContentRootsKt;
import org.jetbrains.kotlin.cli.jvm.config.JvmModulePathRoot;
import org.jetbrains.kotlin.cli.jvm.modules.CoreJrtFileSystem;
import org.jetbrains.kotlin.cli.jvm.plugins.PluginCliParser;
import org.jetbrains.kotlin.cli.jvm.repl.ReplFromTerminal;
import org.jetbrains.kotlin.codegen.CompilationException;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.ContentRootsKt;
import org.jetbrains.kotlin.config.IncrementalCompilation;
import org.jetbrains.kotlin.config.JVMConfigurationKeys;
import org.jetbrains.kotlin.config.JVMConstructorCallNormalizationMode;
import org.jetbrains.kotlin.config.JvmTarget;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.Services;
import org.jetbrains.kotlin.incremental.components.LookupTracker;
import org.jetbrains.kotlin.javac.JavacWrapper;
import org.jetbrains.kotlin.load.kotlin.incremental.components.IncrementalCompilationComponents;
import org.jetbrains.kotlin.modules.Module;
import org.jetbrains.kotlin.script.KotlinScriptDefinitionFromAnnotatedTemplate;
import org.jetbrains.kotlin.script.KotlinScriptDefinitionProvider;
import org.jetbrains.kotlin.script.StandardScriptDefinition;
import org.jetbrains.kotlin.util.PerformanceCounter;
import org.jetbrains.kotlin.utils.KotlinPaths;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 #2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001#B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0002J\b\u0010\t\u001a\u00020\u0002H\u0016J\u0018\u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J*\u0010\u000f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J*\u0010\u0012\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0014J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0018\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0002J \u0010\u0019\u001a\u00020\u001a2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\u001cH\u0014J$\u0010\u001d\u001a\u00020\u001a2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020!0\u001f2\u0006\u0010\"\u001a\u00020\u0002H\u0014\u00a8\u0006$"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/K2JVMCompiler;", "Lorg/jetbrains/kotlin/cli/common/CLICompiler;", "Lorg/jetbrains/kotlin/cli/common/arguments/K2JVMCompilerArguments;", "()V", "compileJavaFilesIfNeeded", "", "environment", "Lorg/jetbrains/kotlin/cli/jvm/compiler/KotlinCoreEnvironment;", "arguments", "createArguments", "createCoreEnvironment", "rootDisposable", "Lcom/intellij/openapi/Disposable;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "createEnvironmentWithScriptingSupport", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "doExecute", "Lorg/jetbrains/kotlin/cli/common/ExitCode;", "paths", "Lorg/jetbrains/kotlin/utils/KotlinPaths;", "executableScriptFileName", "", "registerJavacIfNeeded", "setupPlatformSpecificArgumentsAndServices", "", "services", "Lorg/jetbrains/kotlin/config/Services;", "setupPlatformSpecificLanguageFeatureSettings", "extraLanguageFeatures", "", "Lorg/jetbrains/kotlin/config/LanguageFeature;", "Lorg/jetbrains/kotlin/config/LanguageFeature$State;", "commandLineArguments", "Companion", "cli"})
public final class K2JVMCompiler
extends CLICompiler<K2JVMCompilerArguments> {
    private static long initStartNanos;
    private static final HashMap<String, Long> elapsedGCTime;
    private static long elapsedJITTime;
    public static final Companion Companion;

    @Override
    @NotNull
    protected ExitCode doExecute(@NotNull K2JVMCompilerArguments arguments2, @NotNull CompilerConfiguration configuration, @NotNull Disposable rootDisposable, @Nullable KotlinPaths paths) {
        List<Object> friendPaths;
        ExitCode exitCode2;
        MessageCollector messageCollector2;
        Intrinsics.checkParameterIsNotNull(arguments2, "arguments");
        Intrinsics.checkParameterIsNotNull(configuration, "configuration");
        Intrinsics.checkParameterIsNotNull(rootDisposable, "rootDisposable");
        PerformanceCounter.Companion.setTimeCounterEnabled(arguments2.getReportPerf());
        MessageCollector messageCollector3 = messageCollector2 = configuration.getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
        Intrinsics.checkExpressionValueIsNotNull(messageCollector3, "messageCollector");
        ExitCode it = exitCode2 = K2JVMCompiler.Companion.configureJdkHome(arguments2, configuration, messageCollector3);
        if (Intrinsics.areEqual((Object)it, (Object)ExitCode.OK) ^ true) {
            return it;
        }
        ExitCode plugLoadResult = PluginCliParser.loadPluginsSafe(arguments2, configuration);
        if (Intrinsics.areEqual((Object)plugLoadResult, (Object)ExitCode.OK) ^ true) {
            return plugLoadResult;
        }
        if (!arguments2.getScript() && arguments2.getBuildFile() == null) {
            for (String arg : arguments2.getFreeArgs()) {
                File file = new File(arg);
                if (Intrinsics.areEqual(FilesKt.getExtension(file), "java")) {
                    JvmContentRootsKt.addJavaSourceRoot$default(configuration, file, null, 2, null);
                    continue;
                }
                ContentRootsKt.addKotlinSourceRoot(configuration, arg);
                if (!file.isDirectory()) continue;
                JvmContentRootsKt.addJavaSourceRoot$default(configuration, file, null, 2, null);
            }
        }
        K2JVMCompiler.Companion.configureContentRoots(paths, arguments2, configuration);
        String string = arguments2.getModuleName();
        if (string == null) {
            string = "main";
        }
        configuration.put(CommonConfigurationKeys.MODULE_NAME, string);
        if (arguments2.getBuildFile() == null && arguments2.getFreeArgs().isEmpty() && !arguments2.getVersion()) {
            if (arguments2.getScript()) {
                MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.ERROR, "Specify script source path to evaluate", null, 4, null);
                return ExitCode.COMPILATION_ERROR;
            }
            ReplFromTerminal.Companion.run(rootDisposable, configuration);
            return ExitCode.OK;
        }
        if (arguments2.getIncludeRuntime()) {
            configuration.put(JVMConfigurationKeys.INCLUDE_RUNTIME, true);
        }
        String[] stringArray = arguments2.getFriendPaths();
        List<Object> list2 = friendPaths = stringArray != null ? ArraysKt.toList((Object[])stringArray) : null;
        if (friendPaths != null) {
            configuration.put(JVMConfigurationKeys.FRIEND_PATHS, friendPaths);
        }
        if (arguments2.getJvmTarget() != null) {
            JvmTarget jvmTarget;
            String string2 = arguments2.getJvmTarget();
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            if ((jvmTarget = JvmTarget.Companion.fromString(string2)) != null) {
                configuration.put(JVMConfigurationKeys.JVM_TARGET, jvmTarget);
            } else {
                MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.ERROR, "Unknown JVM target version: " + arguments2.getJvmTarget() + '\n' + "Supported versions: " + ArraysKt.joinToString$default(JvmTarget.values(), null, null, null, 0, null, (Function1)doExecute.2.INSTANCE, 31, null), null, 4, null);
            }
        }
        configuration.put(JVMConfigurationKeys.PARAMETERS_METADATA, arguments2.getJavaParameters());
        K2JVMCompiler.Companion.putAdvancedOptions(configuration, arguments2);
        MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.LOGGING, "Configuring the compilation environment", null, 4, null);
        try {
            block34: {
                boolean bl;
                String destination;
                block35: {
                    KotlinCoreEnvironment environment2;
                    block37: {
                        block36: {
                            block33: {
                                boolean bl2;
                                destination = arguments2.getDestination();
                                if (arguments2.getBuildFile() == null) break block33;
                                Function1 function1 = new Function1<CompilerMessageSeverity, Boolean>(CompilerMessageSeverity.VERBOSE){

                                    public final boolean invoke(CompilerMessageSeverity p1) {
                                        return ((EnumSet)this.receiver).contains((Object)((Object)p1));
                                    }

                                    public final KDeclarationContainer getOwner() {
                                        return Reflection.getOrCreateKotlinClass(EnumSet.class);
                                    }

                                    public final String getName() {
                                        return "contains";
                                    }

                                    public final String getSignature() {
                                        return "contains(Ljava/lang/Object;)Z";
                                    }
                                };
                                FilteringMessageCollector sanitizedCollector2 = new FilteringMessageCollector(messageCollector2, new K2JVMCompilerKt$sam$Predicate$15c2bf0f(function1));
                                ModuleScriptData moduleScript = CompileEnvironmentUtil.loadModuleDescriptions(arguments2.getBuildFile(), sanitizedCollector2);
                                if (destination != null) {
                                    MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.STRONG_WARNING, "The '-d' option with a directory destination is ignored because '-Xbuild-file' is specified", null, 4, null);
                                }
                                File moduleFile = new File(arguments2.getBuildFile());
                                File file = moduleFile.getAbsoluteFile();
                                Intrinsics.checkExpressionValueIsNotNull(file, "moduleFile.absoluteFile");
                                File directory = file.getParentFile();
                                ModuleScriptData moduleScriptData = moduleScript;
                                Intrinsics.checkExpressionValueIsNotNull(moduleScriptData, "moduleScript");
                                List<Module> list3 = moduleScriptData.getModules();
                                Intrinsics.checkExpressionValueIsNotNull(list3, "moduleScript.modules");
                                File file2 = directory;
                                Intrinsics.checkExpressionValueIsNotNull(file2, "directory");
                                KotlinToJVMBytecodeCompiler.INSTANCE.configureSourceRoots(configuration, list3, file2);
                                configuration.put(JVMConfigurationKeys.MODULE_XML_FILE, moduleFile);
                                KotlinCoreEnvironment kotlinCoreEnvironment = this.createEnvironmentWithScriptingSupport(rootDisposable, configuration, arguments2, messageCollector2);
                                if (kotlinCoreEnvironment == null) {
                                    return ExitCode.COMPILATION_ERROR;
                                }
                                KotlinCoreEnvironment environment3 = kotlinCoreEnvironment;
                                boolean it2 = bl2 = this.registerJavacIfNeeded(environment3, arguments2);
                                if (!it2) {
                                    return ExitCode.COMPILATION_ERROR;
                                }
                                KotlinToJVMBytecodeCompiler.INSTANCE.compileModules(environment3, directory);
                                break block34;
                            }
                            if (!arguments2.getScript()) break block35;
                            String sourcePath = CollectionsKt.first(arguments2.getFreeArgs());
                            ContentRootsKt.addKotlinSourceRoot(configuration, sourcePath);
                            configuration.put(JVMConfigurationKeys.RETAIN_OUTPUT_IN_MEMORY, true);
                            KotlinCoreEnvironment kotlinCoreEnvironment = this.createEnvironmentWithScriptingSupport(rootDisposable, configuration, arguments2, messageCollector2);
                            if (kotlinCoreEnvironment == null) {
                                return ExitCode.COMPILATION_ERROR;
                            }
                            environment2 = kotlinCoreEnvironment;
                            KotlinScriptDefinitionProvider kotlinScriptDefinitionProvider = KotlinScriptDefinitionProvider.Companion.getInstance(environment2.getProject());
                            if (kotlinScriptDefinitionProvider == null) {
                                Intrinsics.throwNpe();
                            }
                            KotlinScriptDefinitionProvider scriptDefinitionProvider = kotlinScriptDefinitionProvider;
                            File scriptFile = new File(sourcePath);
                            if (scriptFile.isDirectory()) break block36;
                            String string3 = scriptFile.getName();
                            Intrinsics.checkExpressionValueIsNotNull(string3, "scriptFile.name");
                            if (scriptDefinitionProvider.isScript(string3)) break block37;
                        }
                        String extensionHint = Intrinsics.areEqual(configuration.get(JVMConfigurationKeys.SCRIPT_DEFINITIONS), CollectionsKt.listOf(StandardScriptDefinition.INSTANCE)) ? " (.kts)" : "";
                        MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.ERROR, "Specify path to the script file" + extensionHint + " as the first argument", null, 4, null);
                        return ExitCode.COMPILATION_ERROR;
                    }
                    List<String> scriptArgs = arguments2.getFreeArgs().subList(1, arguments2.getFreeArgs().size());
                    return KotlinToJVMBytecodeCompiler.INSTANCE.compileAndExecuteScript$cli(environment2, scriptArgs);
                }
                if (destination != null) {
                    if (StringsKt.endsWith$default(destination, ".jar", false, 2, null)) {
                        configuration.put(JVMConfigurationKeys.OUTPUT_JAR, new File(destination));
                    } else {
                        configuration.put(JVMConfigurationKeys.OUTPUT_DIRECTORY, new File(destination));
                    }
                }
                KotlinCoreEnvironment kotlinCoreEnvironment = this.createEnvironmentWithScriptingSupport(rootDisposable, configuration, arguments2, messageCollector2);
                if (kotlinCoreEnvironment == null) {
                    return ExitCode.COMPILATION_ERROR;
                }
                KotlinCoreEnvironment environment4 = kotlinCoreEnvironment;
                boolean it3 = bl = this.registerJavacIfNeeded(environment4, arguments2);
                if (!it3) {
                    return ExitCode.COMPILATION_ERROR;
                }
                if (environment4.getSourceFiles().isEmpty()) {
                    if (arguments2.getVersion()) {
                        return ExitCode.OK;
                    }
                    MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.ERROR, "No source files", null, 4, null);
                    return ExitCode.COMPILATION_ERROR;
                }
                KotlinToJVMBytecodeCompiler.INSTANCE.compileBunchOfSources(environment4);
                it3 = bl = this.compileJavaFilesIfNeeded(environment4, arguments2);
                if (!it3) {
                    return ExitCode.COMPILATION_ERROR;
                }
            }
            if (arguments2.getReportPerf()) {
                Companion.reportGCTime(configuration);
                Companion.reportCompilationTime(configuration);
                PerformanceCounter.Companion.report((Function1<? super String, Unit>)new Function1<String, Unit>(configuration){
                    final /* synthetic */ CompilerConfiguration $configuration;

                    public final void invoke(@NotNull String s) {
                        Intrinsics.checkParameterIsNotNull(s, "s");
                        K2JVMCompiler.Companion.reportPerf(this.$configuration, s);
                    }
                    {
                        this.$configuration = compilerConfiguration;
                        super(1);
                    }
                });
            }
            return ExitCode.OK;
        }
        catch (CompilationException e) {
            String string4 = OutputMessageUtil.renderException(e);
            Intrinsics.checkExpressionValueIsNotNull(string4, "OutputMessageUtil.renderException(e)");
            messageCollector2.report(CompilerMessageSeverity.EXCEPTION, string4, MessageUtil.psiElementToMessageLocation(e.getElement()));
            return ExitCode.INTERNAL_ERROR;
        }
    }

    @Override
    protected void setupPlatformSpecificLanguageFeatureSettings(@NotNull Map<LanguageFeature, LanguageFeature.State> extraLanguageFeatures, @NotNull K2JVMCompilerArguments commandLineArguments) {
        Intrinsics.checkParameterIsNotNull(extraLanguageFeatures, "extraLanguageFeatures");
        Intrinsics.checkParameterIsNotNull(commandLineArguments, "commandLineArguments");
        if (commandLineArguments.getStrictJavaNullabilityAssertions()) {
            Map<LanguageFeature, LanguageFeature.State> map2 = extraLanguageFeatures;
            LanguageFeature languageFeature = LanguageFeature.StrictJavaNullabilityAssertions;
            LanguageFeature.State state2 = LanguageFeature.State.ENABLED;
            map2.put(languageFeature, state2);
        }
        super.setupPlatformSpecificLanguageFeatureSettings(extraLanguageFeatures, (CommonCompilerArguments)commandLineArguments);
    }

    private final boolean registerJavacIfNeeded(KotlinCoreEnvironment environment2, K2JVMCompilerArguments arguments2) {
        if (arguments2.getUseJavac()) {
            environment2.getConfiguration().put(JVMConfigurationKeys.USE_JAVAC, true);
            if (arguments2.getCompileJava()) {
                environment2.getConfiguration().put(JVMConfigurationKeys.COMPILE_JAVA, true);
            }
            return KotlinCoreEnvironment.registerJavac$default(environment2, null, null, arguments2.getJavacArguments(), null, null, 27, null);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean compileJavaFilesIfNeeded(KotlinCoreEnvironment environment2, K2JVMCompilerArguments arguments2) {
        if (arguments2.getCompileJava()) {
            boolean bl;
            Closeable closeable = JavacWrapper.Companion.getInstance(environment2.getProject());
            Throwable throwable = null;
            try {
                JavacWrapper it = (JavacWrapper)closeable;
                bl = JavacWrapper.compile$default(it, null, 1, null);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally(closeable, throwable);
            }
            return bl;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final KotlinCoreEnvironment createEnvironmentWithScriptingSupport(Disposable rootDisposable, CompilerConfiguration configuration, K2JVMCompilerArguments arguments2, MessageCollector messageCollector2) {
        HashMap<String, Object> hashMap = Companion.createScriptResolverEnvironment(arguments2, messageCollector2);
        if (hashMap == null) {
            return null;
        }
        HashMap<String, Object> scriptResolverEnv = hashMap;
        Companion.configureScriptDefinitions(arguments2.getScriptTemplates(), configuration, messageCollector2, scriptResolverEnv);
        if (!messageCollector2.hasErrors()) {
            KotlinCoreEnvironment environment2 = this.createCoreEnvironment(rootDisposable, configuration);
            if (!messageCollector2.hasErrors()) {
                Object object;
                Object $receiver;
                Object object2 = environment2.getProject();
                Project project = object2;
                String string = "projectRoot";
                HashMap<String, Object> hashMap2 = scriptResolverEnv;
                String string2 = $receiver.getBasePath();
                if (string2 == null) {
                    VirtualFile virtualFile2 = $receiver.getBaseDir();
                    string2 = virtualFile2 != null ? virtualFile2.getCanonicalPath() : null;
                }
                Object object3 = string2;
                HashMap<String, Object> hashMap3 = hashMap2;
                String string3 = string;
                String string4 = object3;
                if (string4 != null) {
                    void p1;
                    $receiver = object2 = string4;
                    string = string3;
                    hashMap2 = hashMap3;
                    object3 = new File((String)p1);
                    hashMap3 = hashMap2;
                    string3 = string;
                    object = object3;
                } else {
                    object = null;
                }
                hashMap3.put(string3, object);
                return environment2;
            }
        }
        return null;
    }

    private final KotlinCoreEnvironment createCoreEnvironment(Disposable rootDisposable, CompilerConfiguration configuration) {
        KotlinCoreEnvironment result2 = KotlinCoreEnvironment.Companion.createForProduction(rootDisposable, configuration, EnvironmentConfigFiles.JVM_CONFIG_FILES);
        if (K2JVMCompiler.Companion.getInitStartNanos() != 0L) {
            long initNanos = System.nanoTime() - K2JVMCompiler.Companion.getInitStartNanos();
            Companion.reportPerf(configuration, "INIT: Compiler initialized in " + TimeUnit.NANOSECONDS.toMillis(initNanos) + " ms");
            K2JVMCompiler.Companion.setInitStartNanos(0L);
        }
        return result2;
    }

    @Override
    protected void setupPlatformSpecificArgumentsAndServices(@NotNull CompilerConfiguration configuration, @NotNull K2JVMCompilerArguments arguments2, @NotNull Services services) {
        block3: {
            Object object;
            Intrinsics.checkParameterIsNotNull(configuration, "configuration");
            Intrinsics.checkParameterIsNotNull(arguments2, "arguments");
            Intrinsics.checkParameterIsNotNull(services, "services");
            if (IncrementalCompilation.isEnabled()) {
                Object it;
                LookupTracker lookupTracker = services.get(LookupTracker.class);
                if (lookupTracker != null) {
                    it = object = lookupTracker;
                    configuration.put(CommonConfigurationKeys.LOOKUP_TRACKER, it);
                }
                IncrementalCompilationComponents incrementalCompilationComponents = services.get(IncrementalCompilationComponents.class);
                if (incrementalCompilationComponents != null) {
                    it = object = incrementalCompilationComponents;
                    configuration.put(JVMConfigurationKeys.INCREMENTAL_COMPILATION_COMPONENTS, it);
                }
            }
            String[] stringArray = arguments2.getAdditionalJavaModules();
            if (stringArray == null) break block3;
            String[] additionalJavaModules = object = stringArray;
            configuration.addAll(JVMConfigurationKeys.ADDITIONAL_JAVA_MODULES, (Collection)ArraysKt.toList((Object[])additionalJavaModules));
        }
    }

    @Override
    @NotNull
    public K2JVMCompilerArguments createArguments() {
        K2JVMCompilerArguments k2JVMCompilerArguments;
        K2JVMCompilerArguments $receiver = k2JVMCompilerArguments = new K2JVMCompilerArguments();
        if (System.getenv("KOTLIN_REPORT_PERF") != null) {
            $receiver.setReportPerf(true);
        }
        return k2JVMCompilerArguments;
    }

    @Override
    @NotNull
    public String executableScriptFileName() {
        return "kotlinc-jvm";
    }

    static {
        Companion = new Companion(null);
        initStartNanos = System.nanoTime();
        elapsedGCTime = new HashMap();
    }

    @JvmStatic
    public static final void main(@NotNull String[] args) {
        Intrinsics.checkParameterIsNotNull(args, "args");
        Companion.main(args);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\r\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J \u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001dH\u0002JA\u0010\u001e\u001a\u00020\u00132\u000e\u0010\u001f\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010 2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001d2\u0014\u0010!\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0004\u00a2\u0006\u0002\u0010\"J&\u0010#\u001a\u0012\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0018\u00010\u00042\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001dJ\u001b\u0010$\u001a\u00020\u00132\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00050 H\u0007\u00a2\u0006\u0002\u0010&J\u0018\u0010'\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u000e\u0010(\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010)\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0019J\u0016\u0010*\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010+\u001a\u00020\u0005J\u0006\u0010,\u001a\u00020\u0013R0\u0010\u0003\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\f\"\u0004\b\u0011\u0010\u000e\u00a8\u0006-"}, d2={"Lorg/jetbrains/kotlin/cli/jvm/K2JVMCompiler$Companion;", "", "()V", "elapsedGCTime", "Ljava/util/HashMap;", "", "", "Lkotlin/collections/HashMap;", "getElapsedGCTime", "()Ljava/util/HashMap;", "elapsedJITTime", "getElapsedJITTime", "()J", "setElapsedJITTime", "(J)V", "initStartNanos", "getInitStartNanos", "setInitStartNanos", "configureContentRoots", "", "paths", "Lorg/jetbrains/kotlin/utils/KotlinPaths;", "arguments", "Lorg/jetbrains/kotlin/cli/common/arguments/K2JVMCompilerArguments;", "configuration", "Lorg/jetbrains/kotlin/config/CompilerConfiguration;", "configureJdkHome", "Lorg/jetbrains/kotlin/cli/common/ExitCode;", "messageCollector", "Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;", "configureScriptDefinitions", "scriptTemplates", "", "scriptResolverEnv", "([Ljava/lang/String;Lorg/jetbrains/kotlin/config/CompilerConfiguration;Lorg/jetbrains/kotlin/cli/common/messages/MessageCollector;Ljava/util/HashMap;)V", "createScriptResolverEnvironment", "main", "args", "([Ljava/lang/String;)V", "putAdvancedOptions", "reportCompilationTime", "reportGCTime", "reportPerf", "message", "resetInitStartTime", "cli"})
    public static final class Companion {
        private final long getInitStartNanos() {
            return initStartNanos;
        }

        private final void setInitStartNanos(long l) {
            initStartNanos = l;
        }

        private final HashMap<String, Long> getElapsedGCTime() {
            return elapsedGCTime;
        }

        private final long getElapsedJITTime() {
            return elapsedJITTime;
        }

        private final void setElapsedJITTime(long l) {
            elapsedJITTime = l;
        }

        public final void resetInitStartTime() {
            if (this.getInitStartNanos() == 0L) {
                this.setInitStartNanos(System.nanoTime());
            }
        }

        @JvmStatic
        public final void main(@NotNull String[] args) {
            Intrinsics.checkParameterIsNotNull(args, "args");
            CLITool.Companion.doMain(new K2JVMCompiler(), args);
        }

        public final void reportPerf(@NotNull CompilerConfiguration configuration, @NotNull String message) {
            Intrinsics.checkParameterIsNotNull(configuration, "configuration");
            Intrinsics.checkParameterIsNotNull(message, "message");
            if (!configuration.getBoolean(CLIConfigurationKeys.REPORT_PERF)) {
                return;
            }
            MessageCollector.DefaultImpls.report$default(configuration.getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY), CompilerMessageSeverity.INFO, "PERF: " + message, null, 4, null);
        }

        public final void reportGCTime(@NotNull CompilerConfiguration configuration) {
            Intrinsics.checkParameterIsNotNull(configuration, "configuration");
            List<GarbageCollectorMXBean> list2 = ManagementFactory.getGarbageCollectorMXBeans();
            Intrinsics.checkExpressionValueIsNotNull(list2, "ManagementFactory.getGarbageCollectorMXBeans()");
            Iterable $receiver$iv = list2;
            for (Object element$iv : $receiver$iv) {
                String string;
                String string2;
                GarbageCollectorMXBean it;
                GarbageCollectorMXBean garbageCollectorMXBean = it = (GarbageCollectorMXBean)element$iv;
                Intrinsics.checkExpressionValueIsNotNull(garbageCollectorMXBean, "it");
                long currentTime = garbageCollectorMXBean.getCollectionTime();
                Map map2 = Companion.getElapsedGCTime();
                Intrinsics.checkExpressionValueIsNotNull(it.getName(), "it.name");
                Object object = map2.get(string2);
                if (object == null) {
                    object = 0L;
                }
                long elapsedTime = ((Number)object).longValue();
                long time = currentTime - elapsedTime;
                Companion.reportPerf(configuration, "GC time for " + it.getName() + " is " + time + " ms");
                Map map3 = Companion.getElapsedGCTime();
                Intrinsics.checkExpressionValueIsNotNull(it.getName(), "it.name");
                Long l = currentTime;
                map3.put(string, l);
            }
        }

        public final void reportCompilationTime(@NotNull CompilerConfiguration configuration) {
            Intrinsics.checkParameterIsNotNull(configuration, "configuration");
            CompilationMXBean compilationMXBean = ManagementFactory.getCompilationMXBean();
            if (compilationMXBean == null) {
                return;
            }
            CompilationMXBean bean = compilationMXBean;
            long currentTime = bean.getTotalCompilationTime();
            this.reportPerf(configuration, "JIT time is " + (currentTime - this.getElapsedJITTime()) + " ms");
            this.setElapsedJITTime(currentTime);
        }

        /*
         * WARNING - void declaration
         */
        private final void putAdvancedOptions(CompilerConfiguration configuration, K2JVMCompilerArguments arguments2) {
            block4: {
                JVMConstructorCallNormalizationMode jVMConstructorCallNormalizationMode;
                Object object;
                configuration.put(JVMConfigurationKeys.DISABLE_CALL_ASSERTIONS, arguments2.getNoCallAssertions());
                configuration.put(JVMConfigurationKeys.DISABLE_RECEIVER_ASSERTIONS, arguments2.getNoReceiverAssertions());
                configuration.put(JVMConfigurationKeys.DISABLE_PARAM_ASSERTIONS, arguments2.getNoParamAssertions());
                configuration.put(JVMConfigurationKeys.NO_EXCEPTION_ON_EXPLICIT_EQUALS_FOR_BOXED_NULL, arguments2.getNoExceptionOnExplicitEqualsForBoxedNull());
                configuration.put(JVMConfigurationKeys.DISABLE_OPTIMIZATION, arguments2.getNoOptimize());
                JVMConstructorCallNormalizationMode constructorCallNormalizationMode = JVMConstructorCallNormalizationMode.Companion.fromStringOrNull(arguments2.getConstructorCallNormalizationMode());
                if (constructorCallNormalizationMode == null) {
                    Collection<String> collection;
                    void $receiver$iv$iv;
                    void $receiver$iv;
                    object = (Object[])JVMConstructorCallNormalizationMode.values();
                    StringBuilder stringBuilder = new StringBuilder().append("Unknown constructor call normalization mode: ").append(arguments2.getConstructorCallNormalizationMode()).append(", ").append("supported modes: ");
                    CompilerMessageSeverity compilerMessageSeverity = CompilerMessageSeverity.ERROR;
                    MessageCollector messageCollector2 = configuration.getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
                    void var5_8 = $receiver$iv;
                    Collection destination$iv$iv = new ArrayList(((void)$receiver$iv).length);
                    for (int i = 0; i < ((void)$receiver$iv$iv).length; ++i) {
                        void it;
                        void item$iv$iv = $receiver$iv$iv[i];
                        JVMConstructorCallNormalizationMode jVMConstructorCallNormalizationMode2 = (JVMConstructorCallNormalizationMode)item$iv$iv;
                        collection = destination$iv$iv;
                        String string = it.getDescription();
                        collection.add(string);
                    }
                    collection = (List)destination$iv$iv;
                    MessageCollector.DefaultImpls.report$default(messageCollector2, compilerMessageSeverity, stringBuilder.append(collection).toString(), null, 4, null);
                }
                if ((jVMConstructorCallNormalizationMode = constructorCallNormalizationMode) == null) {
                    jVMConstructorCallNormalizationMode = JVMConstructorCallNormalizationMode.DEFAULT;
                }
                configuration.put(JVMConfigurationKeys.CONSTRUCTOR_CALL_NORMALIZATION_MODE, jVMConstructorCallNormalizationMode);
                configuration.put(JVMConfigurationKeys.INHERIT_MULTIFILE_PARTS, arguments2.getInheritMultifileParts());
                configuration.put(JVMConfigurationKeys.SKIP_RUNTIME_VERSION_CHECK, arguments2.getSkipRuntimeVersionCheck());
                configuration.put(JVMConfigurationKeys.USE_FAST_CLASS_FILES_READING, !arguments2.getUseOldClassFilesReading());
                if (arguments2.getUseOldClassFilesReading()) {
                    MessageCollector.DefaultImpls.report$default(configuration.getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY), CompilerMessageSeverity.INFO, "Using the old java class files reading implementation", null, 4, null);
                }
                configuration.put(CLIConfigurationKeys.ALLOW_KOTLIN_PACKAGE, arguments2.getAllowKotlinPackage());
                configuration.put(CLIConfigurationKeys.REPORT_PERF, arguments2.getReportPerf());
                configuration.put(JVMConfigurationKeys.USE_SINGLE_MODULE, arguments2.getSingleModule());
                configuration.put(JVMConfigurationKeys.ADD_BUILT_INS_FROM_COMPILER_TO_DEPENDENCIES, arguments2.getAddCompilerBuiltIns());
                configuration.put(JVMConfigurationKeys.CREATE_BUILT_INS_FROM_MODULE_DEPENDENCIES, arguments2.getLoadBuiltInsFromDependencies());
                String string = arguments2.getDeclarationsOutputPath();
                if (string == null) break block4;
                Object it = object = string;
                configuration.put(JVMConfigurationKeys.DECLARATIONS_JSON_PATH, it);
            }
        }

        private final void configureContentRoots(KotlinPaths paths, K2JVMCompilerArguments arguments2, CompilerConfiguration configuration) {
            MessageCollector messageCollector2 = configuration.getNotNull(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY);
            String string = arguments2.getClasspath();
            List list2 = string != null ? StringsKt.split$default((CharSequence)string, new char[]{File.pathSeparatorChar}, false, 0, 6, null) : null;
            List list3 = list2;
            if (list3 == null) {
                list3 = CollectionsKt.emptyList();
            }
            for (String path2 : list3) {
                configuration.add(JVMConfigurationKeys.CONTENT_ROOTS, new JvmClasspathRoot(new File(path2)));
            }
            String string2 = arguments2.getJavaModulePath();
            list2 = string2 != null ? StringsKt.split$default((CharSequence)string2, new char[]{File.pathSeparatorChar}, false, 0, 6, null) : null;
            List list4 = list2;
            if (list4 == null) {
                list4 = CollectionsKt.emptyList();
            }
            for (String modularRoot : list4) {
                configuration.add(JVMConfigurationKeys.CONTENT_ROOTS, new JvmModulePathRoot(new File(modularRoot)));
            }
            File file = configuration.get(JVMConfigurationKeys.JDK_HOME);
            File it = file;
            boolean isModularJava = it != null && CoreJrtFileSystem.Companion.isModularJdk(it);
            Function4<String, String, Function1<? super KotlinPaths, ? extends File>, String, Unit> addRoot$ = new Function4<String, String, Function1<? super KotlinPaths, ? extends File>, String, Unit>(paths, messageCollector2, isModularJava, configuration){
                final /* synthetic */ KotlinPaths $paths;
                final /* synthetic */ MessageCollector $messageCollector;
                final /* synthetic */ boolean $isModularJava;
                final /* synthetic */ CompilerConfiguration $configuration;

                public final void invoke(@NotNull String moduleName, @NotNull String libraryName, @NotNull Function1<? super KotlinPaths, ? extends File> getLibrary, @NotNull String noLibraryArgument) {
                    Intrinsics.checkParameterIsNotNull(moduleName, "moduleName");
                    Intrinsics.checkParameterIsNotNull(libraryName, "libraryName");
                    Intrinsics.checkParameterIsNotNull(getLibrary, "getLibrary");
                    Intrinsics.checkParameterIsNotNull(noLibraryArgument, "noLibraryArgument");
                    File file = CLICompiler.getLibraryFromHome(this.$paths, getLibrary, libraryName, this.$messageCollector, noLibraryArgument);
                    if (file == null) {
                        return;
                    }
                    File file2 = file;
                    if (this.$isModularJava) {
                        File file3 = file2;
                        Intrinsics.checkExpressionValueIsNotNull(file3, "file");
                        this.$configuration.add(JVMConfigurationKeys.CONTENT_ROOTS, new JvmModulePathRoot(file3));
                        this.$configuration.add(JVMConfigurationKeys.ADDITIONAL_JAVA_MODULES, moduleName);
                    } else {
                        File file4 = file2;
                        Intrinsics.checkExpressionValueIsNotNull(file4, "file");
                        this.$configuration.add(JVMConfigurationKeys.CONTENT_ROOTS, new JvmClasspathRoot(file4));
                    }
                }
                {
                    this.$paths = kotlinPaths;
                    this.$messageCollector = messageCollector2;
                    this.$isModularJava = bl;
                    this.$configuration = compilerConfiguration;
                    super(4);
                }
            };
            if (!arguments2.getNoStdlib()) {
                addRoot$.invoke("kotlin.stdlib", "kotlin-stdlib.jar", (Function1<KotlinPaths, File>)((Function1<? super KotlinPaths, ? extends File>)configureContentRoots.2.INSTANCE), "'-no-stdlib'");
                addRoot$.invoke("kotlin.script.runtime", "kotlin-script-runtime.jar", (Function1<KotlinPaths, File>)((Function1<? super KotlinPaths, ? extends File>)configureContentRoots.3.INSTANCE), "'-no-stdlib'");
            }
            if (!arguments2.getNoReflect() && !arguments2.getNoStdlib()) {
                addRoot$.invoke("kotlin.reflect", "kotlin-reflect.jar", (Function1<KotlinPaths, File>)((Function1<? super KotlinPaths, ? extends File>)configureContentRoots.4.INSTANCE), "'-no-reflect' or '-no-stdlib'");
            }
        }

        private final ExitCode configureJdkHome(K2JVMCompilerArguments arguments2, CompilerConfiguration configuration, MessageCollector messageCollector2) {
            if (arguments2.getNoJdk()) {
                configuration.put(JVMConfigurationKeys.NO_JDK, true);
                if (arguments2.getJdkHome() != null) {
                    MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.STRONG_WARNING, "The '-jdk-home' option is ignored because '-no-jdk' is specified", null, 4, null);
                }
                return ExitCode.OK;
            }
            if (arguments2.getJdkHome() != null) {
                File jdkHome = new File(arguments2.getJdkHome());
                if (!jdkHome.exists()) {
                    MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.ERROR, "JDK home directory does not exist: " + jdkHome, null, 4, null);
                    return ExitCode.COMPILATION_ERROR;
                }
                MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.LOGGING, "Using JDK home directory " + jdkHome, null, 4, null);
                configuration.put(JVMConfigurationKeys.JDK_HOME, jdkHome);
            }
            return ExitCode.OK;
        }

        /*
         * WARNING - void declaration
         */
        public final void configureScriptDefinitions(@Nullable String[] scriptTemplates, @NotNull CompilerConfiguration configuration, @NotNull MessageCollector messageCollector2, @NotNull HashMap<String, Object> scriptResolverEnv) {
            Object[] objectArray;
            Object[] objectArray2;
            Intrinsics.checkParameterIsNotNull(configuration, "configuration");
            Intrinsics.checkParameterIsNotNull(messageCollector2, "messageCollector");
            Intrinsics.checkParameterIsNotNull(scriptResolverEnv, "scriptResolverEnv");
            List<File> classpath = JvmContentRootsKt.getJvmClasspathRoots(configuration);
            if (scriptTemplates != null && !((objectArray2 = (objectArray = (Object[])scriptTemplates)).length == 0)) {
                Collection<URL> collection;
                void $receiver$iv$iv;
                Iterable $receiver$iv;
                Iterable iterable = $receiver$iv = (Iterable)classpath;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
                for (Object item$iv$iv : $receiver$iv$iv) {
                    void it;
                    File file = (File)item$iv$iv;
                    collection = destination$iv$iv;
                    URL uRL = it.toURI().toURL();
                    collection.add(uRL);
                }
                collection = (List)destination$iv$iv;
                $receiver$iv = collection;
                Iterable thisCollection$iv = $receiver$iv;
                URL[] uRLArray = thisCollection$iv.toArray(new URL[thisCollection$iv.size()]);
                if (uRLArray == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                Thread thread2 = Thread.currentThread();
                Intrinsics.checkExpressionValueIsNotNull(thread2, "Thread.currentThread()");
                ClassLoader classLoader = thread2.getContextClassLoader();
                URL[] uRLArray2 = uRLArray;
                URLClassLoader classloader = new URLClassLoader(uRLArray2, classLoader);
                boolean hasErrors = false;
                for (int i = 0; i < scriptTemplates.length; ++i) {
                    String template = scriptTemplates[i];
                    try {
                        Class<?> cls;
                        Class<?> clazz = cls = classloader.loadClass(template);
                        Intrinsics.checkExpressionValueIsNotNull(clazz, "cls");
                        KotlinScriptDefinitionFromAnnotatedTemplate def = new KotlinScriptDefinitionFromAnnotatedTemplate(JvmClassMappingKt.getKotlinClass(clazz), null, null, scriptResolverEnv, null, 16, null);
                        configuration.add(JVMConfigurationKeys.SCRIPT_DEFINITIONS, def);
                        MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.INFO, "Added script definition " + template + " to configuration: files pattern = \"" + def.getScriptFilePattern() + "\", " + "resolver = " + def.getDependencyResolver().getClass().getName(), null, 4, null);
                        continue;
                    }
                    catch (ClassNotFoundException ex) {
                        MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.ERROR, "Cannot find script definition template class " + template, null, 4, null);
                        hasErrors = true;
                        continue;
                    }
                    catch (Exception ex) {
                        MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.ERROR, "Error processing script definition template " + template + ": " + ex.getMessage(), null, 4, null);
                        hasErrors = true;
                        break;
                    }
                }
                if (hasErrors) {
                    MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.LOGGING, "(Classpath used for templates loading: " + classpath + ')', null, 4, null);
                    return;
                }
            }
            configuration.add(JVMConfigurationKeys.SCRIPT_DEFINITIONS, StandardScriptDefinition.INSTANCE);
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final HashMap<String, Object> createScriptResolverEnvironment(@NotNull K2JVMCompilerArguments arguments2, @NotNull MessageCollector messageCollector2) {
            Intrinsics.checkParameterIsNotNull(arguments2, "arguments");
            Intrinsics.checkParameterIsNotNull(messageCollector2, "messageCollector");
            HashMap<String, Object> scriptResolverEnv = new HashMap<String, Object>();
            String string = "(\\w+)=(?:\"([^\"\\\\]*(\\\\.[^\"\\\\]*)*)\"|([^\\s]*))";
            Regex envParseRe = new Regex(string);
            String string2 = "\\\\([\"\\\\])";
            Regex unescapeRe = new Regex(string2);
            if (arguments2.getScriptResolverEnvironment() != null) {
                String[] stringArray = arguments2.getScriptResolverEnvironment();
                if (stringArray == null) {
                    Intrinsics.throwNpe();
                }
                String[] stringArray2 = stringArray;
                for (int i = 0; i < stringArray2.length; ++i) {
                    String string3;
                    String string4;
                    HashMap<String, Object> hashMap;
                    String string5;
                    Object object;
                    block7: {
                        void $receiver$iv;
                        String envParam = stringArray2[i];
                        MatchResult match2 = envParseRe.matchEntire(envParam);
                        if (match2 == null || match2.getGroupValues().size() < 4 || StringsKt.isBlank(match2.getGroupValues().get(1))) {
                            MessageCollector.DefaultImpls.report$default(messageCollector2, CompilerMessageSeverity.ERROR, "Unable to parse script-resolver-environment argument " + envParam, null, 4, null);
                            return null;
                        }
                        object = CollectionsKt.drop((Iterable)match2.getGroupValues(), 2);
                        string5 = match2.getGroupValues().get(1);
                        hashMap = scriptResolverEnv;
                        for (Object element$iv : $receiver$iv) {
                            String it = (String)element$iv;
                            CharSequence charSequence = it;
                            if (!(charSequence.length() > 0)) continue;
                            string4 = (String)element$iv;
                            break block7;
                        }
                        string4 = null;
                    }
                    String string6 = string4;
                    HashMap<String, Object> hashMap2 = hashMap;
                    String string7 = string5;
                    String string8 = string6;
                    if (string8 != null) {
                        void it;
                        Object object2 = object = string8;
                        string5 = string7;
                        hashMap = hashMap2;
                        string6 = unescapeRe.replace((CharSequence)it, "$1");
                        hashMap2 = hashMap;
                        string7 = string5;
                        string3 = string6;
                    } else {
                        string3 = null;
                    }
                    hashMap2.put(string7, string3);
                }
            }
            return scriptResolverEnv;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

