/*
 * Decompiled with CFR 0.152.
 */
package javaslang.collection;

import java.io.Serializable;
import java.util.NoSuchElementException;
import java.util.Objects;
import javaslang.collection.HashArrayMappedTrie;
import javaslang.collection.Iterator;
import javaslang.collection.Set;

public final class HashSet<T>
implements Serializable,
Set<T> {
    private static final HashSet<?> EMPTY = new HashSet(HashArrayMappedTrie.empty());
    private final HashArrayMappedTrie<T, T> tree;

    private HashSet(HashArrayMappedTrie<T, T> tree) {
        this.tree = tree;
    }

    public static <T> HashSet<T> empty() {
        return EMPTY;
    }

    public static <T> HashSet<T> ofAll(Iterable<? extends T> elements) {
        Objects.requireNonNull(elements, "elements is null");
        if (elements instanceof HashSet) {
            return (HashSet)elements;
        }
        HashArrayMappedTrie<T, T> tree = HashSet.addAll(HashArrayMappedTrie.empty(), elements);
        return tree.isEmpty() ? HashSet.empty() : new HashSet<T>(tree);
    }

    @Override
    public HashSet<T> add(T element) {
        return this.contains(element) ? this : new HashSet<T>(this.tree.put(element, element));
    }

    @Override
    public boolean contains(T element) {
        return this.tree.get(element).isDefined();
    }

    @Override
    public T head() {
        if (this.tree.isEmpty()) {
            throw new NoSuchElementException("head of empty set");
        }
        return (T)this.iterator().next();
    }

    @Override
    public boolean isEmpty() {
        return this.tree.isEmpty();
    }

    @Override
    public boolean isTraversableAgain() {
        return true;
    }

    @Override
    public Iterator<T> iterator() {
        return this.tree.keysIterator();
    }

    @Override
    public int length() {
        return this.tree.size();
    }

    @Override
    public String mkString(CharSequence prefix, CharSequence delimiter, CharSequence suffix) {
        return this.iterator().mkString(prefix, delimiter, suffix);
    }

    public HashSet<T> remove(T element) {
        HashArrayMappedTrie<T, T> newTree = this.tree.remove(element);
        return newTree == this.tree ? this : new HashSet<T>(newTree);
    }

    @Override
    public HashSet<T> tail() {
        if (this.tree.isEmpty()) {
            throw new UnsupportedOperationException("tail of empty set");
        }
        return this.remove(this.head());
    }

    public int hashCode() {
        return this.tree.hashCode();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof HashSet) {
            HashSet that = (HashSet)o;
            return this.tree.equals(that.tree);
        }
        return false;
    }

    @Override
    public String stringPrefix() {
        return "HashSet";
    }

    @Override
    public String toString() {
        return this.mkString(this.stringPrefix() + "(", ", ", ")");
    }

    private static <T> HashArrayMappedTrie<T, T> addAll(HashArrayMappedTrie<T, T> initial, Iterable<? extends T> additional) {
        HashArrayMappedTrie<T, T> that = initial;
        for (T t : additional) {
            that = that.put(t, t);
        }
        return that;
    }
}

