/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class FileContentUtilCore {
    public static void reparseFiles(VirtualFile ... files2) {
        if (files2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/util/FileContentUtilCore", "reparseFiles"));
        }
        FileContentUtilCore.reparseFiles(Arrays.asList(files2));
    }

    public static void reparseFiles(@NotNull Collection<VirtualFile> files2) {
        if (files2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/util/FileContentUtilCore", "reparseFiles"));
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            if (files2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/util/FileContentUtilCore", "lambda$reparseFiles$0"));
            }
            THashSet<VFilePropertyChangeEvent> events = new THashSet<VFilePropertyChangeEvent>();
            for (VirtualFile file : files2) {
                FileContentUtilCore.saveOrReload(file, events);
            }
            BulkFileListener publisher = ApplicationManager.getApplication().getMessageBus().syncPublisher(VirtualFileManager.VFS_CHANGES);
            ArrayList<VFilePropertyChangeEvent> eventList = new ArrayList<VFilePropertyChangeEvent>(events);
            publisher.before(eventList);
            publisher.after(eventList);
        });
    }

    private static void saveOrReload(VirtualFile file, @NotNull Collection<VFilePropertyChangeEvent> events) {
        Document document;
        if (events == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/util/FileContentUtilCore", "saveOrReload"));
        }
        if (file == null || file.isDirectory() || !file.isValid()) {
            return;
        }
        FileDocumentManager documentManager = FileDocumentManager.getInstance();
        if (documentManager.isFileModified(file) && (document = documentManager.getDocument(file)) != null) {
            documentManager.saveDocumentAsIs(document);
        }
        events.add(new VFilePropertyChangeEvent("FileContentUtilCore.saveOrReload", file, "name", file.getName(), file.getName(), false));
    }
}

