/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaElementType;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.util.containers.HashMap;
import org.jetbrains.annotations.Nullable;

public class ModifierListElement
extends CompositeElement {
    private static final Logger LOG = Logger.getInstance("#com.intellij.psi.impl.source.tree.java.ModifierListElement");
    private static final HashMap<String, Integer> ourModifierToOrderMap = new HashMap();

    public ModifierListElement() {
        super(JavaElementType.MODIFIER_LIST);
    }

    @Override
    public TreeElement addInternal(TreeElement first, ASTNode last, ASTNode anchor2, Boolean before) {
        if (before == null && first == last && ElementType.KEYWORD_BIT_SET.contains(first.getElementType())) {
            anchor2 = ModifierListElement.getDefaultAnchor((PsiModifierList)SourceTreeToPsiMap.treeElementToPsi(this), (PsiKeyword)SourceTreeToPsiMap.treeElementToPsi(first));
            before = Boolean.TRUE;
        }
        return super.addInternal(first, last, anchor2, before);
    }

    @Override
    public int getChildRole(ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        if (child.getElementType() == JavaElementType.ANNOTATION) {
            return 250;
        }
        return 0;
    }

    @Nullable
    private static ASTNode getDefaultAnchor(PsiModifierList modifierList, PsiKeyword modifier) {
        Integer order = (Integer)ourModifierToOrderMap.get(modifier.getText());
        if (order == null) {
            return null;
        }
        for (ASTNode child = SourceTreeToPsiMap.psiToTreeNotNull(modifierList).getFirstChildNode(); child != null; child = child.getTreeNext()) {
            Integer order1;
            if (!ElementType.KEYWORD_BIT_SET.contains(child.getElementType()) || (order1 = (Integer)ourModifierToOrderMap.get(child.getText())) == null || order1 <= order) continue;
            return child;
        }
        return null;
    }

    static {
        ourModifierToOrderMap.put("public", 1);
        ourModifierToOrderMap.put("private", 1);
        ourModifierToOrderMap.put("protected", 1);
        ourModifierToOrderMap.put("static", 2);
        ourModifierToOrderMap.put("abstract", 2);
        ourModifierToOrderMap.put("final", 3);
        ourModifierToOrderMap.put("synchronized", 4);
        ourModifierToOrderMap.put("transient", 4);
        ourModifierToOrderMap.put("volatile", 4);
        ourModifierToOrderMap.put("native", 5);
        ourModifierToOrderMap.put("strictfp", 6);
    }
}

