/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree;

import com.intellij.lang.ASTFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.DummyHolderFactory;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.PsiErrorElementImpl;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.CharTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Factory {
    private Factory() {
    }

    @NotNull
    public static LeafElement createSingleLeafElement(@NotNull IElementType type2, CharSequence buffer, int startOffset, int endOffset, CharTable table, PsiManager manager, PsiFile originalFile) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/impl/source/tree/Factory", "createSingleLeafElement"));
        }
        DummyHolder dummyHolder = DummyHolderFactory.createHolder(manager, table, type2.getLanguage());
        dummyHolder.setOriginalFile(originalFile);
        FileElement holderElement = dummyHolder.getTreeElement();
        LeafElement newElement = ASTFactory.leaf(type2, holderElement.getCharTable().intern(buffer, startOffset, endOffset));
        holderElement.rawAddChildren(newElement);
        CodeEditUtil.setNodeGenerated(newElement, true);
        LeafElement leafElement = newElement;
        if (leafElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/Factory", "createSingleLeafElement"));
        }
        return leafElement;
    }

    @NotNull
    public static LeafElement createSingleLeafElement(@NotNull IElementType type2, CharSequence buffer, int startOffset, int endOffset, CharTable table, PsiManager manager, boolean generatedFlag) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/impl/source/tree/Factory", "createSingleLeafElement"));
        }
        FileElement holderElement = DummyHolderFactory.createHolder(manager, table, type2.getLanguage()).getTreeElement();
        LeafElement newElement = ASTFactory.leaf(type2, holderElement.getCharTable().intern(buffer, startOffset, endOffset));
        holderElement.rawAddChildren(newElement);
        if (generatedFlag) {
            CodeEditUtil.setNodeGenerated(newElement, true);
        }
        LeafElement leafElement = newElement;
        if (leafElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/Factory", "createSingleLeafElement"));
        }
        return leafElement;
    }

    @NotNull
    public static LeafElement createSingleLeafElement(@NotNull IElementType type2, CharSequence buffer, CharTable table, PsiManager manager) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/impl/source/tree/Factory", "createSingleLeafElement"));
        }
        LeafElement leafElement = Factory.createSingleLeafElement(type2, buffer, 0, buffer.length(), table, manager);
        if (leafElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/Factory", "createSingleLeafElement"));
        }
        return leafElement;
    }

    @NotNull
    public static LeafElement createSingleLeafElement(@NotNull IElementType type2, CharSequence buffer, int startOffset, int endOffset, @Nullable CharTable table, PsiManager manager) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/impl/source/tree/Factory", "createSingleLeafElement"));
        }
        LeafElement leafElement = Factory.createSingleLeafElement(type2, buffer, startOffset, endOffset, table, manager, true);
        if (leafElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/Factory", "createSingleLeafElement"));
        }
        return leafElement;
    }

    @NotNull
    public static CompositeElement createErrorElement(String description2) {
        PsiErrorElementImpl psiErrorElementImpl = new PsiErrorElementImpl(description2);
        if (psiErrorElementImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/Factory", "createErrorElement"));
        }
        return psiErrorElementImpl;
    }

    @NotNull
    public static CompositeElement createCompositeElement(@NotNull IElementType type2, CharTable charTableByTree, PsiManager manager) {
        if (type2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/psi/impl/source/tree/Factory", "createCompositeElement"));
        }
        FileElement treeElement = DummyHolderFactory.createHolder(manager, null, charTableByTree).getTreeElement();
        CompositeElement composite = ASTFactory.composite(type2);
        treeElement.rawAddChildren(composite);
        CompositeElement compositeElement = composite;
        if (compositeElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/Factory", "createCompositeElement"));
        }
        return compositeElement;
    }
}

