/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.light;

import com.intellij.lang.Language;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.impl.light.LightElement;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class LightTypeParameterListBuilder
extends LightElement
implements PsiTypeParameterList {
    private final List<PsiTypeParameter> myParameters = new ArrayList<PsiTypeParameter>();
    private PsiTypeParameter[] cached;

    public LightTypeParameterListBuilder(PsiManager manager, Language language) {
        super(manager, language);
    }

    @Override
    public String toString() {
        return "Light type parameter list";
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor2) {
        if (visitor2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/psi/impl/light/LightTypeParameterListBuilder", "accept"));
        }
        if (visitor2 instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor2).visitTypeParameterList(this);
        } else {
            visitor2.visitElement(this);
        }
    }

    @Override
    @NotNull
    public PsiTypeParameter[] getTypeParameters() {
        if (this.cached == null) {
            this.cached = this.myParameters.isEmpty() ? PsiTypeParameter.EMPTY_ARRAY : this.myParameters.toArray(new PsiTypeParameter[this.myParameters.size()]);
        }
        if (this.cached == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/light/LightTypeParameterListBuilder", "getTypeParameters"));
        }
        return this.cached;
    }

    @Override
    public int getTypeParameterIndex(PsiTypeParameter typeParameter) {
        return this.myParameters.indexOf(typeParameter);
    }

    public void addParameter(PsiTypeParameter parameter) {
        this.cached = null;
        this.myParameters.add(parameter);
    }
}

