/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.filters;

import com.intellij.psi.PsiElement;
import com.intellij.psi.filters.ElementFilter;
import org.jetbrains.annotations.NotNull;

public abstract class ElementFilterBase<T>
implements ElementFilter {
    private final Class<T> myClass;

    public ElementFilterBase(@NotNull Class<T> aClass2) {
        if (aClass2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/psi/filters/ElementFilterBase", "<init>"));
        }
        this.myClass = aClass2;
    }

    @Override
    public final boolean isAcceptable(Object element, PsiElement context) {
        return this.isClassAcceptable(element.getClass()) && this.isElementAcceptable(element, context);
    }

    protected abstract boolean isElementAcceptable(@NotNull T var1, PsiElement var2);

    @Override
    public boolean isClassAcceptable(Class hintClass) {
        return this.myClass.isAssignableFrom(hintClass);
    }
}

