/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.newvfs.events;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class VFileContentChangeEvent
extends VFileEvent {
    private final VirtualFile myFile;
    private final long myOldModificationStamp;
    private final long myNewModificationStamp;

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile2 = this.myFile;
        if (virtualFile2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/events/VFileContentChangeEvent", "getFile"));
        }
        return virtualFile2;
    }

    public long getModificationStamp() {
        return this.myNewModificationStamp;
    }

    public long getOldModificationStamp() {
        return this.myOldModificationStamp;
    }

    @NonNls
    public String toString() {
        return "VfsEvent[update: " + this.myFile.getUrl() + "]";
    }

    @Override
    @NotNull
    public VirtualFileSystem getFileSystem() {
        VirtualFileSystem virtualFileSystem = this.myFile.getFileSystem();
        if (virtualFileSystem == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/newvfs/events/VFileContentChangeEvent", "getFileSystem"));
        }
        return virtualFileSystem;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VFileContentChangeEvent event = (VFileContentChangeEvent)o;
        if (this.myNewModificationStamp != event.myNewModificationStamp) {
            return false;
        }
        if (this.myOldModificationStamp != event.myOldModificationStamp) {
            return false;
        }
        return this.myFile.equals(event.myFile);
    }

    public int hashCode() {
        int result2 = this.myFile.hashCode();
        result2 = 31 * result2 + (int)(this.myOldModificationStamp ^ this.myOldModificationStamp >>> 32);
        result2 = 31 * result2 + (int)(this.myNewModificationStamp ^ this.myNewModificationStamp >>> 32);
        return result2;
    }
}

