/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.progress;

import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.StandardProgressIndicator;
import org.jetbrains.annotations.NotNull;

public class EmptyProgressIndicator
implements StandardProgressIndicator {
    private static final Logger LOG = Logger.getInstance(EmptyProgressIndicator.class);
    @NotNull
    private final ModalityState myModalityState;
    private volatile boolean myIsRunning;
    private volatile boolean myIsCanceled;

    public EmptyProgressIndicator() {
        this(ModalityState.defaultModalityState());
    }

    public EmptyProgressIndicator(@NotNull ModalityState modalityState) {
        if (modalityState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modalityState", "com/intellij/openapi/progress/EmptyProgressIndicator", "<init>"));
        }
        this.myModalityState = modalityState;
    }

    @Override
    public void start() {
        this.myIsRunning = true;
        this.myIsCanceled = false;
    }

    @Override
    public void stop() {
        this.myIsRunning = false;
    }

    @Override
    public boolean isRunning() {
        return this.myIsRunning;
    }

    @Override
    public final void cancel() {
        this.myIsCanceled = true;
        ProgressManager.canceled(this);
    }

    @Override
    public final boolean isCanceled() {
        return this.myIsCanceled;
    }

    @Override
    public final void checkCanceled() {
        if (this.myIsCanceled) {
            throw new ProcessCanceledException();
        }
    }

    @Override
    public void setText(String text2) {
    }

    @Override
    public void setText2(String text2) {
    }

    @Override
    public boolean isModal() {
        return false;
    }
}

