/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.admin;

import com.intellij.util.text.SyncDateFormat;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.jetbrains.annotations.NonNls;
import org.netbeans.lib.cvsclient.admin.InvalidEntryFormatException;

public final class Entry
implements Cloneable {
    @NonNls
    public static final String DUMMY_TIMESTAMP = "dummy timestamp";
    @NonNls
    private static final String DUMMY_TIMESTAMP_NEW_ENTRY = "dummy timestamp from new-entry";
    @NonNls
    private static final String MERGE_TIMESTAMP = "Result of merge";
    @NonNls
    private static final String STICKY_TAG_REVISION_PREFIX = "T";
    @NonNls
    private static final String STICKY_DATE_PREFIX = "D";
    @NonNls
    private static final String BINARY_FILE = "-kb";
    @NonNls
    private static final String HAD_CONFLICTS = "+";
    @NonNls
    private static final char TIMESTAMP_MATCHES_FILE = '=';
    @NonNls
    private static final String DIRECTORY_PREFIX = "D/";
    @NonNls
    private static final String DATE_FORMAT_STR = "yyyy.MM.dd.hh.mm.ss";
    public static final SyncDateFormat STICKY_DATE_FORMAT = new SyncDateFormat((DateFormat)new SimpleDateFormat("yyyy.MM.dd.hh.mm.ss"));
    private static SyncDateFormat lastModifiedDateFormatter;
    private boolean isAddedFile = false;
    private boolean isRemoved = false;
    private boolean isResultOfMerge = false;
    @NonNls
    private static final String LAST_MODIFIED_DATE_FORMAT_ATR = "EEE MMM dd HH:mm:ss yyyy";
    @NonNls
    private static final String TIME_ZONE_FORMAT_STR = "GMT+0000";
    @NonNls
    private static final String INITIAL_PREFIX = "Initial ";
    private boolean directory;
    private String fileName;
    private Date lastModified;
    private String revision;
    private boolean conflict;
    private boolean timeStampMatchesFile;
    private String conflictString;
    private String conflictStringWithoutConflictMarker;
    private String options;
    private String stickyRevision;
    private String stickyTag;
    private String stickyDateString;
    private Date stickyDate;

    public static SyncDateFormat getLastModifiedDateFormatter() {
        if (lastModifiedDateFormatter == null) {
            lastModifiedDateFormatter = new SyncDateFormat((DateFormat)new SimpleDateFormat(LAST_MODIFIED_DATE_FORMAT_ATR, Locale.US));
            lastModifiedDateFormatter.setTimeZone(TimeZone.getTimeZone(TIME_ZONE_FORMAT_STR));
        }
        return lastModifiedDateFormatter;
    }

    public static String formatLastModifiedDate(Date date) {
        return Entry.getLastModifiedDateFormatter().format(date);
    }

    public static Entry createDirectoryEntry(String directoryName) {
        Entry entry = new Entry();
        entry.setFileName(directoryName);
        entry.setDirectory(true);
        return entry;
    }

    public static Entry createEntryForLine(String entryLine) {
        Entry entry = new Entry();
        entry.parseLine(entryLine);
        return entry;
    }

    private Entry() {
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.directory) {
            buf.append(DIRECTORY_PREFIX);
        } else {
            buf.append('/');
        }
        if (this.fileName != null) {
            buf.append(this.fileName);
            buf.append('/');
            if (this.revision != null) {
                buf.append(this.revision);
            }
            buf.append('/');
            if (this.conflictString != null) {
                buf.append(this.conflictString);
            }
            buf.append('/');
            if (this.options != null) {
                buf.append(this.options);
            }
            buf.append('/');
            buf.append(this.getStickyData());
        }
        return buf.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        String entryFileName = ((Entry)obj).fileName;
        return this.fileName == entryFileName || this.fileName != null && this.fileName.equals(entryFileName);
    }

    public int hashCode() {
        return this.fileName != null ? this.fileName.hashCode() : 0;
    }

    public String getFileName() {
        return this.fileName;
    }

    private void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getRevision() {
        return this.revision;
    }

    public void setRevision(String revision) {
        this.revision = revision;
        this.isAddedFile = revision != null && revision.startsWith("0");
        this.isRemoved = revision != null && revision.startsWith("-");
    }

    public Date getLastModified() {
        return this.lastModified;
    }

    public void setDummyTimestamp() {
        this.parseConflictString(DUMMY_TIMESTAMP);
    }

    public boolean isResultOfMerge() {
        return this.isResultOfMerge;
    }

    public void setConflict(String conflictString) {
        this.conflictString = conflictString;
        this.isResultOfMerge = conflictString != null && conflictString.startsWith(MERGE_TIMESTAMP);
    }

    public void parseConflictString(String conflictString) {
        int timeMatchIndex;
        this.setConflict(conflictString);
        this.conflictStringWithoutConflictMarker = conflictString;
        this.lastModified = null;
        this.conflict = false;
        this.timeStampMatchesFile = false;
        if (conflictString == null || conflictString.equals(DUMMY_TIMESTAMP) || conflictString.equals(MERGE_TIMESTAMP) || conflictString.equals(DUMMY_TIMESTAMP_NEW_ENTRY)) {
            return;
        }
        int parseStartIndex = 0;
        int conflictIndex = this.conflictStringWithoutConflictMarker.indexOf(HAD_CONFLICTS);
        if (conflictIndex >= 0) {
            this.conflict = true;
            parseStartIndex = conflictIndex + 1;
        }
        if ((timeMatchIndex = this.conflictStringWithoutConflictMarker.indexOf(61)) >= 0) {
            this.timeStampMatchesFile = true;
            parseStartIndex = Math.max(parseStartIndex, timeMatchIndex + 1);
        }
        if (parseStartIndex > 0) {
            this.conflictStringWithoutConflictMarker = this.conflictStringWithoutConflictMarker.substring(parseStartIndex);
        }
        if (this.conflictStringWithoutConflictMarker.length() == 0) {
            this.conflictStringWithoutConflictMarker = null;
            return;
        }
        if (this.conflictStringWithoutConflictMarker.startsWith(INITIAL_PREFIX)) {
            return;
        }
        try {
            this.lastModified = Entry.getLastModifiedDateFormatter().parse(this.conflictStringWithoutConflictMarker);
        }
        catch (Exception ex) {
            this.lastModified = null;
            System.err.println("[Entry] can't parse conflict '" + this.conflictStringWithoutConflictMarker + "'");
        }
    }

    public String getOptions() {
        return this.options;
    }

    public String getStickyTag() {
        return this.stickyTag;
    }

    public void setStickyTag(String stickyTag) {
        this.stickyTag = stickyTag;
        this.stickyRevision = null;
        this.stickyDateString = null;
        this.stickyDate = null;
    }

    public String getStickyRevision() {
        return this.stickyRevision;
    }

    public void setStickyRevision(String stickyRevision) {
        this.stickyTag = null;
        this.stickyRevision = stickyRevision;
        this.stickyDateString = null;
        this.stickyDate = null;
    }

    public String getStickyDateString() {
        return this.stickyDateString;
    }

    public void setStickyDateString(String stickyDateString) {
        this.stickyTag = null;
        this.stickyRevision = null;
        this.stickyDateString = stickyDateString;
        this.stickyDate = null;
    }

    public Date getStickyDate() {
        if (this.stickyDate != null) {
            return this.stickyDate;
        }
        if (this.stickyDateString == null) {
            return null;
        }
        try {
            return STICKY_DATE_FORMAT.parse(this.stickyDateString);
        }
        catch (ParseException ex) {
            return null;
        }
    }

    public void setStickyDate(Date stickyDate) {
        if (stickyDate == null) {
            this.stickyTag = null;
            this.stickyRevision = null;
            this.stickyDateString = null;
            this.stickyDate = null;
            return;
        }
        this.stickyTag = null;
        this.stickyRevision = null;
        this.stickyDateString = STICKY_DATE_FORMAT.format(stickyDate);
        this.stickyDate = stickyDate;
    }

    public String getStickyInformation() {
        if (this.stickyTag != null) {
            return this.stickyTag;
        }
        if (this.stickyRevision != null) {
            return this.stickyRevision;
        }
        return this.stickyDateString;
    }

    public void setStickyInformation(String stickyInformation) {
        if (stickyInformation == null) {
            this.resetStickyInformation();
            return;
        }
        if (stickyInformation.startsWith(STICKY_TAG_REVISION_PREFIX)) {
            String tagOrRevision = stickyInformation.substring(STICKY_TAG_REVISION_PREFIX.length());
            if (tagOrRevision.length() == 0) {
                this.resetStickyInformation();
                return;
            }
            char firstChar = tagOrRevision.charAt(0);
            if (firstChar >= '0' && firstChar <= '9') {
                this.setStickyRevision(tagOrRevision);
            } else {
                this.setStickyTag(tagOrRevision);
            }
            return;
        }
        if (stickyInformation.startsWith(STICKY_DATE_PREFIX)) {
            this.setStickyDateString(stickyInformation.substring(STICKY_DATE_PREFIX.length()));
        }
    }

    public boolean isBinary() {
        return this.options != null && this.options.equals(BINARY_FILE);
    }

    public boolean isUnicode() {
        if (this.options == null || !this.options.startsWith("-k")) {
            return false;
        }
        return this.options.indexOf(117, 2) >= 0;
    }

    public boolean isAddedFile() {
        return this.isAddedFile;
    }

    public boolean isRemoved() {
        return this.isRemoved;
    }

    public boolean isValid() {
        return this.getFileName() != null && this.getFileName().length() > 0;
    }

    public boolean isDirectory() {
        return this.directory;
    }

    private void setDirectory(boolean directory) {
        this.directory = directory;
    }

    public boolean isConflict() {
        return this.conflict;
    }

    public String getConflictStringWithoutConflict() {
        return this.conflictStringWithoutConflictMarker;
    }

    public boolean isTimeStampMatchesFile() {
        return this.timeStampMatchesFile;
    }

    private void parseLine(String entryLine) {
        if (entryLine.startsWith(DIRECTORY_PREFIX)) {
            this.directory = true;
            entryLine = entryLine.substring(1);
        }
        int[] slashPositions = new int[5];
        slashPositions[0] = 0;
        for (int i = 1; i < 5; ++i) {
            slashPositions[i] = entryLine.indexOf(47, slashPositions[i - 1] + 1);
        }
        if (slashPositions[1] < 1) {
            throw new InvalidEntryFormatException();
        }
        this.fileName = entryLine.substring(slashPositions[0] + 1, slashPositions[1]);
        this.setRevision(entryLine.substring(slashPositions[1] + 1, slashPositions[2]));
        if (slashPositions[3] - slashPositions[2] > 1) {
            String conflict = entryLine.substring(slashPositions[2] + 1, slashPositions[3]);
            this.parseConflictString(conflict);
        }
        if (slashPositions[4] - slashPositions[3] > 1) {
            this.options = entryLine.substring(slashPositions[3] + 1, slashPositions[4]);
        }
        if (slashPositions[4] != entryLine.length() - 1) {
            String tagOrDate = entryLine.substring(slashPositions[4] + 1);
            this.setStickyInformation(tagOrDate);
        }
    }

    private void resetStickyInformation() {
        this.stickyTag = null;
        this.stickyRevision = null;
        this.stickyDateString = null;
        this.stickyDate = null;
    }

    public String getStickyData() {
        StringBuffer buf = new StringBuffer();
        if (this.stickyTag != null) {
            buf.append(STICKY_TAG_REVISION_PREFIX);
            buf.append(this.stickyTag);
        } else if (this.stickyRevision != null) {
            buf.append(STICKY_TAG_REVISION_PREFIX);
            buf.append(this.stickyRevision);
        } else if (this.stickyDateString != null) {
            buf.append(STICKY_DATE_PREFIX);
            buf.append(this.getStickyDateString());
        }
        return buf.toString();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

