/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.geronimo.server;

import com.intellij.javaee.oss.server.JavaeePersistentData;
import com.intellij.javaee.oss.server.JavaeeServerVersionConfig;
import com.intellij.javaee.oss.server.JavaeeServerVersionDescriptor;
import com.intellij.javaee.oss.util.VersionUtil;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GeronimoServerVersionConfig
extends JavaeeServerVersionConfig {
    private static final JavaeeServerVersionConfig.Factory<JavaeePersistentData> ourFactory = new JavaeeServerVersionConfig.Factory<JavaeePersistentData>(){

        @NotNull
        public GeronimoServerVersionConfig createConfig(JavaeePersistentData data) {
            GeronimoServerVersionConfig geronimoServerVersionConfig = new GeronimoServerVersionConfig();
            if (geronimoServerVersionConfig == null) {
                1.$$$reportNull$$$0(0);
            }
            return geronimoServerVersionConfig;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/oss/geronimo/server/GeronimoServerVersionConfig$1", "createConfig"));
        }
    };

    private GeronimoServerVersionConfig() {
    }

    protected JavaeeServerVersionDescriptor getVersionDescriptor(String home) throws Exception {
        File stampFile = GeronimoServerVersionConfig.getFile(home);
        String version = VersionUtil.readJarProperty((File)stampFile, (String)"org/apache/geronimo/system/serverinfo/geronimo-version.properties", (String)"version");
        return new JavaeeServerVersionDescriptor(version, stampFile);
    }

    @Nullable
    private static File getFile(String home) {
        File file = GeronimoServerVersionConfig.getFile(new File(home, "lib"));
        if (file == null && (file = GeronimoServerVersionConfig.getFile(home, "repository/org/apache/geronimo/modules/geronimo-system")) == null) {
            file = GeronimoServerVersionConfig.getFile(home, "repository/org/apache/geronimo/framework/geronimo-system");
        }
        return file;
    }

    @Nullable
    private static File getFile(String home, String path) {
        File dir = new File(home, path);
        if (dir.isDirectory()) {
            return GeronimoServerVersionConfig.getFile(dir.listFiles()[0]);
        }
        return null;
    }

    @Nullable
    private static File getFile(File dir) {
        for (File file : dir.listFiles()) {
            if (!file.getName().matches("geronimo-system-.*\\.jar")) continue;
            return file;
        }
        return null;
    }

    public static String get(JavaeePersistentData data) throws Exception {
        return GeronimoServerVersionConfig.get(ourFactory, (JavaeePersistentData)data);
    }
}

