/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.geronimo.server;

import com.intellij.javaee.deployment.DeploymentProvider;
import com.intellij.javaee.facet.JavaeeFacet;
import com.intellij.javaee.openapi.ex.AppServerIntegrationsManager;
import com.intellij.javaee.oss.descriptor.JavaeeAppDescriptor;
import com.intellij.javaee.oss.descriptor.JavaeeDescriptorsManager;
import com.intellij.javaee.oss.descriptor.JavaeeEjbDescriptor;
import com.intellij.javaee.oss.descriptor.JavaeeWebDescriptor;
import com.intellij.javaee.oss.geronimo.GeronimoBundle;
import com.intellij.javaee.oss.geronimo.GeronimoUtil;
import com.intellij.javaee.oss.geronimo.model.GeronimoAppRoot;
import com.intellij.javaee.oss.geronimo.model.GeronimoEjbRoot;
import com.intellij.javaee.oss.geronimo.model.GeronimoWebRoot;
import com.intellij.javaee.oss.geronimo.server.GeronimoServerVersionConfig;
import com.intellij.javaee.oss.server.JavaeeDeploymentProvider;
import com.intellij.javaee.oss.server.JavaeeIntegration;
import com.intellij.javaee.oss.server.JavaeePersistentData;
import icons.IdeaGeronimoBaseIcons;
import java.io.File;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GeronimoIntegration
extends JavaeeIntegration {
    @NonNls
    private static final String PATTERN = "([\\w-]+)-(\\d\\.\\d(:?-\\w+)?)\\.xml";

    public static JavaeeIntegration getInstance() {
        return (JavaeeIntegration)AppServerIntegrationsManager.getInstance().getIntegration(GeronimoIntegration.class);
    }

    @NotNull
    public String getName() {
        String string = GeronimoBundle.getText("GeronimoIntegration.name", new Object[0]);
        if (string == null) {
            GeronimoIntegration.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = IdeaGeronimoBaseIcons.Geronimo;
        if (icon == null) {
            GeronimoIntegration.$$$reportNull$$$0(1);
        }
        return icon;
    }

    @NotNull
    public Icon getBigIcon() {
        Icon icon = IdeaGeronimoBaseIcons.Geronimobig;
        if (icon == null) {
            GeronimoIntegration.$$$reportNull$$$0(2);
        }
        return icon;
    }

    protected void collectDescriptors(JavaeeDescriptorsManager descriptorsManager) {
        descriptorsManager.addItem(JavaeeAppDescriptor.class, GeronimoAppRoot.class, "geronimo-application");
        descriptorsManager.addItem(JavaeeEjbDescriptor.class, GeronimoEjbRoot.class, "openejb-jar");
        descriptorsManager.addItem(JavaeeWebDescriptor.class, GeronimoWebRoot.class, "geronimo-web");
    }

    @Nullable
    @NonNls
    public String getNameFromTemplate(String template) throws Exception {
        return template.replaceAll(PATTERN, "$1");
    }

    @Nullable
    @NonNls
    public String getVersionFromTemplate(String template) throws Exception {
        return template.replaceAll(PATTERN, "$2");
    }

    @NotNull
    public String getServerVersion(JavaeePersistentData persistentData) throws Exception {
        String string = GeronimoServerVersionConfig.get(persistentData);
        if (string == null) {
            GeronimoIntegration.$$$reportNull$$$0(3);
        }
        return string;
    }

    public DeploymentProvider getDeploymentProvider(boolean local) {
        if (!local) {
            return new JavaeeDeploymentProvider(true);
        }
        return super.getDeploymentProvider(local);
    }

    protected void checkValidServerHome(String home, String version) throws Exception {
    }

    protected void addLibraryLocations(String home, List<File> locations) {
        locations.add(new File(home, "repository"));
    }

    @Nullable
    public String getContextRoot(JavaeeFacet facet) {
        GeronimoWebRoot web = GeronimoUtil.getWebRoot(facet);
        return web != null ? (String)web.getContextRoot().getValue() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/javaee/oss/geronimo/server/GeronimoIntegration";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getBigIcon";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getServerVersion";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

