/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.geronimo.editor;

import com.intellij.javaee.model.enums.PersistenceType;
import com.intellij.javaee.model.xml.ejb.EntityBean;
import com.intellij.javaee.model.xml.ejb.MessageDrivenBean;
import com.intellij.javaee.model.xml.ejb.SessionBean;
import com.intellij.javaee.oss.geronimo.model.GeronimoEjbRoot;
import com.intellij.javaee.oss.geronimo.model.GeronimoEntityBean;
import com.intellij.javaee.oss.geronimo.model.GeronimoMessageBean;
import com.intellij.javaee.oss.geronimo.model.GeronimoSessionBean;
import com.intellij.util.containers.ContainerUtil;
import org.jetbrains.annotations.Nullable;

class GeronimoEjbUtil {
    private GeronimoEjbUtil() {
    }

    @Nullable
    static GeronimoEntityBean findEntityBean(GeronimoEjbRoot root, EntityBean source) {
        if (root == null || source == null) {
            return null;
        }
        return (GeronimoEntityBean)ContainerUtil.find(root.getEnterpriseBeans().getEntityBeans(), target -> source.equals(target.getEjbName().getValue()));
    }

    @Nullable
    static GeronimoSessionBean findSessionBean(GeronimoEjbRoot root, SessionBean source) {
        if (root == null || source == null) {
            return null;
        }
        return (GeronimoSessionBean)ContainerUtil.find(root.getEnterpriseBeans().getSessionBeans(), target -> source.equals(target.getEjbName().getValue()));
    }

    @Nullable
    static GeronimoMessageBean findMessageBean(GeronimoEjbRoot root, MessageDrivenBean source) {
        if (root == null || source == null) {
            return null;
        }
        return (GeronimoMessageBean)ContainerUtil.find(root.getEnterpriseBeans().getMessageBeans(), target -> source.equals(target.getEjbName().getValue()));
    }

    static boolean isCmpBean(EntityBean bean) {
        return bean != null && bean.getPersistenceType().getValue() == PersistenceType.CONTAINER;
    }
}

