/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.rest.view;

import com.intellij.codeInsight.documentation.DocumentationComponent;
import com.intellij.codeInsight.documentation.DocumentationManager;
import com.intellij.icons.AllIcons;
import com.intellij.jam.JamElement;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CheckedActionGroup;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.ui.FinderRecursivePanel;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ws.rest.RSProjectComponent;
import com.intellij.ws.rest.model.jam.RSHttpMethod;
import com.intellij.ws.rest.model.jam.RSJamModel;
import com.intellij.ws.rest.model.jam.RSJamPsiClassPath;
import com.intellij.ws.rest.model.jam.httpMethods.RSDeleteMethod;
import com.intellij.ws.rest.model.jam.httpMethods.RSGetMethod;
import com.intellij.ws.rest.model.jam.httpMethods.RSPostMethod;
import com.intellij.ws.rest.model.jam.httpMethods.RSPutMethod;
import com.intellij.ws.rest.utils.RSUtils;
import com.intellij.ws.rest.view.RSHttpMethodFinderRecursivePanel;
import com.intellij.ws.rest.view.actions.CheckResourceTypeAction;
import com.intellij.ws.rest.view.actions.ShowAllResourcesAction;
import com.intellij.ws.rest.view.actions.ShowResourcesAction;
import icons.RSIcons;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RSViewFinderRecursivePanel
extends FinderRecursivePanel<JamElement> {
    private final Module myModule;
    private final DefaultActionGroup myActions;
    private AnAction myShowResourcesAction;
    private AnAction myShowAllResourcesAction;
    private DefaultActionGroup myCheckGroupAction;

    public RSViewFinderRecursivePanel(@NotNull FinderRecursivePanel parent, @Nullable Module module, DefaultActionGroup actions) {
        if (parent == null) {
            RSViewFinderRecursivePanel.$$$reportNull$$$0(0);
        }
        super(parent);
        this.myModule = module;
        this.myActions = actions;
        this.initAdditionalActions(actions);
    }

    private void initAdditionalActions(DefaultActionGroup actions) {
        this.myShowResourcesAction = new ShowResourcesAction(this);
        this.myShowAllResourcesAction = new ShowAllResourcesAction(this);
        this.myCheckGroupAction = new MyCheckedActionGroup(new ToggleAction[0]);
        actions.add(this.myShowAllResourcesAction);
        actions.add(this.myShowResourcesAction);
        actions.add((AnAction)this.myCheckGroupAction);
        this.myCheckGroupAction.add((AnAction)new CheckResourceTypeAction.Get(this));
        this.myCheckGroupAction.add((AnAction)new CheckResourceTypeAction.Post(this));
        this.myCheckGroupAction.add((AnAction)new CheckResourceTypeAction.Put(this));
        this.myCheckGroupAction.add((AnAction)new CheckResourceTypeAction.Delete(this));
    }

    @Nullable
    protected JComponent createRightComponent(JamElement jamElement) {
        RSJamPsiClassPath path;
        if (jamElement instanceof RSJamPsiClassPath && this.hasChildren(path = (RSJamPsiClassPath)jamElement)) {
            return new RSHttpMethodFinderRecursivePanel(this, path);
        }
        PsiElement element = RSViewFinderRecursivePanel.getPsiElement(jamElement);
        if (element != null) {
            DocumentationManager manager = DocumentationManager.getInstance((Project)this.getProject());
            DocumentationComponent component = new DocumentationComponent(manager);
            manager.fetchDocInfo(element, component);
            Disposer.register((Disposable)this, (Disposable)component);
            return component;
        }
        return super.createRightComponent((Object)jamElement);
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        JamElement jamElement = (JamElement)this.getSelectedValue();
        PsiElement element = RSViewFinderRecursivePanel.getPsiElement(jamElement);
        if (CommonDataKeys.NAVIGATABLE.is(dataId) && element != null) {
            return element;
        }
        return super.getData(dataId);
    }

    @Nullable
    private static PsiElement getPsiElement(JamElement jamElement) {
        if (jamElement instanceof RSJamPsiClassPath) {
            return ((RSJamPsiClassPath)jamElement).getPsiElement();
        }
        if (jamElement instanceof RSHttpMethod) {
            return ((RSHttpMethod)jamElement).getPsiElement();
        }
        return null;
    }

    @NotNull
    protected String getItemText(JamElement jamElement) {
        if (jamElement instanceof RSJamPsiClassPath && ((RSJamPsiClassPath)jamElement).isPsiValid()) {
            String string = ((RSJamPsiClassPath)jamElement).getPsiElement().getQualifiedName();
            if (string == null) {
                RSViewFinderRecursivePanel.$$$reportNull$$$0(1);
            }
            return string;
        }
        if (jamElement instanceof RSHttpMethod) {
            RSHttpMethod method = (RSHttpMethod)jamElement;
            String resourceValue = RSUtils.getResourcePath(method);
            String signature = RSHttpMethodFinderRecursivePanel.getMethodSignature(method);
            String string = resourceValue + " @" + method.getShortAnnoName() + " (" + signature + ")";
            if (string == null) {
                RSViewFinderRecursivePanel.$$$reportNull$$$0(2);
            }
            return string;
        }
        if ("" == null) {
            RSViewFinderRecursivePanel.$$$reportNull$$$0(3);
        }
        return "";
    }

    protected void doCustomizeCellRenderer(SimpleColoredComponent comp, JList list, JamElement value, int index, boolean selected, boolean hasFocus) {
        if (value instanceof RSJamPsiClassPath) {
            this.customizeRSJamPsiClassPath(comp, (RSJamPsiClassPath)value);
        } else if (value instanceof RSHttpMethod) {
            this.customizeRSHttpMethod(comp, (RSHttpMethod)value);
        }
    }

    private void customizeRSJamPsiClassPath(SimpleColoredComponent comp, RSJamPsiClassPath value) {
        comp.clear();
        comp.setIcon(this.getItemIcon(value));
        String resourceValue = value.getResourceValue();
        resourceValue = StringUtil.isEmptyOrSpaces((String)resourceValue) ? "\"/\"" : "\"" + resourceValue + "\"";
        String className = value.getPsiElement().getName();
        if (this.isShowResourcesView()) {
            comp.append(resourceValue);
            comp.append(" (" + className + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
        } else {
            comp.append(className);
            comp.append(" (" + resourceValue + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
    }

    private void customizeRSHttpMethod(SimpleColoredComponent comp, RSHttpMethod method) {
        comp.clear();
        comp.setIcon(this.getItemIcon(method));
        String resourceValue = RSUtils.getResourcePath(method);
        String signature = RSHttpMethodFinderRecursivePanel.getMethodSignature(method);
        if (this.isShowResourcesView()) {
            comp.append(resourceValue);
            comp.append(" @" + method.getShortAnnoName() + " ", SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES);
            comp.append(" (" + signature + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
        } else {
            comp.append(signature);
            comp.append(" @" + method.getShortAnnoName() + " ", SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES);
            comp.append(" (" + resourceValue + ")", SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
    }

    @Nullable
    protected Icon getItemIcon(JamElement path) {
        return RSIcons.WebServicesClass;
    }

    public void dispose() {
        super.dispose();
        this.myActions.remove(this.myShowResourcesAction);
        this.myActions.remove(this.myShowAllResourcesAction);
        this.myActions.remove((AnAction)this.myCheckGroupAction);
    }

    @NotNull
    protected List<JamElement> getListItems() {
        if (this.isShowAllResources()) {
            List<JamElement> list = this.getAllResourcesModel();
            if (list == null) {
                RSViewFinderRecursivePanel.$$$reportNull$$$0(4);
            }
            return list;
        }
        List<JamElement> list = this.getRSJamPsiClassPathModel();
        if (list == null) {
            RSViewFinderRecursivePanel.$$$reportNull$$$0(5);
        }
        return list;
    }

    private List<JamElement> getRSJamPsiClassPathModel() {
        ArrayList<JamElement> items = new ArrayList<JamElement>();
        RSJamModel model = RSJamModel.getModel(this.getProject());
        List<RSJamPsiClassPath> paths = this.myModule != null ? model.getPsiClassPaths(this.myModule) : model.getPsiClassPaths(this.getProject());
        Collections.sort(paths, (o1, o2) -> {
            String value1 = o1.getResourceValue();
            String value2 = o2.getResourceValue();
            if (value1 != null && value2 != null) {
                return value1.compareTo(value2);
            }
            return 0;
        });
        for (JamElement jamElement : paths) {
            items.add(jamElement);
        }
        return items;
    }

    private List<JamElement> getAllResourcesModel() {
        ArrayList<JamElement> items = new ArrayList<JamElement>();
        ArrayList<RSHttpMethod> methods = new ArrayList<RSHttpMethod>();
        RSJamModel jamModel = RSJamModel.getModel(this.getProject());
        List<RSJamPsiClassPath> paths = this.myModule == null ? jamModel.getPsiClassPaths(this.getProject()) : jamModel.getPsiClassPaths(this.myModule);
        for (RSJamPsiClassPath path : paths) {
            List<RSHttpMethod> httpMethods = jamModel.getHttpMethods(path.getPsiElement());
            for (RSHttpMethod httpMethod : RSViewFinderRecursivePanel.getFilteredMethods(httpMethods, this.getProject())) {
                methods.add(httpMethod);
            }
        }
        Collections.sort(methods, (o1, o2) -> {
            if (this.isShowResourcesView()) {
                return RSUtils.getResourcePath(o1).compareTo(RSUtils.getResourcePath(o2));
            }
            return o1.getPsiElement().getName().compareTo(o2.getPsiElement().getName());
        });
        for (RSHttpMethod method : methods) {
            items.add(method);
        }
        return items;
    }

    @NotNull
    public static List<RSHttpMethod> getFilteredMethods(@NotNull List<RSHttpMethod> httpMethods, @NotNull Project project) {
        RSProjectComponent.Settings settings;
        if (httpMethods == null) {
            RSViewFinderRecursivePanel.$$$reportNull$$$0(6);
        }
        if (project == null) {
            RSViewFinderRecursivePanel.$$$reportNull$$$0(7);
        }
        if ((settings = RSProjectComponent.getInstance(project).getState()) == null) {
            List<RSHttpMethod> list = httpMethods;
            if (list == null) {
                RSViewFinderRecursivePanel.$$$reportNull$$$0(8);
            }
            return list;
        }
        ArrayList<RSHttpMethod> filtered = new ArrayList<RSHttpMethod>();
        for (RSHttpMethod method : httpMethods) {
            if (!(method instanceof RSGetMethod && settings.isShowGetResources() || method instanceof RSPutMethod && settings.isShowPutResources() || method instanceof RSPostMethod && settings.isShowPostResources()) && (!(method instanceof RSDeleteMethod) || !settings.isShowDeleteResources())) continue;
            filtered.add(method);
        }
        ArrayList<RSHttpMethod> arrayList = filtered;
        if (arrayList == null) {
            RSViewFinderRecursivePanel.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    protected boolean hasChildren(JamElement jamElement) {
        if (jamElement instanceof RSJamPsiClassPath) {
            List<RSHttpMethod> allMethods = RSJamModel.getModel(this.getProject()).getHttpMethods(((RSJamPsiClassPath)jamElement).getPsiElement());
            return RSViewFinderRecursivePanel.getFilteredMethods(allMethods, this.getProject()).size() > 0;
        }
        return false;
    }

    public Module getModule() {
        return this.myModule;
    }

    public boolean isShowAllResources() {
        RSProjectComponent.Settings state = RSProjectComponent.getInstance(this.getProject()).getState();
        return state == null || state.isShowAllResources();
    }

    public boolean isShowResourcesView() {
        RSProjectComponent.Settings state = RSProjectComponent.getInstance(this.getProject()).getState();
        return state == null || state.isShowResourcesView();
    }

    public boolean isShowGet() {
        RSProjectComponent.Settings state = RSProjectComponent.getInstance(this.getProject()).getState();
        return state == null || state.isShowGetResources();
    }

    public boolean isShowPut() {
        RSProjectComponent.Settings state = RSProjectComponent.getInstance(this.getProject()).getState();
        return state == null || state.isShowPutResources();
    }

    public boolean isShowPost() {
        RSProjectComponent.Settings state = RSProjectComponent.getInstance(this.getProject()).getState();
        return state == null || state.isShowPostResources();
    }

    public boolean isShowDelete() {
        RSProjectComponent.Settings state = RSProjectComponent.getInstance(this.getProject()).getState();
        return state == null || state.isShowDeleteResources();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/rest/view/RSViewFinderRecursivePanel";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "httpMethods";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/rest/view/RSViewFinderRecursivePanel";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getItemText";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getListItems";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilteredMethods";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getFilteredMethods";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyCheckedActionGroup
    extends DefaultActionGroup
    implements CheckedActionGroup {
        public MyCheckedActionGroup(ToggleAction ... actions) {
            super((AnAction[])actions);
            this.setPopup(true);
            this.getTemplatePresentation().setText("Check Resource Type");
            this.getTemplatePresentation().setIcon(AllIcons.Nodes.Annotationtype);
        }
    }
}

