/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.rest.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.ws.rest.RSBundle;
import com.intellij.ws.rest.inspections.AbstractRestJavaInspection;
import com.intellij.ws.utils.WsPsiUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class RestWrongDefaultValueInspection
extends AbstractRestJavaInspection {
    @Override
    protected void checkMethod(@NotNull PsiMethod psiMethod, @NotNull ProblemsHolder holder, @NotNull Module module) {
        PsiParameter[] parameters;
        if (psiMethod == null) {
            RestWrongDefaultValueInspection.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            RestWrongDefaultValueInspection.$$$reportNull$$$0(1);
        }
        if (module == null) {
            RestWrongDefaultValueInspection.$$$reportNull$$$0(2);
        }
        for (PsiParameter parameter : parameters = psiMethod.getParameterList().getParameters()) {
            RestWrongDefaultValueInspection.check((PsiVariable)parameter, holder);
        }
    }

    @Override
    protected void checkFields(@NotNull PsiField field, @NotNull ProblemsHolder holder, @NotNull Module module) {
        if (field == null) {
            RestWrongDefaultValueInspection.$$$reportNull$$$0(3);
        }
        if (holder == null) {
            RestWrongDefaultValueInspection.$$$reportNull$$$0(4);
        }
        if (module == null) {
            RestWrongDefaultValueInspection.$$$reportNull$$$0(5);
        }
        RestWrongDefaultValueInspection.check((PsiVariable)field, holder);
    }

    private static void check(PsiVariable variable, ProblemsHolder problems) {
        if (variable.getType() instanceof PsiPrimitiveType) {
            PsiAnnotation anno;
            PsiPrimitiveType type = (PsiPrimitiveType)variable.getType();
            PsiModifierList modifierList = variable.getModifierList();
            if (modifierList != null && (anno = modifierList.findAnnotation("javax.ws.rs.DefaultValue")) != null) {
                String value = WsPsiUtil.getAnnotationValue((PsiAnnotation)anno);
                PsiAnnotationMemberValue problemElement = anno.findAttributeValue("value");
                if (value != null && problemElement != null && !RestWrongDefaultValueInspection.canConvert(value, type)) {
                    problems.registerProblem((PsiElement)problemElement, RSBundle.message("cant.convert.to", type.getPresentableText()), ProblemHighlightType.ERROR, new LocalQuickFix[0]);
                }
            }
        }
    }

    private static boolean canConvert(String s, PsiPrimitiveType type) {
        try {
            if (PsiPrimitiveType.BOOLEAN.equals((Object)type)) {
                return s.equals("true") || s.equals("false");
            }
            if (PsiType.BYTE.equals((Object)type)) {
                Byte.parseByte(s);
            } else if (PsiPrimitiveType.SHORT.equals((Object)type)) {
                Short.parseShort(s);
            } else if (PsiPrimitiveType.INT.equals((Object)type)) {
                Integer.parseInt(s);
            } else if (PsiPrimitiveType.LONG.equals((Object)type)) {
                Long.parseLong(s);
            } else if (PsiPrimitiveType.DOUBLE.equals((Object)type)) {
                Double.parseDouble(s);
            } else if (PsiPrimitiveType.FLOAT.equals((Object)type)) {
                Float.parseFloat(s);
            }
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("@DefaultValue issues" == null) {
            RestWrongDefaultValueInspection.$$$reportNull$$$0(6);
        }
        return "@DefaultValue issues";
    }

    @NotNull
    public String getShortName() {
        String string = ((Object)((Object)this)).getClass().getSimpleName();
        if (string == null) {
            RestWrongDefaultValueInspection.$$$reportNull$$$0(7);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "field";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/rest/inspections/RestWrongDefaultValueInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/rest/inspections/RestWrongDefaultValueInspection";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkMethod";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkFields";
                break;
            }
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

