/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.rest.inspections;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.ws.rest.RSBundle;
import com.intellij.ws.rest.inspections.AbstractRestJavaInspection;
import java.util.Arrays;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RestParamTypeInspection
extends AbstractRestJavaInspection {
    private static Collection<String> PARAM_ANNOTATIONS = Arrays.asList("javax.ws.rs.PathParam", "javax.ws.rs.QueryParam", "javax.ws.rs.MatrixParam", "javax.ws.rs.HeaderParam", "javax.ws.rs.FormParam", "javax.ws.rs.CookieParam");

    @Override
    protected void checkMethod(@NotNull PsiMethod psiMethod, @NotNull ProblemsHolder holder, @NotNull Module module) {
        if (psiMethod == null) {
            RestParamTypeInspection.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            RestParamTypeInspection.$$$reportNull$$$0(1);
        }
        if (module == null) {
            RestParamTypeInspection.$$$reportNull$$$0(2);
        }
        for (PsiParameter parameter : psiMethod.getParameterList().getParameters()) {
            PsiIdentifier nameIdentifier;
            PsiType parameterType;
            PsiAnnotation psiAnnotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)parameter, PARAM_ANNOTATIONS);
            if (psiAnnotation == null || RestParamTypeInspection.acceptSimpleType(parameterType = parameter.getType()) || RestParamTypeInspection.acceptCollectionType(parameterType) || RestParamTypeInspection.acceptOptionalType(parameterType) || "javax.ws.rs.PathParam".equals(psiAnnotation.getQualifiedName()) && RestParamTypeInspection.acceptPathSegmentType(parameterType) || "javax.ws.rs.CookieParam".equals(psiAnnotation.getQualifiedName()) && RestParamTypeInspection.acceptCookieType(parameterType) || (nameIdentifier = parameter.getNameIdentifier()) == null) continue;
            holder.registerProblem((PsiElement)nameIdentifier, RSBundle.message("RestParamTypeInspection.incorrect.parameter.type", new Object[0]), ProblemHighlightType.ERROR, new LocalQuickFix[0]);
        }
    }

    private static boolean acceptPathSegmentType(PsiType parameterType) {
        PsiClass psiClass;
        if (parameterType instanceof PsiClassType && (psiClass = ((PsiClassType)parameterType).resolve()) != null) {
            if (InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"javax.ws.rs.core.PathSegment")) {
                return true;
            }
            PsiType itType = PsiUtil.substituteTypeParameter((PsiType)parameterType, (String)"java.util.Collection", (int)0, (boolean)false);
            return itType != null && RestParamTypeInspection.acceptPathSegmentType(itType);
        }
        return false;
    }

    private static boolean acceptCookieType(PsiType parameterType) {
        PsiClass psiClass;
        if (parameterType instanceof PsiClassType && (psiClass = ((PsiClassType)parameterType).resolve()) != null) {
            return InheritanceUtil.isInheritor((PsiClass)psiClass, (String)"javax.ws.rs.core.Cookie");
        }
        return false;
    }

    private static boolean acceptCollectionType(@NotNull PsiType parameterType) {
        if (parameterType == null) {
            RestParamTypeInspection.$$$reportNull$$$0(3);
        }
        if (parameterType instanceof PsiClassType) {
            PsiType itType = PsiUtil.substituteTypeParameter((PsiType)parameterType, (String)"java.util.Collection", (int)0, (boolean)false);
            return itType != null && RestParamTypeInspection.acceptSimpleType(itType);
        }
        return false;
    }

    private static boolean acceptOptionalType(@NotNull PsiType parameterType) {
        if (parameterType == null) {
            RestParamTypeInspection.$$$reportNull$$$0(4);
        }
        if (parameterType instanceof PsiClassType) {
            PsiType optionalType = PsiUtil.substituteTypeParameter((PsiType)parameterType, (String)"java.util.Optional", (int)0, (boolean)false);
            return optionalType != null && RestParamTypeInspection.acceptSimpleType(optionalType);
        }
        return false;
    }

    private static boolean acceptSimpleType(@NotNull PsiType parameterType) {
        PsiClass psiClass;
        if (parameterType == null) {
            RestParamTypeInspection.$$$reportNull$$$0(5);
        }
        if (PsiType.CHAR.equals((Object)parameterType) || "java.lang.Character".equals(parameterType.getCanonicalText())) {
            return false;
        }
        if (parameterType instanceof PsiPrimitiveType) {
            return true;
        }
        if (PsiPrimitiveType.getUnboxedType((PsiType)parameterType) != null) {
            return true;
        }
        if (parameterType instanceof PsiClassType && (psiClass = ((PsiClassType)parameterType).resolve()) != null) {
            if (psiClass.isEnum()) {
                return true;
            }
            if (RestParamTypeInspection.hasSingleStringConstructor(psiClass)) {
                return true;
            }
            if (RestParamTypeInspection.hasStaticMethod(psiClass, "valueOf")) {
                return true;
            }
            if (RestParamTypeInspection.hasStaticMethod(psiClass, "fromString")) {
                return true;
            }
        }
        return false;
    }

    private static boolean hasStaticMethod(@NotNull PsiClass psiClass, String methodName) {
        PsiMethod valueOf;
        if (psiClass == null) {
            RestParamTypeInspection.$$$reportNull$$$0(6);
        }
        return (valueOf = RestParamTypeInspection.getSingleStringParameterMethod(psiClass.findMethodsByName(methodName, true))) != null && valueOf.getModifierList().hasModifierProperty("static");
    }

    private static boolean hasSingleStringConstructor(PsiClass psiClass) {
        return RestParamTypeInspection.getSingleStringParameterMethod(psiClass.getConstructors()) != null;
    }

    @Nullable
    private static PsiMethod getSingleStringParameterMethod(PsiMethod[] methods) {
        for (PsiMethod method : methods) {
            PsiParameter[] parameters = method.getParameterList().getParameters();
            if (parameters.length != 1 || !"java.lang.String".equals(parameters[0].getType().getCanonicalText())) continue;
            return method;
        }
        return null;
    }

    @NotNull
    public String getDisplayName() {
        String string = RSBundle.message("RestParamTypeInspection.display.name", new Object[0]);
        if (string == null) {
            RestParamTypeInspection.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("RestParamTypeInspection" == null) {
            RestParamTypeInspection.$$$reportNull$$$0(8);
        }
        return "RestParamTypeInspection";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethod";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/rest/inspections/RestParamTypeInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/rest/inspections/RestParamTypeInspection";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkMethod";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "acceptCollectionType";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "acceptOptionalType";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "acceptSimpleType";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "hasStaticMethod";
                break;
            }
            case 7: 
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

