/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.quirksmode;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.patterns.ElementPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlTag;
import com.jetbrains.quirksmode.Browser;
import com.jetbrains.quirksmode.BrowserFamily;
import com.jetbrains.quirksmode.BrowserSet;
import com.jetbrains.quirksmode.ProblemDetector;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class ProblemDetectorImpl
implements ProblemDetector {
    private String myId;
    private String myUrl;
    private ElementPattern myPattern;
    private BrowserSet myBrowserSet;
    private Pair<BrowserSet, String>[] myMessages;

    public ProblemDetectorImpl(@NotNull @NonNls String id, @NotNull ElementPattern pattern, @NotNull @NonNls String url, Pair<BrowserSet, String> ... messages) {
        if (id == null) {
            ProblemDetectorImpl.$$$reportNull$$$0(0);
        }
        if (pattern == null) {
            ProblemDetectorImpl.$$$reportNull$$$0(1);
        }
        if (url == null) {
            ProblemDetectorImpl.$$$reportNull$$$0(2);
        }
        if (messages == null) {
            ProblemDetectorImpl.$$$reportNull$$$0(3);
        }
        this.myId = id;
        this.myUrl = url;
        this.myPattern = pattern;
        BrowserSet browserSet = new BrowserSet(new Browser[0]);
        for (Pair<BrowserSet, String> each : messages) {
            browserSet = browserSet.and((BrowserSet)each.first);
        }
        this.myBrowserSet = browserSet;
        this.myMessages = messages;
    }

    public ProblemDetectorImpl(@NotNull @NonNls String id, @NotNull ElementPattern pattern, @NotNull String message, @NotNull String url, @NotNull BrowserFamily family) {
        if (id == null) {
            ProblemDetectorImpl.$$$reportNull$$$0(4);
        }
        if (pattern == null) {
            ProblemDetectorImpl.$$$reportNull$$$0(5);
        }
        if (message == null) {
            ProblemDetectorImpl.$$$reportNull$$$0(6);
        }
        if (url == null) {
            ProblemDetectorImpl.$$$reportNull$$$0(7);
        }
        if (family == null) {
            ProblemDetectorImpl.$$$reportNull$$$0(8);
        }
        this(id, pattern, url, Pair.create((Object)new BrowserSet(family), (Object)message));
    }

    public ProblemDetectorImpl(@NotNull @NonNls String id, @NotNull ElementPattern pattern, @NotNull String message, @NotNull String url, @NotNull Browser browser) {
        if (id == null) {
            ProblemDetectorImpl.$$$reportNull$$$0(9);
        }
        if (pattern == null) {
            ProblemDetectorImpl.$$$reportNull$$$0(10);
        }
        if (message == null) {
            ProblemDetectorImpl.$$$reportNull$$$0(11);
        }
        if (url == null) {
            ProblemDetectorImpl.$$$reportNull$$$0(12);
        }
        if (browser == null) {
            ProblemDetectorImpl.$$$reportNull$$$0(13);
        }
        this(id, pattern, url, Pair.create((Object)new BrowserSet(browser), (Object)message));
    }

    public ProblemDetectorImpl(@NotNull @NonNls String id, @NotNull ElementPattern pattern, @NotNull String message, @NotNull String url, @NotNull BrowserSet browserSet) {
        if (id == null) {
            ProblemDetectorImpl.$$$reportNull$$$0(14);
        }
        if (pattern == null) {
            ProblemDetectorImpl.$$$reportNull$$$0(15);
        }
        if (message == null) {
            ProblemDetectorImpl.$$$reportNull$$$0(16);
        }
        if (url == null) {
            ProblemDetectorImpl.$$$reportNull$$$0(17);
        }
        if (browserSet == null) {
            ProblemDetectorImpl.$$$reportNull$$$0(18);
        }
        this(id, pattern, url, Pair.create((Object)browserSet, (Object)message));
    }

    public String getId() {
        return this.myId;
    }

    @Override
    public ElementPattern getPattern() {
        return this.myPattern;
    }

    @Override
    public void createDescriptors(@NotNull PsiElement element, @NotNull ProblemsHolder holder, @NotNull BrowserSet browserSet, boolean isOnTheFly) {
        if (element == null) {
            ProblemDetectorImpl.$$$reportNull$$$0(19);
        }
        if (holder == null) {
            ProblemDetectorImpl.$$$reportNull$$$0(20);
        }
        if (browserSet == null) {
            ProblemDetectorImpl.$$$reportNull$$$0(21);
        }
        StringBuilder text = new StringBuilder("<html><body>");
        for (Pair<BrowserSet, String> pair : this.myMessages) {
            BrowserSet set = (BrowserSet)pair.first;
            if (!set.intersects(browserSet)) continue;
            String message = (String)pair.second;
            text.append(set).append(" compatibility problem#treeend #loc<blockquote>").append(message).append("</blockquote>\n");
        }
        text.append("<blockquote>Report: <a href=\"").append(this.myUrl).append("\">").append("[").append(this.getId()).append("]</a></blockquote></body></html>");
        if (element instanceof XmlTag) {
            ASTNode node = element.getNode();
            if (node != null) {
                TextRange highlightRange;
                ASTNode startTagName = XmlChildRole.START_TAG_NAME_FINDER.findChild(node);
                ASTNode endTagName = XmlChildRole.CLOSING_TAG_NAME_FINDER.findChild(node);
                if (startTagName != null) {
                    int offsetInParent = startTagName.getPsi().getStartOffsetInParent();
                    highlightRange = new TextRange(offsetInParent, offsetInParent + startTagName.getTextLength());
                    holder.registerProblem(element, highlightRange, text.toString(), new LocalQuickFix[0]);
                }
                if (endTagName != null) {
                    int offsetInParent = endTagName.getPsi().getStartOffsetInParent();
                    highlightRange = new TextRange(offsetInParent, offsetInParent + endTagName.getTextLength());
                    holder.registerProblem(element, highlightRange, text.toString(), new LocalQuickFix[0]);
                }
            }
        } else {
            holder.registerProblem(element, text.toString(), new LocalQuickFix[0]);
        }
    }

    @Override
    public boolean isActive(@NotNull BrowserSet browserSet) {
        if (browserSet == null) {
            ProblemDetectorImpl.$$$reportNull$$$0(22);
        }
        return this.myBrowserSet.intersects(browserSet);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 1: 
            case 5: 
            case 10: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 2: 
            case 7: 
            case 12: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messages";
                break;
            }
            case 6: 
            case 11: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "family";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "browser";
                break;
            }
            case 18: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "browserSet";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/quirksmode/ProblemDetectorImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[2] = "createDescriptors";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[2] = "isActive";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

