/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.quirksmode;

import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.InitialPatternCondition;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.StandardPatterns;
import com.intellij.patterns.XmlTagPattern;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ProcessingContext;
import com.jetbrains.quirksmode.CssHtmlPatternUtil;
import com.jetbrains.quirksmode.CssPatterns;
import com.jetbrains.quirksmode.HtmlPatterns;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HtmlTagPattern
extends XmlTagPattern<HtmlTagPattern> {
    private static final InitialPatternCondition<XmlTag> CONDITION = new InitialPatternCondition<XmlTag>(XmlTag.class){

        public boolean accepts(@Nullable Object o, ProcessingContext context) {
            return o instanceof XmlTag;
        }
    };

    public HtmlTagPattern() {
        super(CONDITION);
    }

    public HtmlTagPattern withStyle(@NotNull @NonNls String propertyName, String ... values) {
        if (propertyName == null) {
            HtmlTagPattern.$$$reportNull$$$0(0);
        }
        if (values == null) {
            HtmlTagPattern.$$$reportNull$$$0(1);
        }
        return this.withCssDeclarations((ElementPattern)StandardPatterns.collection(CssDeclaration.class).atLeastOne((ElementPattern)CssPatterns.cssDeclaration().withPropertyName(propertyName).withValue(values)));
    }

    public HtmlTagPattern withStyle(@NotNull @NonNls String propertyName) {
        if (propertyName == null) {
            HtmlTagPattern.$$$reportNull$$$0(2);
        }
        return this.withCssDeclarations((ElementPattern)StandardPatterns.collection(CssDeclaration.class).atLeastOne((ElementPattern)CssPatterns.cssDeclaration().withPropertyName(propertyName)));
    }

    public HtmlTagPattern withNonZeroStyle(@NotNull @NonNls String propertyName) {
        if (propertyName == null) {
            HtmlTagPattern.$$$reportNull$$$0(3);
        }
        return this.withCssDeclarations((ElementPattern)StandardPatterns.collection(CssDeclaration.class).atLeastOne((ElementPattern)CssPatterns.cssDeclaration().withPropertyName(propertyName).withNonZeroLength(propertyName)));
    }

    public HtmlTagPattern withStyle(@NotNull @NonNls String propertyName, @NotNull ElementPattern pattern) {
        if (propertyName == null) {
            HtmlTagPattern.$$$reportNull$$$0(4);
        }
        if (pattern == null) {
            HtmlTagPattern.$$$reportNull$$$0(5);
        }
        return this.withCssDeclarations((ElementPattern)StandardPatterns.collection(CssDeclaration.class).atLeastOne((ElementPattern)CssPatterns.cssDeclaration().withPropertyName(propertyName).withValue(pattern)));
    }

    public HtmlTagPattern withoutStyle(@NotNull @NonNls String propertyName, @NotNull String propertyValue) {
        if (propertyName == null) {
            HtmlTagPattern.$$$reportNull$$$0(6);
        }
        if (propertyValue == null) {
            HtmlTagPattern.$$$reportNull$$$0(7);
        }
        return (HtmlTagPattern)this.and((ElementPattern)StandardPatterns.not((ElementPattern)this.withStyle(propertyName, propertyValue)));
    }

    public HtmlTagPattern withCssDeclarations(final @NotNull ElementPattern declarationPattern) {
        if (declarationPattern == null) {
            HtmlTagPattern.$$$reportNull$$$0(8);
        }
        return (HtmlTagPattern)this.with((PatternCondition)new PatternCondition<XmlTag>("withCssDeclarations"){

            public boolean accepts(@NotNull XmlTag xmlTag, ProcessingContext context) {
                CssDeclaration[] styles;
                if (xmlTag == null) {
                    2.$$$reportNull$$$0(0);
                }
                List<Object> list = (styles = CssHtmlPatternUtil.getStyles((PsiElement)xmlTag, context.getSharedContext())) != null ? Arrays.asList(styles) : Collections.emptyList();
                return declarationPattern.accepts(list, context);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlTag", "com/jetbrains/quirksmode/HtmlTagPattern$2", "accepts"));
            }
        });
    }

    public HtmlTagPattern withAtLeastOneStyle(String ... propertyName) {
        if (propertyName == null) {
            HtmlTagPattern.$$$reportNull$$$0(9);
        }
        return this.withCssDeclarations((ElementPattern)StandardPatterns.collection(CssDeclaration.class).atLeastOne((ElementPattern)CssPatterns.cssDeclaration().withPropertyName(propertyName)));
    }

    public HtmlTagPattern isBlock() {
        return (HtmlTagPattern)this.with((PatternCondition)new PatternCondition<XmlTag>("isBlock"){

            public boolean accepts(@NotNull XmlTag xmlTag, ProcessingContext context) {
                if (xmlTag == null) {
                    3.$$$reportNull$$$0(0);
                }
                String displayStyle = CssHtmlPatternUtil.getStyle((PsiElement)xmlTag, "display", context.getSharedContext());
                return "block".equals(displayStyle);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlTag", "com/jetbrains/quirksmode/HtmlTagPattern$3", "accepts"));
            }
        });
    }

    public HtmlTagPattern isInline() {
        return (HtmlTagPattern)this.and((ElementPattern)StandardPatterns.not((ElementPattern)this.isBlock()));
    }

    public HtmlTagPattern inQuirksMode() {
        return (HtmlTagPattern)this.inside((ElementPattern)HtmlPatterns.htmlFile().inQuirksMode());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyValue";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declarationPattern";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/quirksmode/HtmlTagPattern";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "withStyle";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "withNonZeroStyle";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "withoutStyle";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "withCssDeclarations";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "withAtLeastOneStyle";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

