/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.quirksmode;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Comparing;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.CssTermList;
import com.intellij.psi.css.CssTermType;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.CssTermTypes;
import com.intellij.psi.css.impl.util.table.CssDescriptorsUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.quirksmode.CssHtmlPatternUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;

public class CssDeclarationPattern
extends PsiElementPattern<CssDeclaration, CssDeclarationPattern> {
    public CssDeclarationPattern() {
        super(CssDeclaration.class);
    }

    public CssDeclarationPattern withPropertyName(final String ... propertyNames) {
        if (propertyNames == null) {
            CssDeclarationPattern.$$$reportNull$$$0(0);
        }
        return (CssDeclarationPattern)this.with((PatternCondition)new PatternCondition<CssDeclaration>("withPropertyName"){

            public boolean accepts(@NotNull CssDeclaration t, ProcessingContext context) {
                if (t == null) {
                    1.$$$reportNull$$$0(0);
                }
                boolean shorthand = t.isShorthandProperty();
                for (String propertyName : propertyNames) {
                    if (!Comparing.equal((String)CssDescriptorsUtil.getCanonicalPropertyName((CssDeclaration)t), (String)propertyName)) continue;
                    return true;
                }
                if (shorthand) {
                    String[] shorthandValues;
                    for (String shorthandValue : shorthandValues = t.expandShorthandProperty()) {
                        for (String propertyName : propertyNames) {
                            if (!Comparing.equal((String)shorthandValue, (String)propertyName)) continue;
                            return true;
                        }
                    }
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/jetbrains/quirksmode/CssDeclarationPattern$1", "accepts"));
            }
        });
    }

    public CssDeclarationPattern withValue(final String ... acceptedValues) {
        return (CssDeclarationPattern)this.with((PatternCondition)new PatternCondition<CssDeclaration>("withValue"){

            public boolean accepts(@NotNull CssDeclaration t, ProcessingContext context) {
                String style;
                if (t == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((style = t.getValue().getText()) == null) {
                    for (String value : acceptedValues) {
                        if (!Comparing.equal((String)value, (String)style)) continue;
                        return true;
                    }
                    return false;
                }
                StringTokenizer st = new StringTokenizer(style);
                while (st.hasMoreTokens()) {
                    String s = st.nextToken();
                    for (int i = 0; i < acceptedValues.length; ++i) {
                        String value = acceptedValues[i];
                        if (!Comparing.equal((String)value, (String)s)) continue;
                        return true;
                    }
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "t", "com/jetbrains/quirksmode/CssDeclarationPattern$2", "accepts"));
            }
        });
    }

    public CssDeclarationPattern withValue(final ElementPattern pattern) {
        return (CssDeclarationPattern)this.with((PatternCondition)new PatternCondition<CssDeclaration>("withValue"){

            public boolean accepts(@NotNull CssDeclaration declaration, ProcessingContext context) {
                if (declaration == null) {
                    3.$$$reportNull$$$0(0);
                }
                return pattern.accepts((Object)declaration.getValue().getText(), context);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "com/jetbrains/quirksmode/CssDeclarationPattern$3", "accepts"));
            }
        });
    }

    public CssDeclarationPattern withAppliedTags(final @NotNull ElementPattern pattern) {
        if (pattern == null) {
            CssDeclarationPattern.$$$reportNull$$$0(1);
        }
        return (CssDeclarationPattern)this.with((PatternCondition)new PatternCondition<CssDeclaration>("withAppliedTags"){

            public boolean accepts(@NotNull CssDeclaration declaration, ProcessingContext context) {
                if (declaration == null) {
                    4.$$$reportNull$$$0(0);
                }
                return pattern.accepts(Arrays.asList(CssHtmlPatternUtil.getAppliedTags(declaration, context.getSharedContext())), context);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "com/jetbrains/quirksmode/CssDeclarationPattern$4", "accepts"));
            }
        });
    }

    public CssDeclarationPattern withNonZeroLength(final String ... propertyNames) {
        if (propertyNames == null) {
            CssDeclarationPattern.$$$reportNull$$$0(2);
        }
        return (CssDeclarationPattern)this.with((PatternCondition)new PatternCondition<CssDeclaration>("withNonZeroLength"){

            public boolean accepts(@NotNull CssDeclaration declaration, ProcessingContext context) {
                CssTermType termType;
                if (declaration == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (declaration.isShorthandProperty()) {
                    String[] properties = declaration.expandShorthandProperty();
                    ArrayList values = new ArrayList();
                    for (String requiredName : propertyNames) {
                        for (String property : properties) {
                            if (!property.equals(requiredName)) continue;
                            Object[] value = declaration.getShorthandValue(property);
                            if (value != null) {
                                ContainerUtil.addAll(values, (Object[])value);
                                continue;
                            }
                            return false;
                        }
                    }
                    return StandardPatterns.collection(String.class).all((ElementPattern)StandardPatterns.string().with((PatternCondition)new PatternCondition<String>("accepts"){

                        public boolean accepts(@NotNull String s, ProcessingContext context) {
                            if (s == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            for (int i = 0; i < s.length(); ++i) {
                                char c = s.charAt(i);
                                if (c != '1' && c != '2' && c != '3' && c != '4' && c != '5' && c != '6' && c != '7' && c != '8' && c != '9') continue;
                                return true;
                            }
                            return false;
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/jetbrains/quirksmode/CssDeclarationPattern$5$1", "accepts"));
                        }
                    })).accepts(values);
                }
                CssTermList value = declaration.getValue();
                CssTerm term = (CssTerm)PsiTreeUtil.getChildOfType((PsiElement)value, CssTerm.class);
                if (term != null && (CssTermTypes.LENGTH == (termType = term.getTermType()) || CssTermTypes.NUMBER == termType || CssTermTypes.NEGATIVE_LENGTH == termType)) {
                    for (PsiElement e : term.getChildren()) {
                        ASTNode node = e.getNode();
                        if (node == null || CssElementTypes.CSS_NUMBER_TERM != node.getElementType()) continue;
                        for (PsiElement e2 : e.getChildren()) {
                            ASTNode node1 = e2.getNode();
                            if (node1 == null || CssElementTypes.CSS_NUMBER != node1.getElementType()) continue;
                            return !"0".equals(node1.getText());
                        }
                    }
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "declaration", "com/jetbrains/quirksmode/CssDeclarationPattern$5", "accepts"));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyNames";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/quirksmode/CssDeclarationPattern";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "withPropertyName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "withAppliedTags";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "withNonZeroLength";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

