/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.settings;

import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lobobrowser.request.UserAgentImpl;
import org.lobobrowser.security.GenericLocalPermission;
import org.lobobrowser.store.StorageManager;

public class GeneralSettings
implements Serializable {
    private static final Logger logger = Logger.getLogger(GeneralSettings.class.getName());
    private static final String DEFAULT_STARTUP = "";
    private static final long serialVersionUID = 22574500070000402L;
    private static final GeneralSettings instance;
    private volatile Collection<String> startupURLs;
    private volatile boolean spoofIE;
    private volatile String ieVersion;
    private volatile String mozVersion;
    private volatile Rectangle initialWindowBounds;

    public static GeneralSettings getInstance() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(GenericLocalPermission.EXT_GENERIC);
        }
        return instance;
    }

    private GeneralSettings() {
        this.restoreDefaults();
    }

    public void save() {
        try {
            this.saveChecked();
        }
        catch (IOException ioe) {
            logger.log(Level.WARNING, "save(): Unable to save settings", ioe);
        }
    }

    public void restoreDefaults() {
        this.startupURLs = Collections.singletonList(DEFAULT_STARTUP);
        this.spoofIE = true;
        this.ieVersion = "9.0";
        this.mozVersion = "32.0";
    }

    public void saveChecked() throws IOException {
        StorageManager.getInstance().saveSettings(this.getClass().getSimpleName(), this);
    }

    public String[] getStartupURLs() {
        Collection<String> urls = this.startupURLs;
        if (urls == null || urls.size() == 0) {
            return new String[]{DEFAULT_STARTUP};
        }
        return urls.toArray(new String[0]);
    }

    public void setStartupURLs(String[] urls) {
        this.startupURLs = Arrays.asList(urls);
    }

    public Rectangle getInitialWindowBounds() {
        Rectangle bounds = this.initialWindowBounds;
        if (bounds == null) {
            return GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds();
        }
        if (bounds.width < 100) {
            bounds.width = 100;
        }
        if (bounds.height < 100) {
            bounds.height = 100;
        }
        return bounds;
    }

    public void setInitialWindowBounds(Rectangle initialWindowBounds) {
        this.initialWindowBounds = initialWindowBounds;
    }

    public String getIeVersion() {
        return this.ieVersion;
    }

    public void setIeVersion(String ieVersion) {
        this.ieVersion = ieVersion;
        UserAgentImpl.getInstance().invalidateUserAgent();
    }

    public boolean isSpoofIE() {
        return this.spoofIE;
    }

    public void setSpoofIE(boolean spoofIE) {
        this.spoofIE = spoofIE;
        UserAgentImpl.getInstance().invalidateUserAgent();
    }

    public String getMozVersion() {
        return this.mozVersion;
    }

    public void setMozVersion(String mozVersion) {
        this.mozVersion = mozVersion;
        UserAgentImpl.getInstance().invalidateUserAgent();
    }

    static {
        GeneralSettings ins = null;
        try {
            ins = (GeneralSettings)StorageManager.getInstance().retrieveSettings(GeneralSettings.class.getSimpleName(), GeneralSettings.class.getClassLoader());
        }
        catch (Exception err) {
            logger.log(Level.WARNING, "getInstance(): Unable to retrieve settings.", err);
        }
        if (ins == null) {
            ins = new GeneralSettings();
        }
        instance = ins;
    }
}

