/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.settings;

import java.io.IOException;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lobobrowser.security.GenericLocalPermission;
import org.lobobrowser.store.CacheManager;
import org.lobobrowser.store.StorageManager;

public class CacheSettings
implements Serializable {
    private static final Logger logger = Logger.getLogger(CacheSettings.class.getName());
    private static final CacheSettings instance;
    private static final long serialVersionUID = 22574500900000604L;
    private int defaultCacheExpirationOffset;

    public static CacheSettings getInstance() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(GenericLocalPermission.EXT_GENERIC);
        }
        return instance;
    }

    public void save() {
        try {
            StorageManager.getInstance().saveSettings(this.getClass().getSimpleName(), this);
        }
        catch (IOException ioe) {
            logger.log(Level.WARNING, "Unable to save settings: " + this.getClass().getSimpleName() + ".", ioe);
        }
    }

    private CacheSettings() {
        this.resetDefaults();
    }

    public void resetDefaults() {
        this.setMaxRAMCacheSize(0x500000);
        this.setDefaultCacheExpirationOffset(60);
    }

    public int getMaxRAMCacheSize() {
        return CacheManager.getInstance().getMaxTransientCacheSize();
    }

    public void setMaxRAMCacheSize(int maxRAMCacheSize) {
        CacheManager.getInstance().setMaxTransientCacheSize(maxRAMCacheSize);
    }

    public int getDefaultCacheExpirationOffset() {
        return this.defaultCacheExpirationOffset;
    }

    public void setDefaultCacheExpirationOffset(int defaultCacheExpirationOffset) {
        this.defaultCacheExpirationOffset = defaultCacheExpirationOffset;
    }

    static {
        CacheSettings ins = null;
        try {
            ins = (CacheSettings)StorageManager.getInstance().retrieveSettings(CacheSettings.class.getSimpleName(), CacheSettings.class.getClassLoader());
        }
        catch (Exception err) {
            logger.log(Level.WARNING, "getInstance(): Unable to retrieve settings.", err);
        }
        if (ins == null) {
            ins = new CacheSettings();
        }
        instance = ins;
    }
}

