/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.settings;

import java.io.IOException;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lobobrowser.security.GenericLocalPermission;
import org.lobobrowser.store.StorageManager;

public class BooleanSettings
implements Serializable {
    private static final Logger logger = Logger.getLogger(BooleanSettings.class.getName());
    private static final BooleanSettings instance;
    private static final long serialVersionUID = 22574500900000604L;
    private boolean httpUseChunkedEncodingPOST;

    private BooleanSettings() {
        this.resetDefaults();
    }

    private void resetDefaults() {
        this.httpUseChunkedEncodingPOST = false;
    }

    public static BooleanSettings getInstance() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(GenericLocalPermission.EXT_GENERIC);
        }
        return instance;
    }

    public void save() {
        try {
            StorageManager.getInstance().saveSettings(this.getClass().getSimpleName(), this);
        }
        catch (IOException ioe) {
            logger.log(Level.WARNING, "Unable to save settings: " + this.getClass().getSimpleName(), ioe);
        }
    }

    public boolean isHttpUseChunkedEncodingPOST() {
        return this.httpUseChunkedEncodingPOST;
    }

    public void setHttpUseChunkedEncodingPOST(boolean httpUseChunkedEncodingPOST) {
        this.httpUseChunkedEncodingPOST = httpUseChunkedEncodingPOST;
    }

    static {
        BooleanSettings ins = null;
        try {
            ins = (BooleanSettings)StorageManager.getInstance().retrieveSettings(BooleanSettings.class.getSimpleName(), BooleanSettings.class.getClassLoader());
        }
        catch (Exception err) {
            logger.log(Level.WARNING, "Unable to retrieve settings.", err);
        }
        if (ins == null) {
            ins = new BooleanSettings();
        }
        instance = ins;
    }
}

