/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.security;

import java.awt.AWTPermission;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.NetPermission;
import java.net.SocketPermission;
import java.net.URL;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.SecurityPermission;
import java.util.Collection;
import java.util.LinkedList;
import java.util.PropertyPermission;
import java.util.logging.LoggingPermission;
import javax.net.ssl.SSLPermission;
import org.lobobrowser.security.GenericLocalPermission;
import org.lobobrowser.security.HistoryPermission;
import org.lobobrowser.security.StoreHostPermission;
import org.lobobrowser.util.Domains;

public class LocalSecurityPolicy
extends Policy {
    public static final File STORE_DIRECTORY;
    private static final String STORE_DIR_NAME = ".lobo";
    private static final String STORE_DIRECTORY_CANONICAL;
    private static final LocalSecurityPolicy instance;
    private static final Collection<Permission> BASE_PRIVILEGE;

    public static void addPrivilegedPermission(Permission permission) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            throw new SecurityException("Call this method before the sercurity manager is set.");
        }
        BASE_PRIVILEGE.add(permission);
    }

    private LocalSecurityPolicy() {
    }

    public static LocalSecurityPolicy getInstance() {
        return instance;
    }

    public static boolean hasHost(URL url) {
        String host = url.getHost();
        return host != null && !"".equals(host);
    }

    public static boolean isLocal(URL url) {
        if (url == null) {
            return false;
        }
        String scheme = url.getProtocol();
        if ("http".equalsIgnoreCase(scheme)) {
            return false;
        }
        if ("file".equalsIgnoreCase(scheme)) {
            if (LocalSecurityPolicy.hasHost(url)) {
                return false;
            }
            final String filePath = url.getPath();
            Boolean result = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    File file = new File(filePath);
                    try {
                        String canonical = file.getCanonicalPath();
                        return !canonical.startsWith(STORE_DIRECTORY_CANONICAL);
                    }
                    catch (IOException ioe) {
                        ioe.printStackTrace(System.err);
                        return false;
                    }
                }
            });
            return result;
        }
        if ("jar".equalsIgnoreCase(scheme)) {
            String path = url.getPath();
            int emIdx = path.lastIndexOf(33);
            String subUrlString = emIdx == -1 ? path : path.substring(0, emIdx);
            try {
                URL subUrl = new URL(subUrlString);
                return LocalSecurityPolicy.isLocal(subUrl);
            }
            catch (MalformedURLException mfu) {
                return false;
            }
        }
        return false;
    }

    @Override
    public PermissionCollection getPermissions(CodeSource codesource) {
        URL location = codesource.getLocation();
        if (location == null) {
            throw new AccessControlException("No location for coodesource=" + codesource);
        }
        boolean isLocal = LocalSecurityPolicy.isLocal(location);
        Permissions permissions = new Permissions();
        if (isLocal) {
            for (Permission p : BASE_PRIVILEGE) {
                permissions.add(p);
            }
            permissions.add(StoreHostPermission.forURL(location));
            permissions.add(new RuntimePermission("com.sun.media.jmc.accessMedia"));
        } else {
            permissions.add(new PropertyPermission("java.version", "read"));
            permissions.add(new PropertyPermission("os.name", "read"));
            permissions.add(new PropertyPermission("line.separator", "read"));
            permissions.add(new SocketPermission(location.getHost(), "connect,resolve"));
            permissions.add(new AWTPermission("accessEventQueue"));
            String hostName = location.getHost();
            Collection<String> domains = Domains.getPossibleDomains(hostName);
            for (String domain : domains) {
                permissions.add(StoreHostPermission.forHost(domain));
            }
        }
        return permissions;
    }

    @Override
    public void refresh() {
    }

    static {
        File settingsDir;
        instance = new LocalSecurityPolicy();
        BASE_PRIVILEGE = new LinkedList<Permission>();
        File homeDir = new File(System.getProperty("user.home"));
        STORE_DIRECTORY = settingsDir = new File(homeDir, STORE_DIR_NAME);
        String settingsCanonical = "";
        try {
            settingsCanonical = settingsDir.getCanonicalPath();
        }
        catch (IOException ioe) {
            ioe.printStackTrace(System.err);
        }
        STORE_DIRECTORY_CANONICAL = settingsCanonical;
        Collection<Permission> permissions = BASE_PRIVILEGE;
        permissions.add(new PropertyPermission("*", "read,write"));
        permissions.add(new AWTPermission("*"));
        permissions.add(new HistoryPermission());
        permissions.add(new SocketPermission("*", "connect,resolve,listen,accept"));
        permissions.add(new RuntimePermission("createClassLoader"));
        permissions.add(new RuntimePermission("getClassLoader"));
        permissions.add(new RuntimePermission("exitVM"));
        permissions.add(new RuntimePermission("setIO"));
        permissions.add(new RuntimePermission("setContextClassLoader"));
        permissions.add(new RuntimePermission("enableContextClassLoaderOverride"));
        permissions.add(new RuntimePermission("setFactory"));
        permissions.add(new RuntimePermission("accessClassInPackage.*"));
        permissions.add(new RuntimePermission("defineClassInPackage.*"));
        permissions.add(new RuntimePermission("accessDeclaredMembers"));
        permissions.add(new RuntimePermission("getStackTrace"));
        permissions.add(new RuntimePermission("preferences"));
        permissions.add(new RuntimePermission("modifyThreadGroup"));
        permissions.add(new RuntimePermission("getProtectionDomain"));
        permissions.add(new RuntimePermission("shutdownHooks"));
        permissions.add(new RuntimePermission("modifyThread"));
        permissions.add(new RuntimePermission("queuePrintJob"));
        permissions.add(new RuntimePermission("com.sun.media.jmc.accessMedia"));
        permissions.add(new RuntimePermission("loadLibrary.*"));
        permissions.add(new NetPermission("setDefaultAuthenticator"));
        permissions.add(new NetPermission("setCookieHandler"));
        permissions.add(new NetPermission("specifyStreamHandler"));
        permissions.add(new SSLPermission("setHostnameVerifier"));
        permissions.add(new SSLPermission("getSSLSessionContext"));
        permissions.add(new SecurityPermission("putProviderProperty.*"));
        permissions.add(new SecurityPermission("insertProvider.*"));
        permissions.add(new SecurityPermission("removeProvider.*"));
        permissions.add(new LoggingPermission("control", null));
        permissions.add(GenericLocalPermission.EXT_GENERIC);
        permissions.add(new FilePermission("<<ALL FILES>>", "read,write,delete,execute"));
    }
}

