/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.request;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.lobobrowser.settings.GeneralSettings;
import org.lobobrowser.ua.UserAgent;

public class UserAgentImpl
implements UserAgent {
    private static final UserAgentImpl instance = new UserAgentImpl();
    private volatile String textValue = null;

    private UserAgentImpl() {
    }

    public static UserAgentImpl getInstance() {
        return instance;
    }

    @Override
    public String getName() {
        return "Lobo";
    }

    public String getMajorVersion() {
        return "0";
    }

    public String getMinorVersion() {
        return "98.6";
    }

    @Override
    public String getVersion() {
        return this.getMajorVersion() + "." + this.getMinorVersion();
    }

    @Override
    public String getJavaVersion() {
        return System.getProperty("java.version");
    }

    @Override
    public String getUserAgentString() {
        String tv = this.textValue;
        if (tv == null) {
            GeneralSettings settings = AccessController.doPrivileged(new PrivilegedAction<GeneralSettings>(){

                @Override
                public GeneralSettings run() {
                    return GeneralSettings.getInstance();
                }
            });
            boolean spoofIE = settings.isSpoofIE();
            String ieVersion = settings.getIeVersion();
            this.textValue = tv = "Mozilla/" + settings.getMozVersion() + " (compatible" + (spoofIE ? "; MSIE " + ieVersion : "") + "; " + this.getOs() + ") " + this.getName() + "/" + this.getVersion();
        }
        return tv;
    }

    public String toString() {
        return this.getUserAgentString();
    }

    public void invalidateUserAgent() {
        this.textValue = null;
    }

    @Override
    public String getNameAndVersion() {
        return this.getName() + " " + this.getVersion();
    }

    @Override
    public String getInfoUrl() {
        return "http://sourceforge.net/projects/loboevolution/";
    }

    private String getOs() {
        return System.getProperty("os.name") + " " + System.getProperty("os.version");
    }
}

