/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.request;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import org.lobobrowser.util.NameValuePair;
import org.lobobrowser.util.io.IORoutines;

public class MemoryCacheEntry {
    public final byte[] content;
    public final List<NameValuePair> headers;
    public final Long expiration;
    public final Object altObject;
    public final long requestTime;
    public final int altObjectSize;

    public MemoryCacheEntry(byte[] content, List<NameValuePair> headers, Long expiration, Object altObject, int altObjectSize) {
        this.content = content;
        this.headers = headers;
        this.expiration = expiration;
        this.altObject = altObject;
        this.altObjectSize = altObjectSize;
        this.requestTime = System.currentTimeMillis();
    }

    public MemoryCacheEntry(byte[] rawContent, Long expires, long requestTime, Object altObject, int altObjectSize) throws IOException {
        String line;
        ByteArrayInputStream in = new ByteArrayInputStream(rawContent);
        LinkedList<NameValuePair> headersList = new LinkedList<NameValuePair>();
        while ((line = IORoutines.readLine(in)) != null && !"".equals(line)) {
            int colonIdx = line.indexOf(58);
            String name = colonIdx == -1 ? "" : line.substring(0, colonIdx).trim().toLowerCase();
            String value = colonIdx == -1 ? line.trim() : line.substring(colonIdx + 1).trim();
            headersList.add(new NameValuePair(name, value));
        }
        int remainingLength = in.available();
        int offset = rawContent.length - remainingLength;
        byte[] remainingContent = new byte[remainingLength];
        System.arraycopy(rawContent, offset, remainingContent, 0, remainingLength);
        this.content = remainingContent;
        this.headers = headersList;
        this.expiration = expires;
        this.requestTime = requestTime;
        this.altObject = altObject;
        this.altObjectSize = altObjectSize;
    }
}

