/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.request;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.lobobrowser.util.NameValuePair;
import org.lobobrowser.util.io.IORoutines;

public class FileWithHeadersURLConnection
extends HttpURLConnection {
    private final byte[] content;
    private boolean connected = false;
    private InputStream inputStream;
    private final Map<String, List<String>> headersMap = new HashMap<String, List<String>>();
    private final List<NameValuePair> headersList = new ArrayList<NameValuePair>();

    public FileWithHeadersURLConnection(URL url, byte[] content) {
        super(url);
        this.content = content;
    }

    @Override
    public void disconnect() {
        InputStream in;
        if (this.connected && (in = this.inputStream) != null) {
            try {
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public void connect() throws IOException {
        if (!this.connected) {
            ByteArrayInputStream in = new ByteArrayInputStream(this.content);
            try {
                this.inputStream = in;
                this.readHeaders(in);
            }
            finally {
                this.connected = true;
            }
        }
    }

    private void readHeaders(InputStream in) throws IOException {
        String line;
        List<NameValuePair> headersList = this.headersList;
        Map<String, List<String>> headersMap = this.headersMap;
        while ((line = IORoutines.readLine(in)) != null && !"".equals(line)) {
            int colonIdx = line.indexOf(58);
            String name = colonIdx == -1 ? "" : line.substring(0, colonIdx).trim().toLowerCase();
            String value = colonIdx == -1 ? line.trim() : line.substring(colonIdx + 1).trim();
            List<String> hvalues = headersMap.get(name);
            if (hvalues == null) {
                hvalues = new ArrayList<String>(1);
                headersMap.put(name, hvalues);
            }
            hvalues.add(value);
            headersList.add(new NameValuePair(name, value));
        }
    }

    @Override
    public InputStream getInputStream() throws IOException {
        this.connect();
        return this.inputStream;
    }

    @Override
    public String getHeaderField(int n) {
        try {
            this.connect();
            NameValuePair pair = this.headersList.get(n);
            return pair.value;
        }
        catch (IndexOutOfBoundsException iob) {
            return null;
        }
        catch (IOException ioe) {
            return null;
        }
    }

    @Override
    public String getHeaderField(String name) {
        try {
            this.connect();
        }
        catch (IOException ioe) {
            return null;
        }
        List<String> hvalues = this.headersMap.get(name.toLowerCase());
        if (hvalues == null || hvalues.size() == 0) {
            return null;
        }
        return hvalues.get(0);
    }

    @Override
    public String getHeaderFieldKey(int n) {
        try {
            this.connect();
            NameValuePair pair = this.headersList.get(n);
            return pair.name;
        }
        catch (IndexOutOfBoundsException iob) {
            return null;
        }
        catch (IOException ioe) {
            return null;
        }
    }

    @Override
    public Map<String, List<String>> getHeaderFields() {
        try {
            this.connect();
        }
        catch (IOException ioe) {
            return null;
        }
        return this.headersMap;
    }

    @Override
    public boolean usingProxy() {
        return false;
    }
}

