/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.request;

import java.io.IOException;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.lobobrowser.request.Cookie;
import org.lobobrowser.request.CookieValue;
import org.lobobrowser.store.RestrictedStore;
import org.lobobrowser.store.StorageManager;
import org.lobobrowser.util.Domains;
import org.lobobrowser.util.Strings;

public class CookieStore {
    private static final String COOKIE_PATH_PREFIX = ".W$Cookies/";
    private static final String COOKIE_PATH_PATTERN = "\\.W\\$Cookies/.*";
    private static final DateFormat EXPIRES_FORMAT;
    private static final DateFormat EXPIRES_FORMAT_BAK1;
    private static final DateFormat EXPIRES_FORMAT_BAK2;
    private static final CookieStore instance;
    private static final Logger logger;
    private final Map<String, Map<String, CookieValue>> transientMapByHost = new HashMap<String, Map<String, CookieValue>>();

    private CookieStore() {
    }

    public static CookieStore getInstance() {
        return instance;
    }

    public void saveCookie(URL url, String cookieSpec) {
        this.saveCookie(url.getHost(), cookieSpec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveCookie(String urlHostName, String cookieSpec) {
        if (logger.isLoggable(Level.INFO)) {
            logger.info("saveCookie(): host=" + urlHostName + ",cookieSpec=[" + cookieSpec + "]");
        }
        StringTokenizer tok = new StringTokenizer(cookieSpec, ";");
        String cookieName = null;
        String cookieValue = null;
        String domain = null;
        String path = null;
        String expires = null;
        String maxAge = null;
        boolean hasCookieName = false;
        while (tok.hasMoreTokens()) {
            String value;
            String token = tok.nextToken();
            int idx = token.indexOf(61);
            String name = idx == -1 ? token.trim() : token.substring(0, idx).trim();
            String string = value = idx == -1 ? "" : Strings.unquote(token.substring(idx + 1).trim());
            if (!hasCookieName) {
                cookieName = name;
                cookieValue = value;
                hasCookieName = true;
                continue;
            }
            if ("max-age".equalsIgnoreCase(name)) {
                maxAge = value;
                continue;
            }
            if ("path".equalsIgnoreCase(name)) {
                path = value;
                continue;
            }
            if ("domain".equalsIgnoreCase(name)) {
                domain = value;
                continue;
            }
            if ("expires".equalsIgnoreCase(name)) {
                expires = value;
                continue;
            }
            if (!"secure".equalsIgnoreCase(name)) continue;
        }
        if (cookieName == null) {
            logger.log(Level.SEVERE, "saveCookie(): Invalid cookie spec from '" + urlHostName + "'");
            return;
        }
        if (path == null || path.length() == 0) {
            path = "/";
        }
        if (domain != null) {
            if (expires == null && maxAge == null && logger.isLoggable(Level.INFO)) {
                logger.log(Level.INFO, "saveCookie(): Not rejecting transient cookie that specifies domain '" + domain + "'.");
            }
            if (!Domains.isValidCookieDomain(domain, urlHostName)) {
                logger.log(Level.WARNING, "saveCookie(): Rejecting cookie with invalid domain '" + domain + "' for host '" + urlHostName + "'.");
                return;
            }
        }
        if (domain == null) {
            domain = urlHostName;
        } else if (domain.startsWith(".")) {
            domain = domain.substring(1);
        }
        Date expiresDate = null;
        if (maxAge != null) {
            try {
                expiresDate = new Date(System.currentTimeMillis() + (long)(Integer.parseInt(maxAge) * 1000));
            }
            catch (NumberFormatException nfe) {
                logger.log(Level.WARNING, "saveCookie(): Max-age is not formatted correctly: " + maxAge + ".");
            }
        } else if (expires != null) {
            DateFormat dateFormat = EXPIRES_FORMAT;
            synchronized (dateFormat) {
                try {
                    expiresDate = EXPIRES_FORMAT.parse(expires);
                }
                catch (Exception pe) {
                    if (logger.isLoggable(Level.INFO)) {
                        logger.log(Level.INFO, "saveCookie(): Bad date format: " + expires + ". Will try again.", pe);
                    }
                    try {
                        expiresDate = EXPIRES_FORMAT_BAK1.parse(expires);
                    }
                    catch (Exception pe2) {
                        try {
                            expiresDate = EXPIRES_FORMAT_BAK2.parse(expires);
                        }
                        catch (Exception pe3) {
                            logger.log(Level.SEVERE, "saveCookie(): Giving up on cookie date format: " + expires, pe3);
                            return;
                        }
                    }
                }
            }
        }
        this.saveCookie(domain, path, cookieName, expiresDate, cookieValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveCookie(String domain, String path, String name, Date expires, String value) {
        if (logger.isLoggable(Level.INFO)) {
            logger.info("saveCookie(): domain=" + domain + ",name=" + name + ",expires=" + expires + ",value=[" + value + "].");
        }
        Long expiresLong = expires == null ? null : Long.valueOf(expires.getTime());
        CookieValue cookieValue = new CookieValue(value, path, domain, expiresLong);
        CookieStore cookieStore = this;
        synchronized (cookieStore) {
            Map<String, CookieValue> hostMap = this.transientMapByHost.get(domain);
            if (hostMap == null) {
                hostMap = new HashMap<String, CookieValue>(2);
                this.transientMapByHost.put(domain, hostMap);
            }
            hostMap.put(name, cookieValue);
        }
        if (expiresLong != null) {
            try {
                RestrictedStore store = StorageManager.getInstance().getRestrictedStore(domain, true);
                store.saveObject(this.getPathFromCookieName(name), cookieValue);
            }
            catch (IOException ioe) {
                logger.log(Level.WARNING, "saveCookie(): Unable to save cookie named '" + name + "' with domain '" + domain + "'", ioe);
            }
        }
    }

    private String getPathFromCookieName(String cookieName) {
        return COOKIE_PATH_PREFIX + cookieName;
    }

    private String getCookieNameFromPath(String path) {
        if (!path.startsWith(COOKIE_PATH_PREFIX)) {
            throw new IllegalArgumentException("Invalid path: " + path);
        }
        return path.substring(COOKIE_PATH_PREFIX.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<Cookie> getCookiesStrict(String hostName, String path) {
        LinkedList<Cookie> cookies;
        block20: {
            if (path == null || path.length() == 0) {
                path = "/";
            }
            boolean liflag = logger.isLoggable(Level.INFO);
            cookies = new LinkedList<Cookie>();
            Cookie cookie = new Cookie();
            HashSet<String> transientCookieNames = new HashSet<String>();
            CookieStore cookieStore = this;
            synchronized (cookieStore) {
                Map<String, CookieValue> hostMap = this.transientMapByHost.get(hostName);
                if (hostMap != null) {
                    for (Map.Entry<String, CookieValue> entry : hostMap.entrySet()) {
                        CookieValue cookieValue = entry.getValue();
                        if (cookieValue.isExpired()) {
                            if (!liflag) continue;
                            logger.info("getCookiesStrict(): Cookie " + entry.getKey() + " from " + hostName + " expired: " + cookieValue.getExpires());
                            continue;
                        }
                        if (path.startsWith(cookieValue.getPath())) {
                            String cookieName = entry.getKey();
                            transientCookieNames.add(cookieName);
                            cookie.setName(cookieName);
                            cookie.setValue(cookieValue.getValue());
                            cookie.setPath(cookieValue.getPath());
                            cookie.setDomain(cookieValue.getDomain());
                            cookies.add(cookie);
                            continue;
                        }
                        if (!liflag) continue;
                        logger.info("getCookiesStrict(): Skipping cookie " + cookieValue + " since it does not match path " + path);
                    }
                }
            }
            try {
                RestrictedStore store = StorageManager.getInstance().getRestrictedStore(hostName, false);
                if (store == null) break block20;
                Collection paths = store.getPaths(COOKIE_PATH_PATTERN);
                for (String filePath : paths) {
                    String cookieName = this.getCookieNameFromPath(filePath);
                    if (transientCookieNames.contains(cookieName)) continue;
                    CookieValue cookieValue = (CookieValue)store.retrieveObject(filePath);
                    if (cookieValue != null) {
                        if (cookieValue.isExpired()) {
                            if (logger.isLoggable(Level.INFO)) {
                                logger.info("getCookiesStrict(): Cookie " + cookieName + " from " + hostName + " expired: " + cookieValue.getExpires());
                            }
                            store.removeObject(filePath);
                            continue;
                        }
                        if (path.startsWith(cookieValue.getPath())) {
                            CookieStore cookieStore2 = this;
                            synchronized (cookieStore2) {
                                Map<String, CookieValue> hostMap = this.transientMapByHost.get(hostName);
                                if (hostMap == null) {
                                    hostMap = new HashMap<String, CookieValue>();
                                    this.transientMapByHost.put(hostName, hostMap);
                                }
                                hostMap.put(cookieName, cookieValue);
                            }
                            cookie.setName(cookieName);
                            cookie.setValue(cookieValue.getValue());
                            cookie.setPath(cookieValue.getPath());
                            cookie.setDomain(cookieValue.getDomain());
                            cookies.add(cookie);
                            continue;
                        }
                        if (!logger.isLoggable(Level.INFO)) continue;
                        logger.info("getCookiesStrict(): Skipping cookie " + cookieValue + " since it does not match path " + path);
                        continue;
                    }
                    logger.warning("getCookiesStrict(): Expected to find cookie named " + cookieName + " but file is missing.");
                }
            }
            catch (IOException ioe) {
                logger.log(Level.SEVERE, "getCookiesStrict()", ioe);
            }
            catch (ClassNotFoundException cnf) {
                logger.log(Level.SEVERE, "getCookiesStrict(): Possible engine versioning error.", cnf);
            }
        }
        return cookies;
    }

    public Collection<Cookie> getCookies(String hostName, String path) {
        Collection<String> possibleDomains = Domains.getPossibleDomains(hostName);
        LinkedList<Cookie> cookies = new LinkedList<Cookie>();
        for (String domain : possibleDomains) {
            cookies.addAll(this.getCookiesStrict(domain, path));
        }
        if (logger.isLoggable(Level.INFO)) {
            logger.info("getCookies(): For host=" + hostName + ", found " + cookies.size() + " cookies: " + cookies);
        }
        return cookies;
    }

    static {
        instance = new CookieStore();
        logger = Logger.getLogger(CookieStore.class.getName());
        Locale locale = Locale.US;
        SimpleDateFormat ef1 = new SimpleDateFormat("EEE, dd MMM yy HH:mm:ss 'GMT'", locale);
        SimpleDateFormat ef2 = new SimpleDateFormat("EEE, dd-MMM-yy HH:mm:ss 'GMT'", locale);
        SimpleDateFormat ef3 = new SimpleDateFormat("EEE, dd-MMM-yyyy HH:mm:ss 'UTC'", locale);
        TimeZone gmtTimeZone = TimeZone.getTimeZone("GMT");
        ef1.setTimeZone(gmtTimeZone);
        ef2.setTimeZone(gmtTimeZone);
        ef3.setTimeZone(gmtTimeZone);
        EXPIRES_FORMAT = ef1;
        EXPIRES_FORMAT_BAK1 = ef2;
        EXPIRES_FORMAT_BAK2 = ef3;
    }
}

