/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.primary.settings;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;

public class SearchEngine
implements Serializable {
    private static final long serialVersionUID = 225745010000001000L;
    private final String name;
    private final String description;
    private final String baseUrl;
    private final String queryParameter;

    public SearchEngine(String name, String description, String baseUrl, String queryParameter) {
        this.name = name;
        this.description = description;
        this.baseUrl = baseUrl;
        this.queryParameter = queryParameter;
    }

    public URL getURL(String query) throws MalformedURLException {
        String baseUrl = this.baseUrl;
        int qmIdx = baseUrl.indexOf(63);
        char join = qmIdx == -1 ? (char)'?' : '&';
        try {
            return new URL(baseUrl + join + this.queryParameter + "=" + URLEncoder.encode(query, "UTF-8"));
        }
        catch (UnsupportedEncodingException uee) {
            throw new IllegalStateException("not expected", uee);
        }
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public String getQueryParameter() {
        return this.queryParameter;
    }

    public String toString() {
        return this.name;
    }
}

