/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.primary.gui.prefs;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.lobobrowser.primary.gui.prefs.AbstractSettingsUI;
import org.lobobrowser.primary.gui.prefs.PreferencesPanel;
import org.lobobrowser.primary.gui.prefs.PreferencesTree;
import org.lobobrowser.primary.gui.prefs.SettingsInfo;

public class PreferencesDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private final PreferencesPanel preferencesPanel = new PreferencesPanel();
    private final PreferencesTree preferencesTree = new PreferencesTree();

    public PreferencesDialog(Frame parent) throws HeadlessException {
        super(parent);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BoxLayout(contentPane, 0));
        contentPane.add(this.createLeftPane());
        contentPane.add(this.createRightPane(this.preferencesPanel));
        this.preferencesTree.initSelection();
    }

    private Component createLeftPane() {
        PreferencesTree prefsTree = this.preferencesTree;
        prefsTree.addTreeSelectionListener(new LocalTreeSelectionListener());
        JScrollPane scrollPane = new JScrollPane(prefsTree);
        Dimension size = new Dimension(150, 200);
        scrollPane.setPreferredSize(size);
        scrollPane.setMinimumSize(size);
        scrollPane.setMaximumSize(new Dimension(150, Short.MAX_VALUE));
        return scrollPane;
    }

    private Component createRightPane(Container prefsPanel) {
        JPanel rightPanel = new JPanel();
        rightPanel.setLayout(new BoxLayout(rightPanel, 1));
        rightPanel.add(prefsPanel);
        rightPanel.add(this.createButtonsPanel());
        return rightPanel;
    }

    private Component createButtonsPanel() {
        JPanel buttonsPanel = new JPanel();
        buttonsPanel.setBorder(new EmptyBorder(4, 4, 4, 4));
        buttonsPanel.setLayout(new BoxLayout(buttonsPanel, 0));
        buttonsPanel.add(Box.createHorizontalGlue());
        JButton okButton = new JButton();
        okButton.setAction(new OkAction());
        okButton.setText("OK");
        JButton cancelButton = new JButton();
        cancelButton.setAction(new CancelAction());
        cancelButton.setText("Cancel");
        JButton applyButton = new JButton();
        applyButton.setAction(new ApplyAction());
        applyButton.setText("Apply");
        JButton defaultsButton = new JButton();
        defaultsButton.setAction(new DefaultsAction());
        defaultsButton.setText("Restore Defaults");
        buttonsPanel.add(okButton);
        buttonsPanel.add(cancelButton);
        buttonsPanel.add(applyButton);
        buttonsPanel.add(defaultsButton);
        return buttonsPanel;
    }

    private void updatePreferencesPanel(SettingsInfo settingsInfo) {
        if (settingsInfo != null) {
            AbstractSettingsUI newUI = settingsInfo.createSettingsUI();
            this.preferencesPanel.setSettingsUI(newUI);
        } else {
            this.preferencesPanel.setSettingsUI(null);
        }
    }

    private class LocalTreeSelectionListener
    implements TreeSelectionListener {
        private LocalTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            TreePath path = e.getPath();
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            SettingsInfo si = node == null ? null : (SettingsInfo)node.getUserObject();
            PreferencesDialog.this.updatePreferencesPanel(si);
        }
    }

    private class DefaultsAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private DefaultsAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (JOptionPane.showConfirmDialog(PreferencesDialog.this, "Are you sure you want to restore defaults?", "Confirm", 0) == 0) {
                PreferencesDialog.this.preferencesPanel.restoreDefaults();
            }
        }
    }

    private class ApplyAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private ApplyAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PreferencesDialog.this.preferencesPanel.save();
        }
    }

    private class CancelAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PreferencesDialog.this.dispose();
        }
    }

    private class OkAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private OkAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (PreferencesDialog.this.preferencesPanel.save()) {
                PreferencesDialog.this.dispose();
            }
        }
    }
}

